Liferay.Loader.define('document-library-web$lodash-es@4.17.15/xorWith', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import arrayFilter from './_arrayFilter.js';
  import baseRest from './_baseRest.js';
  import baseXor from './_baseXor.js';
  import isArrayLikeObject from './isArrayLikeObject.js';
  import last from './last.js';

  /**
   * This method is like `_.xor` except that it accepts `comparator` which is
   * invoked to compare elements of `arrays`. The order of result values is
   * determined by the order they occur in the arrays. The comparator is invoked
   * with two arguments: (arrVal, othVal).
   *
   * @static
   * @memberOf _
   * @since 4.0.0
   * @category Array
   * @param {...Array} [arrays] The arrays to inspect.
   * @param {Function} [comparator] The comparator invoked per element.
   * @returns {Array} Returns the new array of filtered values.
   * @example
   *
   * var objects = [{ 'x': 1, 'y': 2 }, { 'x': 2, 'y': 1 }];
   * var others = [{ 'x': 1, 'y': 1 }, { 'x': 1, 'y': 2 }];
   *
   * _.xorWith(objects, others, _.isEqual);
   * // => [{ 'x': 2, 'y': 1 }, { 'x': 1, 'y': 1 }]
   */
  var xorWith = baseRest(function (arrays) {
    var comparator = last(arrays);
    comparator = typeof comparator == 'function' ? comparator : undefined;
    return baseXor(arrayFilter(arrays, isArrayLikeObject), undefined, comparator);
  });

  export default xorWith;
});
//# sourceMappingURL=xorWith.js.map