Liferay.Loader.define('document-library-web$lodash-es@4.17.15/method', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseInvoke from './_baseInvoke.js';
  import baseRest from './_baseRest.js';

  /**
   * Creates a function that invokes the method at `path` of a given object.
   * Any additional arguments are provided to the invoked method.
   *
   * @static
   * @memberOf _
   * @since 3.7.0
   * @category Util
   * @param {Array|string} path The path of the method to invoke.
   * @param {...*} [args] The arguments to invoke the method with.
   * @returns {Function} Returns the new invoker function.
   * @example
   *
   * var objects = [
   *   { 'a': { 'b': _.constant(2) } },
   *   { 'a': { 'b': _.constant(1) } }
   * ];
   *
   * _.map(objects, _.method('a.b'));
   * // => [2, 1]
   *
   * _.map(objects, _.method(['a', 'b']));
   * // => [2, 1]
   */
  var method = baseRest(function (path, args) {
    return function (object) {
      return baseInvoke(object, path, args);
    };
  });

  export default method;
});
//# sourceMappingURL=method.js.map