Liferay.Loader.define('document-library-web$lodash-es@4.17.15/_isFlattenable', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import Symbol from './_Symbol.js';
  import isArguments from './isArguments.js';
  import isArray from './isArray.js';

  /** Built-in value references. */
  var spreadableSymbol = Symbol ? Symbol.isConcatSpreadable : undefined;

  /**
   * Checks if `value` is a flattenable `arguments` object or array.
   *
   * @private
   * @param {*} value The value to check.
   * @returns {boolean} Returns `true` if `value` is flattenable, else `false`.
   */
  function isFlattenable(value) {
    return isArray(value) || isArguments(value) || !!(spreadableSymbol && value && value[spreadableSymbol]);
  }

  export default isFlattenable;
});
//# sourceMappingURL=_isFlattenable.js.map