Liferay.Loader.define('document-library-web$lodash-es@4.17.15/_baseAggregator', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseEach from './_baseEach.js';

  /**
   * Aggregates elements of `collection` on `accumulator` with keys transformed
   * by `iteratee` and values set by `setter`.
   *
   * @private
   * @param {Array|Object} collection The collection to iterate over.
   * @param {Function} setter The function to set `accumulator` values.
   * @param {Function} iteratee The iteratee to transform keys.
   * @param {Object} accumulator The initial aggregated object.
   * @returns {Function} Returns `accumulator`.
   */
  function baseAggregator(collection, setter, iteratee, accumulator) {
    baseEach(collection, function (value, key, collection) {
      setter(accumulator, value, iteratee(value), collection);
    });
    return accumulator;
  }

  export default baseAggregator;
});
//# sourceMappingURL=_baseAggregator.js.map