/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.toolbar.contributor.helper;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryTypeServiceUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLFolderPermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class MenuItemProvider {
    private static final Log _log = LogFactoryUtil.getLog(MenuItemProvider.class);

    public List<MenuItem> getAddDocumentTypesMenuItems(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        long folderId = this._getFolderId(folder);
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_DOCUMENT")) {
            return Collections.emptyList();
        }
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        long repositoryId = this._getRepositoryId(folder, themeDisplay);
        if (themeDisplay.getScopeGroupId() == repositoryId) {
            menuItems.addAll(this._getPortletTitleAddDocumentTypeMenuItems(folder, themeDisplay, portletRequest));
        }
        return menuItems;
    }

    public MenuItem getAddFileMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        long folderId = this._getFolderId(folder);
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_DOCUMENT")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("upload");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)"file-upload"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "add");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(folder, themeDisplay)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public MenuItem getAddFolderMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        long folderId = this._getFolderId(folder);
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_FOLDER")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("folder");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)"folder"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_folder");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(folder, themeDisplay)));
        portletURL.setParameter("parentFolderId", String.valueOf(folderId));
        portletURL.setParameter("ignoreRootFolder", Boolean.TRUE.toString());
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public MenuItem getAddMultipleFilesMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        if (folder != null && !folder.isSupportsMultipleUpload()) {
            return null;
        }
        long folderId = this._getFolderId(folder);
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_DOCUMENT")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("upload-multiple");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)"multiple-files-upload"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/upload_multiple_file_entries");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(folder, themeDisplay)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public URLMenuItem getAddRepositoryMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        if (folder != null) {
            return null;
        }
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), 0L, "ADD_REPOSITORY")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("repository");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)"repository"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_repository");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public URLMenuItem getAddShortcutMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        if (folder != null && !folder.isSupportsShortcuts()) {
            return null;
        }
        long folderId = this._getFolderId(folder);
        if (!this._hasPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_SHORTCUT")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setIcon("shortcut");
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)"shortcut"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_shortcut");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(folder, themeDisplay)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    private MenuItem _getFileEntryTypeMenuItem(Folder folder, List<DLFileEntryType> fileEntryTypes, DLFileEntryType fileEntryType, ThemeDisplay themeDisplay, PortletRequest portletRequest) throws PortalException {
        URLMenuItem urlMenuItem = new URLMenuItem();
        String label = LanguageUtil.get((HttpServletRequest)PortalUtil.getHttpServletRequest((PortletRequest)portletRequest), (String)fileEntryType.getUnambiguousName(fileEntryTypes, themeDisplay.getScopeGroupId(), themeDisplay.getLocale()));
        urlMenuItem.setLabel(label);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "add");
        portletURL.setParameter("redirect", PortalUtil.getCurrentURL((PortletRequest)portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(folder, themeDisplay)));
        portletURL.setParameter("folderId", String.valueOf(this._getFolderId(folder)));
        portletURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryType.getFileEntryTypeId()));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    private List<DLFileEntryType> _getFileEntryTypes(long groupId, Folder folder) {
        DLFolder dlFolder;
        if (folder != null && !folder.isSupportsMetadata()) {
            return Collections.emptyList();
        }
        long folderId = this._getFolderId(folder);
        boolean inherited = true;
        if (folder != null && folder.getModel() instanceof DLFolder && (dlFolder = (DLFolder)folder.getModel()).getRestrictionType() == 1) {
            inherited = false;
        }
        try {
            return DLFileEntryTypeServiceUtil.getFolderFileEntryTypes((long[])PortalUtil.getCurrentAndAncestorSiteGroupIds((long)groupId), (long)folderId, (boolean)inherited);
        }
        catch (PortalException pe) {
            _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to get file entry types for group ", groupId, " and folder ", folderId}), (Throwable)pe);
            return Collections.emptyList();
        }
    }

    private long _getFolderId(Folder folder) {
        if (folder == null) {
            return 0L;
        }
        return folder.getFolderId();
    }

    private List<MenuItem> _getPortletTitleAddDocumentTypeMenuItems(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        List<DLFileEntryType> fileEntryTypes = this._getFileEntryTypes(themeDisplay.getScopeGroupId(), folder);
        for (DLFileEntryType fileEntryType : fileEntryTypes) {
            try {
                if (fileEntryType.getFileEntryTypeId() == 0L) continue;
                MenuItem urlMenuItem = this._getFileEntryTypeMenuItem(folder, fileEntryTypes, fileEntryType, themeDisplay, portletRequest);
                menuItems.add(urlMenuItem);
            }
            catch (PortalException pe) {
                _log.error((Object)("Unable to add menu item for file entry type " + fileEntryType.getName()), (Throwable)pe);
            }
        }
        return menuItems;
    }

    private long _getRepositoryId(Folder folder, ThemeDisplay themeDisplay) {
        if (folder == null) {
            return themeDisplay.getScopeGroupId();
        }
        return folder.getRepositoryId();
    }

    private boolean _hasPermission(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) {
        try {
            return DLFolderPermission.contains(permissionChecker, groupId, folderId, actionId);
        }
        catch (PortalException pe) {
            _log.error((Object)pe, (Throwable)pe);
            return false;
        }
    }
}

