/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileShortcutException;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.util.RawMetadataProcessorUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLPermission;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.RepositoryServiceUtil;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import java.util.ArrayList;
import java.util.List;
import javax.portlet.PortletPreferences;
import javax.portlet.PortletRequest;
import javax.servlet.http.HttpServletRequest;

public class ActionUtil {
    private static final Log _log = LogFactoryUtil.getLog(ActionUtil.class);

    public static List<FileEntry> getFileEntries(HttpServletRequest httpServletRequest) throws PortalException {
        long[] fileEntryIds;
        ArrayList<FileEntry> fileEntries = new ArrayList<FileEntry>();
        for (long fileEntryId : fileEntryIds = ParamUtil.getLongValues((HttpServletRequest)httpServletRequest, (String)"rowIdsFileEntry")) {
            try {
                FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
                fileEntries.add(fileEntry);
            }
            catch (NoSuchFileEntryException nsfee) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsfee, (Throwable)nsfee);
            }
        }
        return fileEntries;
    }

    public static List<FileEntry> getFileEntries(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileEntries(httpServletRequest);
    }

    public static FileEntry getFileEntry(HttpServletRequest httpServletRequest) throws PortalException {
        long fileEntryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"fileEntryId");
        if (fileEntryId <= 0L) {
            return null;
        }
        FileEntry fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        String cmd = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"cmd");
        if (fileEntry.isInTrash() && !cmd.equals("move_from_trash")) {
            throw new NoSuchFileEntryException("{fileEntryId=" + fileEntryId + "}");
        }
        return fileEntry;
    }

    public static FileEntry getFileEntry(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileEntry(httpServletRequest);
    }

    public static FileShortcut getFileShortcut(HttpServletRequest httpServletRequest) throws PortalException {
        long fileShortcutId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"fileShortcutId");
        if (fileShortcutId <= 0L) {
            return null;
        }
        return DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
    }

    public static FileShortcut getFileShortcut(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileShortcut(httpServletRequest);
    }

    public static List<FileShortcut> getFileShortcuts(HttpServletRequest httpServletRequest) throws PortalException {
        long[] fileShortcutIds = ParamUtil.getLongValues((HttpServletRequest)httpServletRequest, (String)"rowIdsDLFileShortcut");
        ArrayList<FileShortcut> fileShortcuts = new ArrayList<FileShortcut>();
        for (long fileShortcutId : fileShortcutIds) {
            try {
                fileShortcuts.add(DLAppServiceUtil.getFileShortcut((long)fileShortcutId));
            }
            catch (NoSuchFileShortcutException nsfse) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsfse, (Throwable)nsfse);
            }
        }
        return fileShortcuts;
    }

    public static List<FileShortcut> getFileShortcuts(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileShortcuts(httpServletRequest);
    }

    public static FileVersion getFileVersion(HttpServletRequest httpServletRequest, FileEntry fileEntry) throws PortalException {
        if (fileEntry == null) {
            return null;
        }
        FileVersion fileVersion = null;
        String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
        fileVersion = Validator.isNotNull((String)version) ? fileEntry.getFileVersion(version) : fileEntry.getFileVersion();
        if (RawMetadataProcessorUtil.isSupported((FileVersion)fileVersion)) {
            RawMetadataProcessorUtil.generateMetadata((FileVersion)fileVersion);
        }
        return fileVersion;
    }

    public static FileVersion getFileVersion(PortletRequest portletRequest, FileEntry fileEntry) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFileVersion(httpServletRequest, fileEntry);
    }

    public static Folder getFolder(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"folderId");
        boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)httpServletRequest, (String)"ignoreRootFolder");
        if (folderId <= 0L && !ignoreRootFolder) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            String portletId = portletDisplay.getId();
            PortletPreferences portletPreferences = PortletPreferencesFactoryUtil.getPortletPreferences((HttpServletRequest)httpServletRequest, (String)portletId);
            folderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        }
        if (folderId <= 0L) {
            DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
            return null;
        }
        Folder folder = DLAppServiceUtil.getFolder((long)folderId);
        if (folder.isMountPoint()) {
            com.liferay.portal.kernel.repository.Repository repository = RepositoryProviderUtil.getRepository((long)folder.getRepositoryId());
            folder = repository.getFolder(folder.getFolderId());
        }
        if (!folder.isRepositoryCapabilityProvided(TrashCapability.class)) {
            return folder;
        }
        TrashCapability trashCapability = (TrashCapability)folder.getRepositoryCapability(TrashCapability.class);
        if (trashCapability.isInTrash(folder)) {
            throw new NoSuchFolderException("{folderId=" + folderId + "}");
        }
        return folder;
    }

    public static Folder getFolder(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolder(httpServletRequest);
    }

    public static List<Folder> getFolders(HttpServletRequest httpServletRequest) throws PortalException {
        long[] folderIds = ParamUtil.getLongValues((HttpServletRequest)httpServletRequest, (String)"rowIdsFolder");
        ArrayList<Folder> folders = new ArrayList<Folder>();
        for (long folderId : folderIds) {
            try {
                Folder folder = DLAppServiceUtil.getFolder((long)folderId);
                folders.add(folder);
            }
            catch (NoSuchFolderException nsfe) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)nsfe, (Throwable)nsfe);
            }
        }
        return folders;
    }

    public static List<Folder> getFolders(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getFolders(httpServletRequest);
    }

    public static Repository getRepository(HttpServletRequest httpServletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long repositoryId = ParamUtil.getLong((HttpServletRequest)httpServletRequest, (String)"repositoryId");
        if (repositoryId > 0L) {
            return RepositoryServiceUtil.getRepository((long)repositoryId);
        }
        DLPermission.check(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), "VIEW");
        return null;
    }

    public static Repository getRepository(PortletRequest portletRequest) throws PortalException {
        HttpServletRequest httpServletRequest = PortalUtil.getHttpServletRequest((PortletRequest)portletRequest);
        return ActionUtil.getRepository(httpServletRequest);
    }
}

