/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcut;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.web.internal.exportimport.portlet.preferences.processor.DLCommentsAndRatingsExporterImporterCapability;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.PortletDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.exportimport.staged.model.repository.StagedModelRepository;
import com.liferay.exportimport.staged.model.repository.StagedModelRepositoryRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.dao.orm.ExportActionableDynamicQuery;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet"}, service={DLExportImportPortletPreferencesProcessor.class, ExportImportPortletPreferencesProcessor.class})
public class DLExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DLExportImportPortletPreferencesProcessor.class);
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLCommentsAndRatingsExporterImporterCapability _dlCommentsAndRatingsExporterImporterCapability;
    @Reference(target="(javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet)")
    private PortletDataHandler _dlPortletDataHandler;
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _exportCapability;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _importCapability;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._dlCommentsAndRatingsExporterImporterCapability, this._exportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._dlCommentsAndRatingsExporterImporterCapability, this._importCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PORTLET_DATA") && MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return portletPreferences;
        }
        String portletId = portletDataContext.getPortletId();
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            Folder folder = null;
            try {
                folder = this._dlAppLocalService.getFolder(rootFolderId);
            }
            catch (PortalException pe) {
                StringBundler sb = new StringBundler(4);
                sb.append("Portlet ");
                sb.append(portletId);
                sb.append(" refers to an invalid root folder ID ");
                sb.append(rootFolderId);
                _log.error((Object)sb.toString());
                throw new PortletDataException(sb.toString(), (Throwable)pe);
            }
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)folder);
            return portletPreferences;
        }
        try {
            portletDataContext.addPortletPermissions("com.liferay.document.library");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_document_library_web_portlet_DLPortlet");
            pde.setType(18);
            throw pde;
        }
        try {
            StagedModelRepository stagedModelRepository;
            String namespace = this._dlPortletDataHandler.getNamespace();
            if (portletDataContext.getBooleanParameter(namespace, "folders")) {
                stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFolder.class.getName());
                ExportActionableDynamicQuery folderActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                folderActionableDynamicQuery.setPerformActionMethod(dlFolder -> {
                    if (dlFolder.isInTrash()) {
                        return;
                    }
                    Folder folder = this._dlAppLocalService.getFolder(dlFolder.getFolderId());
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)folder);
                });
                folderActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "documents")) {
                stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntry.class.getName());
                ExportActionableDynamicQuery fileEntryActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                fileEntryActionableDynamicQuery.setPerformActionMethod(dlFileEntry -> {
                    FileEntry fileEntry = this._dlAppLocalService.getFileEntry(dlFileEntry.getFileEntryId());
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)fileEntry);
                });
                fileEntryActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "document-types")) {
                stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileEntryType.class.getName());
                ExportActionableDynamicQuery fileEntryTypeActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                fileEntryTypeActionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> {
                    if (dlFileEntryType.isExportable()) {
                        StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)dlFileEntryType);
                    }
                });
                fileEntryTypeActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "repositories")) {
                stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)Repository.class.getName());
                ExportActionableDynamicQuery repositoryActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                repositoryActionableDynamicQuery.setPerformActionMethod(repository -> StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)repository));
                repositoryActionableDynamicQuery.performActions();
            }
            if (portletDataContext.getBooleanParameter(namespace, "shortcuts")) {
                stagedModelRepository = StagedModelRepositoryRegistryUtil.getStagedModelRepository((String)DLFileShortcut.class.getName());
                ExportActionableDynamicQuery fileShortcutActionableDynamicQuery = stagedModelRepository.getExportActionableDynamicQuery(portletDataContext);
                fileShortcutActionableDynamicQuery.setPerformActionMethod(dlFileShortcut -> {
                    FileShortcut fileShortcut = this._dlAppLocalService.getFileShortcut(dlFileShortcut.getFileShortcutId());
                    StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)fileShortcut);
                });
                fileShortcutActionableDynamicQuery.performActions();
            }
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_document_library_web_portlet_DLPortlet");
            pde.setType(11);
            throw pde;
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        Element foldersElement;
        List folderElements;
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId > 0L && !(folderElements = (foldersElement = portletDataContext.getImportDataGroupElement(DLFolder.class)).elements()).isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)folderElements.get(0)));
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class + ".folderIdsAndRepositoryEntryIds");
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            try {
                portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
            }
            catch (ReadOnlyException roe) {
                throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
            }
        }
        try {
            portletDataContext.importPortletPermissions("com.liferay.document.library");
        }
        catch (PortalException pe) {
            PortletDataException pde = new PortletDataException((Throwable)pe);
            pde.setPortletId("com_liferay_document_library_web_portlet_DLPortlet");
            pde.setType(20);
            throw pde;
        }
        String namespace = this._dlPortletDataHandler.getNamespace();
        if (portletDataContext.getBooleanParameter(namespace, "folders")) {
            Element foldersElement2 = portletDataContext.getImportDataGroupElement(DLFolder.class);
            List folderElements2 = foldersElement2.elements();
            for (Element folderElement : folderElements2) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)folderElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "documents")) {
            Element fileEntriesElement = portletDataContext.getImportDataGroupElement(DLFileEntry.class);
            List fileEntryElements = fileEntriesElement.elements();
            for (Element fileEntryElement : fileEntryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "document-types")) {
            Element fileEntryTypesElement = portletDataContext.getImportDataGroupElement(DLFileEntryType.class);
            List fileEntryTypeElements = fileEntryTypesElement.elements();
            for (Element fileEntryTypeElement : fileEntryTypeElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileEntryTypeElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "repositories")) {
            Element repositoriesElement = portletDataContext.getImportDataGroupElement(Repository.class);
            List repositoryElements = repositoriesElement.elements();
            for (Element repositoryElement : repositoryElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)repositoryElement);
            }
        }
        if (portletDataContext.getBooleanParameter(namespace, "shortcuts")) {
            Element fileShortcutsElement = portletDataContext.getImportDataGroupElement(DLFileShortcut.class);
            List fileShortcutElements = fileShortcutsElement.elements();
            for (Element fileShortcutElement : fileShortcutElements) {
                StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)fileShortcutElement);
            }
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

