/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.display.context.DLUIItemKeys;
import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.versioning.VersioningStrategy;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileEntryDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileShortcutDisplayContextHelper;
import com.liferay.document.library.web.internal.display.context.logic.FileVersionDisplayContextHelper;
import com.liferay.document.library.web.internal.util.DLTrashUtil;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandler;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerRegistryUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncStringWriter;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.language.UnicodeLanguageUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.portlet.PortletURLUtil;
import com.liferay.portal.kernel.repository.capabilities.TrashCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.BrowserSnifferUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.DeleteMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.JavaScriptUIItem;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLUIItem;
import com.liferay.portal.kernel.template.Template;
import com.liferay.portal.kernel.template.TemplateManagerUtil;
import com.liferay.portal.kernel.template.TemplateResource;
import com.liferay.portal.kernel.template.URLTemplateResource;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.TextFormatter;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.staging.StagingGroupHelper;
import com.liferay.staging.StagingGroupHelperUtil;
import com.liferay.taglib.security.PermissionsURLTag;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class UIItemsBuilder {
    private String _currentURL;
    private final DLTrashUtil _dlTrashUtil;
    private final DLURLHelper _dlURLHelper;
    private final FileEntry _fileEntry;
    private final FileEntryDisplayContextHelper _fileEntryDisplayContextHelper;
    private FileShortcut _fileShortcut;
    private final FileShortcutDisplayContextHelper _fileShortcutDisplayContextHelper;
    private final FileVersion _fileVersion;
    private final FileVersionDisplayContextHelper _fileVersionDisplayContextHelper;
    private final HttpServletRequest _httpServletRequest;
    private Boolean _ieOnWin32;
    private String _redirect;
    private final ResourceBundle _resourceBundle;
    private final ThemeDisplay _themeDisplay;
    private Boolean _trashEnabled;
    private final VersioningStrategy _versioningStrategy;

    public UIItemsBuilder(HttpServletRequest httpServletRequest, FileEntry fileEntry, FileVersion fileVersion, ResourceBundle resourceBundle, DLTrashUtil dlTrashUtil, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) {
        this(httpServletRequest, fileEntry, null, fileVersion, resourceBundle, dlTrashUtil, versioningStrategy, dlURLHelper);
    }

    public UIItemsBuilder(HttpServletRequest httpServletRequest, FileShortcut fileShortcut, ResourceBundle resourceBundle, DLTrashUtil dlTrashUtil, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) throws PortalException {
        this(httpServletRequest, null, fileShortcut, fileShortcut.getFileVersion(), resourceBundle, dlTrashUtil, versioningStrategy, dlURLHelper);
    }

    public UIItemsBuilder(HttpServletRequest httpServletRequest, FileVersion fileVersion, ResourceBundle resourceBundle, DLTrashUtil dlTrashUtil, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) {
        this(httpServletRequest, null, null, fileVersion, resourceBundle, dlTrashUtil, versioningStrategy, dlURLHelper);
    }

    public void addCancelCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null || !this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "cancel_checkout");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.CANCEL_CHECKOUT, "cancel-checkout[document]", portletURL.toString());
    }

    public void addCancelCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCancelCheckoutDocumentActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CANCEL_CHECKOUT, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"cancel-checkout[document]"), this.getSubmitFormJavaScript("cancel_checkout", null));
    }

    public void addCheckinMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null || !this._fileEntryDisplayContextHelper.isCheckinActionAvailable()) {
            return;
        }
        menuItems.add(this.getCheckinMenuItem());
    }

    public void addCheckinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckinActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkin");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        JavaScriptToolbarItem javaScriptToolbarItem = (JavaScriptToolbarItem)this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CHECKIN, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"checkin"), StringBundler.concat((Object[])new Object[]{this.getNamespace(), "showVersionDetailsDialog('", portletURL, "');"}));
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/checkin_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javaScriptToolbarItem.setJavaScript(unsyncStringWriter.toString());
    }

    public void addCheckoutMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null || !this._fileEntryDisplayContextHelper.isCheckoutDocumentActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkout");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.CHECKOUT, "checkout[document]", portletURL.toString());
    }

    public void addCheckoutToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isCheckoutDocumentActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.CHECKOUT, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"checkout[document]"), this.getSubmitFormJavaScript("checkout", null));
    }

    public void addCompareToMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!DocumentConversionUtil.isComparableVersion((String)this._fileVersion.getExtension())) {
            return;
        }
        PortletURL viewFileEntryURL = this._getRenderURL("/document_library/view_file_entry", this._getRedirect());
        PortletURL selectFileVersionURL = this._getRenderURL("/document_library/select_file_version", viewFileEntryURL.toString());
        try {
            selectFileVersionURL.setWindowState(LiferayWindowState.POP_UP);
        }
        catch (WindowStateException wse) {
            throw new PortalException((Throwable)wse);
        }
        selectFileVersionURL.setParameter("version", this._fileVersion.getVersion());
        HashMap<String, PortletURL> data = new HashMap<String, PortletURL>();
        data.put("uri", selectFileVersionURL);
        PortletURL compareVersionURL = this._getRenderURL("/document_library/compare_versions", null);
        compareVersionURL.setParameter("backURL", this._getCurrentURL());
        String jsNamespace = this.getNamespace() + this._fileVersion.getFileVersionId();
        StringBundler sb = new StringBundler(4);
        sb.append(jsNamespace);
        sb.append("compareVersionDialog('");
        sb.append(selectFileVersionURL.toString());
        sb.append("');");
        JavaScriptMenuItem javaScriptMenuItem = (JavaScriptMenuItem)this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptMenuItem(), (List)menuItems, DLUIItemKeys.COMPARE_TO, "compare-to", sb.toString());
        javaScriptMenuItem.setData(data);
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/compare_to_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"compareVersionURL", (Object)compareVersionURL.toString());
        template.put((Object)"dialogTitle", (Object)UnicodeLanguageUtil.get((HttpServletRequest)this._httpServletRequest, (String)"compare-versions"));
        template.put((Object)"jsNamespace", (Object)jsNamespace);
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javaScriptMenuItem.setJavaScript(unsyncStringWriter.toString());
    }

    public void addDeleteMenuItem(List<MenuItem> menuItems) throws PortalException {
        String cmd = null;
        if (this.isDeleteActionAvailable()) {
            cmd = "delete";
        } else if (this.isMoveToTheRecycleBinActionAvailable()) {
            cmd = "move_to_trash";
        } else {
            return;
        }
        DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
        deleteMenuItem.setKey(DLUIItemKeys.DELETE);
        if (cmd.equals("move_to_trash")) {
            deleteMenuItem.setTrash(true);
        }
        String mvcActionCommandName = "/document_library/edit_file_entry";
        if (this._fileShortcut != null) {
            mvcActionCommandName = "/document_library/edit_file_shortcut";
        }
        PortletURL portletURL = this._getDeleteActionURL(mvcActionCommandName, cmd);
        if (this._fileShortcut == null) {
            portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        } else {
            portletURL.setParameter("fileShortcutId", String.valueOf(this._fileShortcut.getFileShortcutId()));
        }
        deleteMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)deleteMenuItem);
    }

    public void addDeleteToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isDeleteActionAvailable()) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("if (confirm('");
        sb.append(UnicodeLanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"are-you-sure-you-want-to-delete-this"));
        sb.append("')) {");
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        long folderId = this._fileEntry.getFolderId();
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        sb.append(this.getSubmitFormJavaScript("delete", portletURL.toString()));
        sb.append("}");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.DELETE, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"delete"), sb.toString());
    }

    public void addDeleteVersionMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileEntry == null || this._fileVersion.getStatus() != 0 || !this._fileEntryDisplayContextHelper.hasDeletePermission() || !(this._fileEntry.getModel() instanceof DLFileEntry) || this._fileEntry.getFileVersionsCount(0) <= 1) {
            return;
        }
        PortletURL viewFileEntryURL = this._getRenderURL("/document_library/view_file_entry", this._getRedirect());
        DeleteMenuItem deleteMenuItem = new DeleteMenuItem();
        deleteMenuItem.setKey(DLUIItemKeys.DELETE_VERSION);
        deleteMenuItem.setLabel("delete-version");
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "delete", viewFileEntryURL.toString());
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        portletURL.setParameter("version", this._fileVersion.getVersion());
        deleteMenuItem.setURL(portletURL.toString());
        menuItems.add((MenuItem)deleteMenuItem);
    }

    public void addDownloadMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isDownloadActionAvailable()) {
            return;
        }
        String label = TextFormatter.formatStorageSize((double)this._fileEntry.getSize(), (Locale)this._themeDisplay.getLocale());
        label = StringBundler.concat((String[])new String[]{this._themeDisplay.translate("download"), " (", label, ")"});
        boolean appendVersion = !StringUtil.equalsIgnoreCase((String)this._fileEntry.getVersion(), (String)this._fileVersion.getVersion());
        String url = this._dlURLHelper.getDownloadURL(this._fileEntry, this._fileVersion, this._themeDisplay, "", appendVersion, true);
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.DOWNLOAD, label, url);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("senna-off", "true");
        urlMenuItem.setData(data);
        urlMenuItem.setMethod("get");
        urlMenuItem.setTarget("_blank");
    }

    public void addDownloadToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isDownloadActionAvailable()) {
            return;
        }
        String label = TextFormatter.formatStorageSize((double)this._fileEntry.getSize(), (Locale)this._themeDisplay.getLocale());
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, DLUIItemKeys.DOWNLOAD, StringBundler.concat((String[])new String[]{LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"download"), " (", label, ")"}), this._dlURLHelper.getDownloadURL(this._fileEntry, this._fileVersion, this._themeDisplay, ""));
    }

    public void addEditMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null && !this._fileShortcutDisplayContextHelper.isEditActionAvailable() || this._fileShortcut == null && !this._fileEntryDisplayContextHelper.isEditActionAvailable()) {
            return;
        }
        PortletURL portletURL = null;
        portletURL = this._fileShortcut == null ? this._getRenderURL("/document_library/edit_file_entry") : this._getRenderURL("/document_library/edit_file_shortcut");
        portletURL.setParameter("backURL", this._getCurrentURL());
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.EDIT, "edit", portletURL.toString());
    }

    public void addEditToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isEditActionAvailable()) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/edit_file_entry");
        this._addURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems, DLUIItemKeys.EDIT, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"edit"), portletURL.toString());
    }

    public void addMoveMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null && !this._fileShortcutDisplayContextHelper.isMoveActionAvailable() || this._fileShortcut == null && !this._fileEntryDisplayContextHelper.isMoveActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptMenuItem(), (List)menuItems, DLUIItemKeys.MOVE, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"move"), this._getMoveEntryOnClickJavaScript());
    }

    public void addMoveToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isMoveActionAvailable()) {
            return;
        }
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.MOVE, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"move"), this._getMoveEntryOnClickJavaScript());
    }

    public void addMoveToTheRecycleBinToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isMoveToTheRecycleBinActionAvailable()) {
            return;
        }
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        long folderId = this._fileEntry.getFolderId();
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.MOVE_TO_THE_RECYCLE_BIN, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"move-to-recycle-bin"), this.getSubmitFormJavaScript("move_to_trash", portletURL.toString()));
    }

    public void addOpenInMsOfficeMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (!this.isOpenInMsOfficeActionAvailable()) {
            return;
        }
        String webDavURL = this._dlURLHelper.getWebDavURL(this._themeDisplay, this._fileEntry.getFolder(), this._fileEntry, PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED, true);
        String onClick = StringBundler.concat((String[])new String[]{this.getNamespace(), "openDocument('", webDavURL, "');"});
        JavaScriptMenuItem javaScriptMenuItem = (JavaScriptMenuItem)this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptMenuItem(), (List)menuItems, DLUIItemKeys.OPEN_IN_MS_OFFICE, "open-in-ms-office", onClick);
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/open_in_ms_office_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"errorMessage", (Object)UnicodeLanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"cannot-open-the-requested-document-due-to-the-following-reason"));
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javaScriptMenuItem.setJavaScript(unsyncStringWriter.toString());
    }

    public void addOpenInMsOfficeToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this.isOpenInMsOfficeActionAvailable()) {
            return;
        }
        String webDavURL = this._dlURLHelper.getWebDavURL(this._themeDisplay, this._fileEntry.getFolder(), this._fileEntry, PropsValues.DL_FILE_ENTRY_OPEN_IN_MS_OFFICE_MANUAL_CHECK_IN_REQUIRED);
        StringBundler sb = new StringBundler(4);
        sb.append(this.getNamespace());
        sb.append("openDocument('");
        sb.append(webDavURL);
        sb.append("');");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.OPEN_IN_MS_OFFICE, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"open-in-ms-office"), sb.toString());
    }

    public void addPermissionsMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileShortcut != null && !this._fileShortcutDisplayContextHelper.isPermissionsButtonVisible() || this._fileShortcut == null && !this._fileEntryDisplayContextHelper.isPermissionsButtonVisible()) {
            return;
        }
        String url = null;
        try {
            url = this._fileShortcut != null ? PermissionsURLTag.doTag(null, (String)DLFileShortcutConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileShortcut.getToTitle()), null, (String)String.valueOf(this._fileShortcut.getFileShortcutId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest) : PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        URLMenuItem urlMenuItem = (URLMenuItem)this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.PERMISSIONS, "permissions", url);
        urlMenuItem.setMethod("get");
        urlMenuItem.setUseDialog(true);
    }

    public void addPermissionsToolbarItem(List<ToolbarItem> toolbarItems) throws PortalException {
        if (!this._fileEntryDisplayContextHelper.isPermissionsButtonVisible()) {
            return;
        }
        String permissionsURL = null;
        try {
            permissionsURL = PermissionsURLTag.doTag(null, (String)DLFileEntryConstants.getClassName(), (String)HtmlUtil.unescape((String)this._fileEntry.getTitle()), null, (String)String.valueOf(this._fileEntry.getFileEntryId()), (String)LiferayWindowState.POP_UP.toString(), null, (HttpServletRequest)this._httpServletRequest);
        }
        catch (Exception e) {
            throw new SystemException("Unable to create permissions URL", (Throwable)e);
        }
        StringBundler sb = new StringBundler(6);
        sb.append("Liferay.Util.openWindow({dialogIframe: {bodyCssClass: ");
        sb.append("'dialog-with-footer'}, title: '");
        sb.append(UnicodeLanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"permissions"));
        sb.append("', uri: '");
        sb.append(permissionsURL);
        sb.append("'});");
        this._addJavaScriptUIItem((JavaScriptUIItem)new JavaScriptToolbarItem(), (List)toolbarItems, DLUIItemKeys.PERMISSIONS, LanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"permissions"), sb.toString());
    }

    public void addPublishMenuItem(List<MenuItem> menuItems, boolean latestVersion) throws PortalException {
        if (!this._isFileVersionExportable(latestVersion)) {
            return;
        }
        StagingGroupHelper stagingGroupHelper = StagingGroupHelperUtil.getStagingGroupHelper();
        if (!stagingGroupHelper.isStagingGroup(this._themeDisplay.getScopeGroupId()) || !stagingGroupHelper.isStagedPortlet(this._themeDisplay.getScopeGroupId(), "com_liferay_document_library_web_portlet_DLPortlet")) {
            return;
        }
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        String portletName = portletDisplay.getPortletName();
        if (!portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return;
        }
        if (!(this._fileEntry != null && this._fileEntryDisplayContextHelper.hasExportImportPermission() || this._fileShortcut != null && !this._fileShortcutDisplayContextHelper.hasExportImportPermission())) {
            return;
        }
        StringBundler sb = new StringBundler(5);
        sb.append("javascript:if (confirm('");
        sb.append(UnicodeLanguageUtil.get((ResourceBundle)this._resourceBundle, (String)"are-you-sure-you-want-to-publish-the-selected-document"));
        sb.append("')){location.href = '");
        PortletURL portletURL = null;
        if (this._fileShortcut == null) {
            portletURL = this._getActionURL("/document_library/publish_file_entry");
            portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        } else {
            portletURL = this._getActionURL("/document_library/publish_file_shortcut");
            portletURL.setParameter("fileShortcutId", String.valueOf(this._fileShortcut.getFileShortcutId()));
        }
        portletURL.setParameter("redirect", "");
        portletURL.setParameter("backURL", this._getCurrentURL());
        sb.append((Object)portletURL);
        sb.append("';}");
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.PUBLISH, "publish-to-live", sb.toString());
    }

    public void addRevertToVersionMenuItem(List<MenuItem> menuItems) throws PortalException {
        if (this._fileVersion.getStatus() != 0 || !this._fileEntryDisplayContextHelper.hasUpdatePermission()) {
            return;
        }
        FileVersion latestFileVersion = this._fileEntry.getLatestFileVersion();
        String latestFileVersionVersion = latestFileVersion.getVersion();
        if (latestFileVersionVersion.equals(this._fileVersion.getVersion())) {
            return;
        }
        PortletURL viewFileEntryURL = this._getRenderURL("/document_library/view_file_entry", this._getRedirect());
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "revert", viewFileEntryURL.toString());
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        portletURL.setParameter("version", this._fileVersion.getVersion());
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.REVERT, "revert", portletURL.toString());
    }

    public void addViewOriginalFileMenuItem(List<MenuItem> menuItems) {
        if (this._fileShortcut == null) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileShortcut.getToFileEntryId()));
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.VIEW_ORIGINAL_FILE, "view-original-file", portletURL.toString());
    }

    public void addViewVersionMenuItem(List<MenuItem> menuItems) {
        if (this._fileShortcut != null) {
            return;
        }
        PortletURL portletURL = this._getRenderURL("/document_library/view_file_entry", this._getRedirect());
        portletURL.setParameter("version", this._fileVersion.getVersion());
        this._addURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems, DLUIItemKeys.VIEW_VERSION, "view[action]", portletURL.toString());
    }

    public MenuItem getCheckinMenuItem() throws PortalException {
        PortletURL portletURL = this._getActionURL("/document_library/edit_file_entry", "checkin");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        if (!this._versioningStrategy.isOverridable()) {
            URLMenuItem urlMenuItem = new URLMenuItem();
            urlMenuItem.setKey(DLUIItemKeys.CHECKIN);
            urlMenuItem.setLabel("checkin");
            urlMenuItem.setURL(portletURL.toString());
            return urlMenuItem;
        }
        JavaScriptMenuItem javaScriptMenuItem = new JavaScriptMenuItem();
        javaScriptMenuItem.setKey(DLUIItemKeys.CHECKIN);
        javaScriptMenuItem.setLabel("checkin");
        javaScriptMenuItem.setOnClick(StringBundler.concat((Object[])new Object[]{this.getNamespace(), "showVersionDetailsDialog('", portletURL, "');"}));
        String javaScript = "/com/liferay/document/library/web/display/context/dependencies/checkin_js.ftl";
        Class<?> clazz = this.getClass();
        URLTemplateResource urlTemplateResource = new URLTemplateResource(javaScript, clazz.getResource(javaScript));
        Template template = TemplateManagerUtil.getTemplate((String)"ftl", (TemplateResource)urlTemplateResource, (boolean)false);
        template.put((Object)"namespace", (Object)this.getNamespace());
        UnsyncStringWriter unsyncStringWriter = new UnsyncStringWriter();
        template.processTemplate((Writer)unsyncStringWriter);
        javaScriptMenuItem.setJavaScript(unsyncStringWriter.toString());
        return javaScriptMenuItem;
    }

    public boolean isOpenInMsOfficeActionAvailable() throws PortalException {
        return this._fileEntryDisplayContextHelper.hasViewPermission() && this._fileVersionDisplayContextHelper.isMsOffice() && this._isWebDAVEnabled() && this._isIEOnWin32();
    }

    protected String getNamespace() {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        return liferayPortletResponse.getNamespace();
    }

    protected String getSubmitFormJavaScript(String cmd, String redirect) {
        StringBundler sb = new StringBundler(18);
        sb.append("document.");
        sb.append(this.getNamespace());
        sb.append("fm.");
        sb.append(this.getNamespace());
        sb.append("cmd");
        sb.append(".value = '");
        sb.append(cmd);
        sb.append("';");
        if (redirect != null) {
            sb.append("document.");
            sb.append(this.getNamespace());
            sb.append("fm.");
            sb.append(this.getNamespace());
            sb.append("redirect.value = '");
            sb.append(redirect);
            sb.append("';");
        }
        sb.append("submitForm(document.");
        sb.append(this.getNamespace());
        sb.append("fm);");
        return sb.toString();
    }

    protected boolean isDeleteActionAvailable() throws PortalException {
        return this._fileShortcut != null && this._fileShortcutDisplayContextHelper.isFileShortcutDeletable() && !this._isFileShortcutTrashable() || this._fileShortcut == null && this._fileEntryDisplayContextHelper.isFileEntryDeletable() && !this._isFileEntryTrashable();
    }

    protected boolean isMoveToTheRecycleBinActionAvailable() throws PortalException {
        return !this.isDeleteActionAvailable() && (this._fileShortcut != null && this._fileShortcutDisplayContextHelper.isFileShortcutDeletable() || this._fileShortcut == null && this._fileEntryDisplayContextHelper.isFileEntryDeletable());
    }

    private UIItemsBuilder(HttpServletRequest httpServletRequest, FileEntry fileEntry, FileShortcut fileShortcut, FileVersion fileVersion, ResourceBundle resourceBundle, DLTrashUtil dlTrashUtil, VersioningStrategy versioningStrategy, DLURLHelper dlURLHelper) {
        try {
            this._httpServletRequest = httpServletRequest;
            if (fileEntry == null && fileVersion != null) {
                fileEntry = fileVersion.getFileEntry();
            }
            this._fileEntry = fileEntry;
            this._fileShortcut = fileShortcut;
            this._fileVersion = fileVersion;
            this._resourceBundle = resourceBundle;
            this._dlTrashUtil = dlTrashUtil;
            this._versioningStrategy = versioningStrategy;
            this._dlURLHelper = dlURLHelper;
            this._themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            this._fileEntryDisplayContextHelper = new FileEntryDisplayContextHelper(this._themeDisplay.getPermissionChecker(), this._fileEntry);
            this._fileShortcutDisplayContextHelper = new FileShortcutDisplayContextHelper(this._themeDisplay.getPermissionChecker(), this._fileShortcut);
            this._fileVersionDisplayContextHelper = new FileVersionDisplayContextHelper(fileVersion);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build UIItemsBuilder for " + fileVersion, (Throwable)pe);
        }
    }

    private <T extends JavaScriptUIItem> T _addJavaScriptUIItem(T javascriptUIItem, List<? super T> javascriptUIItems, String key, String label, String onClick) {
        javascriptUIItem.setKey(key);
        javascriptUIItem.setLabel(label);
        javascriptUIItem.setOnClick(onClick);
        javascriptUIItems.add(javascriptUIItem);
        return javascriptUIItem;
    }

    private <T extends URLUIItem> T _addURLUIItem(T urlUIItem, List<? super T> urlUIItems, String key, String label, String url) {
        urlUIItem.setKey(key);
        urlUIItem.setLabel(label);
        urlUIItem.setURL(url);
        urlUIItems.add(urlUIItem);
        return urlUIItem;
    }

    private PortletURL _getActionURL(String mvcActionCommandName) {
        return this._getActionURL(mvcActionCommandName, null);
    }

    private PortletURL _getActionURL(String mvcActionCommandName, String cmd) {
        return this._getActionURL(mvcActionCommandName, cmd, this._getCurrentURL());
    }

    private PortletURL _getActionURL(String mvcActionCommandName, String cmd, String redirect) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createActionURL();
        portletURL.setParameter("javax.portlet.action", mvcActionCommandName);
        if (Validator.isNotNull((String)cmd)) {
            portletURL.setParameter("cmd", cmd);
        }
        portletURL.setParameter("redirect", redirect);
        return portletURL;
    }

    private String _getCurrentURL() {
        if (this._currentURL != null) {
            return this._currentURL;
        }
        LiferayPortletRequest liferayPortletRequest = this._getLiferayPortletRequest();
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = PortletURLUtil.getCurrent((LiferayPortletRequest)liferayPortletRequest, (LiferayPortletResponse)liferayPortletResponse);
        this._currentURL = portletURL.toString();
        return this._currentURL;
    }

    private PortletURL _getDeleteActionURL(String mvcActionCommandName, String cmd) {
        String currentMVCRenderCommandName = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"mvcRenderCommandName");
        if (currentMVCRenderCommandName.equals("/document_library/view_file_entry")) {
            String redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
            if (Validator.isNull((String)redirect)) {
                LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
                PortletURL portletURL = liferayPortletResponse.createRenderURL();
                redirect = portletURL.toString();
            }
            return this._getActionURL(mvcActionCommandName, cmd, redirect);
        }
        return this._getActionURL(mvcActionCommandName, cmd);
    }

    private LiferayPortletRequest _getLiferayPortletRequest() {
        PortletRequest portletRequest = (PortletRequest)this._httpServletRequest.getAttribute("javax.portlet.request");
        return PortalUtil.getLiferayPortletRequest((PortletRequest)portletRequest);
    }

    private LiferayPortletResponse _getLiferayPortletResponse() {
        PortletResponse portletResponse = (PortletResponse)this._httpServletRequest.getAttribute("javax.portlet.response");
        return PortalUtil.getLiferayPortletResponse((PortletResponse)portletResponse);
    }

    private String _getMoveEntryOnClickJavaScript() {
        StringBundler sb = new StringBundler(5);
        sb.append(this.getNamespace());
        sb.append("move(1, ");
        if (this._fileShortcut != null) {
            sb.append("'rowIdsDLFileShortcut', ");
            sb.append(this._fileShortcut.getFileShortcutId());
        } else {
            sb.append("'rowIdsFileEntry', ");
            sb.append(this._fileEntry.getFileEntryId());
        }
        sb.append(");");
        return sb.toString();
    }

    private String _getRedirect() {
        if (this._redirect == null) {
            this._redirect = ParamUtil.getString((HttpServletRequest)this._httpServletRequest, (String)"redirect");
        }
        return this._redirect;
    }

    private PortletURL _getRenderURL(String mvcRenderCommandName) {
        return this._getRenderURL(mvcRenderCommandName, this._getCurrentURL());
    }

    private PortletURL _getRenderURL(String mvcRenderCommandName, String redirect) {
        LiferayPortletResponse liferayPortletResponse = this._getLiferayPortletResponse();
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", mvcRenderCommandName);
        if (Validator.isNotNull((String)redirect)) {
            portletURL.setParameter("redirect", redirect);
        }
        if (this._fileShortcut != null) {
            portletURL.setParameter("fileShortcutId", String.valueOf(this._fileShortcut.getFileShortcutId()));
        } else {
            portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        }
        return portletURL;
    }

    private boolean _isFileEntryTrashable() throws PortalException {
        return this._fileEntry.isRepositoryCapabilityProvided(TrashCapability.class) && this._isTrashEnabled();
    }

    private boolean _isFileShortcutTrashable() throws PortalException {
        return this._fileShortcutDisplayContextHelper.isDLFileShortcut() && this._isTrashEnabled();
    }

    private boolean _isFileVersionExportable(boolean latestVersion) {
        try {
            FileVersion fileVersion = this._fileVersion;
            if (latestVersion) {
                if (this._fileEntry == null) {
                    return false;
                }
                fileVersion = this._fileEntry.getLatestFileVersion();
            }
            if (fileVersion == null) {
                return false;
            }
            StagedModelDataHandler stagedModelDataHandler = StagedModelDataHandlerRegistryUtil.getStagedModelDataHandler((String)FileEntry.class.getName());
            return ArrayUtil.contains((int[])stagedModelDataHandler.getExportableStatuses(), (int)fileVersion.getStatus());
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean _isIEOnWin32() {
        if (this._ieOnWin32 == null) {
            this._ieOnWin32 = BrowserSnifferUtil.isIeOnWin32((HttpServletRequest)this._httpServletRequest);
        }
        return this._ieOnWin32;
    }

    private boolean _isTrashEnabled() throws PortalException {
        if (this._trashEnabled != null) {
            return this._trashEnabled;
        }
        this._trashEnabled = false;
        if (this._dlTrashUtil == null) {
            return this._trashEnabled;
        }
        this._trashEnabled = this._dlTrashUtil.isTrashEnabled(this._themeDisplay.getScopeGroupId(), this._fileEntry.getRepositoryId());
        return this._trashEnabled;
    }

    private boolean _isWebDAVEnabled() {
        PortletDisplay portletDisplay = this._themeDisplay.getPortletDisplay();
        return portletDisplay.isWebDAVEnabled();
    }
}

