/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context.logic;

import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.KeyValuePair;
import com.liferay.portal.kernel.util.KeyValuePairComparator;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class DLPortletInstanceSettingsHelper {
    private static final Map<String, String> _displayViews = new HashMap<String, String>(){
        {
            this.put("descriptive", "list");
            this.put("icon", "cards");
            this.put("list", "table");
        }
    };
    private List<KeyValuePair> _availableDisplayViews;
    private List<KeyValuePair> _availableEntryColumns;
    private List<KeyValuePair> _availableFileEntryColumns;
    private List<KeyValuePair> _availableFolderColumns;
    private List<KeyValuePair> _availableMimeTypes;
    private List<KeyValuePair> _currentDisplayViews;
    private List<KeyValuePair> _currentEntryColumns;
    private List<KeyValuePair> _currentFileEntryColumns;
    private List<KeyValuePair> _currentFolderColumns;
    private List<KeyValuePair> _currentMimeTypes;
    private final DLRequestHelper _dlRequestHelper;

    public DLPortletInstanceSettingsHelper(DLRequestHelper dlRequestHelper) {
        this._dlRequestHelper = dlRequestHelper;
    }

    public List<KeyValuePair> getAvailableDisplayViews() {
        if (this._availableDisplayViews == null) {
            this._populateDisplayViews();
        }
        return this._availableDisplayViews;
    }

    public List<KeyValuePair> getAvailableEntryColumns() {
        if (this._availableEntryColumns == null) {
            this._populateEntryColumns();
        }
        return this._availableEntryColumns;
    }

    public List<KeyValuePair> getAvailableFileEntryColumns() {
        if (this._availableFileEntryColumns == null) {
            this._populateFileEntryColumns();
        }
        return this._availableFileEntryColumns;
    }

    public List<KeyValuePair> getAvailableFolderColumns() {
        if (this._availableFolderColumns == null) {
            this._populateFolderColumns();
        }
        return this._availableFolderColumns;
    }

    public List<KeyValuePair> getAvailableMimeTypes() {
        if (this._availableMimeTypes == null) {
            this._populateMimeTypes();
        }
        return this._availableMimeTypes;
    }

    public List<KeyValuePair> getCurrentDisplayViews() {
        if (this._currentDisplayViews == null) {
            this._populateDisplayViews();
        }
        return this._currentDisplayViews;
    }

    public List<KeyValuePair> getCurrentEntryColumns() {
        if (this._currentEntryColumns == null) {
            this._populateEntryColumns();
        }
        return this._currentEntryColumns;
    }

    public List<KeyValuePair> getCurrentFileEntryColumns() {
        if (this._currentFileEntryColumns == null) {
            this._populateFileEntryColumns();
        }
        return this._currentFileEntryColumns;
    }

    public List<KeyValuePair> getCurrentFolderColumns() {
        if (this._currentFolderColumns == null) {
            this._populateFolderColumns();
        }
        return this._currentFolderColumns;
    }

    public List<KeyValuePair> getCurrentMimeTypes() {
        if (this._currentMimeTypes == null) {
            this._populateMimeTypes();
        }
        return this._currentMimeTypes;
    }

    public String[] getEntryColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] entryColumns = dlPortletInstanceSettings.getEntryColumns();
        String portletName = this._dlRequestHelper.getPortletName();
        if (!this.isShowActions()) {
            entryColumns = ArrayUtil.remove((String[])entryColumns, (String)"action");
        } else if (!(portletName.equals("com_liferay_document_library_web_portlet_DLPortlet") || portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet") || ArrayUtil.contains((Object[])entryColumns, (Object)"action"))) {
            entryColumns = (String[])ArrayUtil.append((Object[])entryColumns, (Object)"action");
        }
        return entryColumns;
    }

    public String[] getFileEntryColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        String[] fileEntryColumns = dlPortletInstanceSettings.getFileEntryColumns();
        if (!this.isShowActions()) {
            fileEntryColumns = ArrayUtil.remove((String[])fileEntryColumns, (String)"action");
        }
        return fileEntryColumns;
    }

    public String[] getFolderColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        String[] folderColumns = dlPortletInstanceSettings.getFolderColumns();
        if (!this.isShowActions()) {
            folderColumns = ArrayUtil.remove((String[])folderColumns, (String)"action");
        }
        return folderColumns;
    }

    public boolean isShowActions() {
        String portletName = this._dlRequestHelper.getPortletName();
        String portletResource = this._dlRequestHelper.getPortletResource();
        if (portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet") || portletName.equals("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet") || portletResource.equals("com_liferay_document_library_web_portlet_DLAdminPortlet") || portletResource.equals("com_liferay_portal_workflow_task_web_portlet_MyWorkflowTaskPortlet")) {
            return true;
        }
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return dlPortletInstanceSettings.isShowActions();
    }

    public boolean isShowSearch() {
        String portletName = this._dlRequestHelper.getPortletName();
        if (portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return true;
        }
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        return dlPortletInstanceSettings.isShowFoldersSearch();
    }

    public boolean isShowTabs() {
        String portletName = this._dlRequestHelper.getPortletName();
        return portletName.equals("com_liferay_document_library_web_portlet_DLAdminPortlet");
    }

    private String[] _getAllEntryColumns() {
        String allEntryColumns = "name,description,size,status";
        if (PropsValues.DL_FILE_ENTRY_BUFFERED_INCREMENT_ENABLED) {
            allEntryColumns = allEntryColumns + ",downloads";
        }
        if (this.isShowActions()) {
            allEntryColumns = allEntryColumns + ",action";
        }
        allEntryColumns = allEntryColumns + ",modified-date,create-date";
        return StringUtil.split((String)allEntryColumns);
    }

    private String[] _getAllFileEntryColumns() {
        String allFileEntryColumns = "name,size";
        if (PropsValues.DL_FILE_ENTRY_BUFFERED_INCREMENT_ENABLED) {
            allFileEntryColumns = allFileEntryColumns + ",downloads";
        }
        allFileEntryColumns = allFileEntryColumns + ",locked";
        if (this.isShowActions()) {
            allFileEntryColumns = allFileEntryColumns + ",action";
        }
        return StringUtil.split((String)allFileEntryColumns);
    }

    private String[] _getAllFolderColumns() {
        String allFolderColumns = "name,num-of-folders,num-of-documents";
        if (this.isShowActions()) {
            allFolderColumns = allFolderColumns + ",action";
        }
        return StringUtil.split((String)allFolderColumns);
    }

    private void _populateDisplayViews() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] displayViews = dlPortletInstanceSettings.getDisplayViews();
        this._currentDisplayViews = new ArrayList<KeyValuePair>();
        for (Object displayView : displayViews) {
            this._currentDisplayViews.add(new KeyValuePair((String)displayView, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)_displayViews.get(displayView))));
        }
        Arrays.sort(displayViews);
        this._availableDisplayViews = new ArrayList<KeyValuePair>();
        Set allDisplayViews = SetUtil.fromArray((Object[])PropsValues.DL_DISPLAY_VIEWS);
        for (String displayView : allDisplayViews) {
            if (Arrays.binarySearch(displayViews, displayView) >= 0) continue;
            this._availableDisplayViews.add(new KeyValuePair(displayView, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)_displayViews.get(displayView))));
        }
        this._availableDisplayViews = ListUtil.sort(this._availableDisplayViews, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateEntryColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] entryColumns = dlPortletInstanceSettings.getEntryColumns();
        this._currentEntryColumns = new ArrayList<KeyValuePair>();
        for (Object entryColumn : entryColumns) {
            this._currentEntryColumns.add(new KeyValuePair((String)entryColumn, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)entryColumn)));
        }
        Arrays.sort(entryColumns);
        this._availableEntryColumns = new ArrayList<KeyValuePair>();
        Set allEntryColumns = SetUtil.fromArray((Object[])this._getAllEntryColumns());
        for (String entryColumn : allEntryColumns) {
            if (Arrays.binarySearch(entryColumns, entryColumn) >= 0) continue;
            this._availableEntryColumns.add(new KeyValuePair(entryColumn, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)entryColumn)));
        }
        this._availableEntryColumns = ListUtil.sort(this._availableEntryColumns, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateFileEntryColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] fileEntryColumns = dlPortletInstanceSettings.getFileEntryColumns();
        this._currentFileEntryColumns = new ArrayList<KeyValuePair>();
        for (String string : fileEntryColumns) {
            this._currentFileEntryColumns.add(new KeyValuePair(string, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)string)));
        }
        this._availableFileEntryColumns = new ArrayList<KeyValuePair>();
        Arrays.sort(fileEntryColumns);
        Set allFileEntryColumns = SetUtil.fromArray((Object[])this._getAllFileEntryColumns());
        for (String fileEntryColumn : allFileEntryColumns) {
            if (Arrays.binarySearch(fileEntryColumns, fileEntryColumn) >= 0) continue;
            this._availableFileEntryColumns.add(new KeyValuePair(fileEntryColumn, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)fileEntryColumn)));
        }
        this._availableFileEntryColumns = ListUtil.sort(this._availableFileEntryColumns, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateFolderColumns() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] folderColumns = dlPortletInstanceSettings.getFolderColumns();
        this._currentFolderColumns = new ArrayList<KeyValuePair>();
        for (String string : folderColumns) {
            this._currentFolderColumns.add(new KeyValuePair(string, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)string)));
        }
        this._availableFolderColumns = new ArrayList<KeyValuePair>();
        Arrays.sort(folderColumns);
        Set allFolderColumns = SetUtil.fromArray((Object[])this._getAllFolderColumns());
        for (String folderColumn : allFolderColumns) {
            if (Arrays.binarySearch(folderColumns, folderColumn) >= 0) continue;
            this._availableFolderColumns.add(new KeyValuePair(folderColumn, LanguageUtil.get((Locale)this._dlRequestHelper.getLocale(), (String)folderColumn)));
        }
        this._availableFolderColumns = ListUtil.sort(this._availableFolderColumns, (Comparator)new KeyValuePairComparator(false, true));
    }

    private void _populateMimeTypes() {
        DLPortletInstanceSettings dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        Object[] mediaGalleryMimeTypes = dlPortletInstanceSettings.getMimeTypes();
        Arrays.sort(mediaGalleryMimeTypes);
        ThemeDisplay themeDisplay = this._dlRequestHelper.getThemeDisplay();
        this._currentMimeTypes = new ArrayList<KeyValuePair>();
        for (Object mimeType : mediaGalleryMimeTypes) {
            this._currentMimeTypes.add(new KeyValuePair((String)mimeType, LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)mimeType)));
        }
        this._availableMimeTypes = new ArrayList<KeyValuePair>();
        Set allMediaGalleryMimeTypes = DLUtil.getAllMediaGalleryMimeTypes();
        for (String mimeType : allMediaGalleryMimeTypes) {
            if (Arrays.binarySearch(mediaGalleryMimeTypes, mimeType) >= 0) continue;
            this._availableMimeTypes.add(new KeyValuePair(mimeType, LanguageUtil.get((Locale)themeDisplay.getLocale(), (String)mimeType)));
        }
    }
}

