/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.asset.model;

import com.liferay.asset.display.page.portlet.AssetDisplayPageFriendlyURLProvider;
import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortletLayoutFinder;
import com.liferay.portal.kernel.portlet.PortletLayoutFinderRegistryUtil;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.repository.capabilities.CommentCapability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.service.permission.PortletPermissionUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryDDMFormValuesReader;
import com.liferay.trash.TrashHelper;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DLFileEntryAssetRenderer
extends BaseJSPAssetRenderer<FileEntry>
implements TrashRenderer {
    private static final Log _log = LogFactoryUtil.getLog(DLFileEntryAssetRenderer.class);
    private AssetDisplayPageFriendlyURLProvider _assetDisplayPageFriendlyURLProvider;
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final DLURLHelper _dlURLHelper;
    private final FileEntry _fileEntry;
    private FileVersion _fileVersion;
    private final TrashHelper _trashHelper;

    public DLFileEntryAssetRenderer(FileEntry fileEntry, FileVersion fileVersion, DLFileEntryLocalService dlFileEntryLocalService, TrashHelper trashHelper, DLURLHelper dlURLHelper) {
        this._fileEntry = fileEntry;
        this._fileVersion = fileVersion;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._trashHelper = trashHelper;
        this._dlURLHelper = dlURLHelper;
    }

    public FileEntry getAssetObject() {
        return this._fileEntry;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public long getClassPK() {
        String version = this._fileVersion.getVersion();
        if (!this._fileVersion.isApproved() && this._fileVersion.isDraft() && !this._fileVersion.isPending() && !version.equals("1.0")) {
            return this._fileVersion.getFileVersionId();
        }
        return this._fileEntry.getFileEntryId();
    }

    public DDMFormValuesReader getDDMFormValuesReader() {
        return new DLFileEntryDDMFormValuesReader(this._fileEntry, this._fileVersion);
    }

    public String getDiscussionPath() {
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            return "edit_file_entry_discussion";
        }
        return null;
    }

    public long getGroupId() {
        return this._fileEntry.getGroupId();
    }

    public String getIconCssClass() {
        return this._fileEntry.getIconCssClass();
    }

    public String getJspPath(HttpServletRequest httpServletRequest, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/document_library/asset/file_entry_" + template + ".jsp";
        }
        return null;
    }

    public String getNewName(String oldName, String token) {
        String extension = FileUtil.getExtension((String)oldName);
        if (Validator.isNull((String)extension)) {
            return super.getNewName(oldName, token);
        }
        StringBundler sb = new StringBundler(5);
        int index = oldName.lastIndexOf(46);
        sb.append(oldName.substring(0, index));
        sb.append(" ");
        sb.append(token);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._fileVersion.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._fileEntry.getDescription();
    }

    public String[] getSupportedConversions() {
        return DocumentConversionUtil.getConversions((String)this._fileEntry.getExtension());
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String thumbnailSrc = this._dlURLHelper.getThumbnailSrc(this._fileEntry, themeDisplay);
        if (Validator.isNotNull((String)thumbnailSrc)) {
            return thumbnailSrc;
        }
        return super.getThumbnailPath(portletRequest);
    }

    public String getTitle(Locale locale) {
        String title = null;
        title = this.getAssetRendererType() == 0 ? this._fileVersion.getTitle() : this._fileEntry.getTitle();
        if (this._trashHelper == null) {
            return title;
        }
        return this._trashHelper.getOriginalTitle(title);
    }

    public String getType() {
        return "document";
    }

    public String getURLDownload(ThemeDisplay themeDisplay) {
        return this._dlURLHelper.getDownloadURL(this._fileEntry, this._fileVersion, themeDisplay, "");
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = this._getPortletURL(liferayPortletRequest);
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = this._getPortletURL(liferayPortletRequest);
        portletURL.setParameter("javax.portlet.action", "/document_library/get_file");
        portletURL.setParameter("groupId", String.valueOf(this._fileEntry.getRepositoryId()));
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        portletURL.setParameter("title", String.valueOf(this._fileEntry.getTitle()));
        return portletURL;
    }

    public String getURLImagePreview(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return this._dlURLHelper.getImagePreviewURL(this._fileEntry, this._fileVersion, themeDisplay);
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) throws PortalException {
        long groupId;
        ThemeDisplay themeDisplay;
        if (this._assetDisplayPageFriendlyURLProvider != null) {
            themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            String friendlyURL = this._assetDisplayPageFriendlyURLProvider.getFriendlyURL(this.getClassName(), this.getClassPK(), themeDisplay);
            if (Validator.isNotNull((String)friendlyURL)) {
                return friendlyURL;
            }
        }
        if (!this._hasViewInContextGroupLayout(themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY"), groupId = this._fileEntry.getGroupId())) {
            return null;
        }
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/document_library/find_file_entry", "fileEntryId", this._fileEntry.getFileEntryId());
    }

    public long getUserId() {
        return this._fileEntry.getUserId();
    }

    public String getUserName() {
        return this._fileEntry.getUserName();
    }

    public String getUuid() {
        return this._fileEntry.getUuid();
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "VIEW");
    }

    public boolean include(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, String template) throws Exception {
        httpServletRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)this._fileEntry);
        String version = ParamUtil.getString((HttpServletRequest)httpServletRequest, (String)"version");
        if (this.getAssetRendererType() == 0 || Validator.isNotNull((String)version)) {
            if (this._fileEntry != null && Validator.isNotNull((String)version)) {
                this._fileVersion = this._fileEntry.getFileVersion(version);
            }
            httpServletRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileVersion);
        } else {
            httpServletRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileEntry.getFileVersion());
        }
        return super.include(httpServletRequest, httpServletResponse, template);
    }

    public boolean isCategorizable(long groupId) {
        long classPK = this.getClassPK();
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(classPK);
        if (dlFileEntry == null || dlFileEntry.getRepositoryId() != groupId) {
            return false;
        }
        return super.isCategorizable(groupId);
    }

    public boolean isCommentable() {
        if (super.isCommentable()) {
            return this._fileEntry.isRepositoryCapabilityProvided(CommentCapability.class);
        }
        return false;
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return false;
    }

    public void setAssetDisplayPageFriendlyURLProvider(AssetDisplayPageFriendlyURLProvider assetDisplayPageFriendlyURLProvider) {
        this._assetDisplayPageFriendlyURLProvider = assetDisplayPageFriendlyURLProvider;
    }

    private PortletURL _getPortletURL(LiferayPortletRequest liferayPortletRequest) throws PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._fileEntry.getGroupId());
        if (group.isCompany()) {
            group = themeDisplay.getScopeGroup();
        }
        if (PortletPermissionUtil.hasControlPanelAccessPermission((PermissionChecker)themeDisplay.getPermissionChecker(), (long)group.getGroupId(), (String)"com_liferay_document_library_web_portlet_DLAdminPortlet")) {
            return PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_document_library_web_portlet_DLAdminPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        }
        return PortletURLFactoryUtil.create((PortletRequest)liferayPortletRequest, (String)"com_liferay_document_library_web_portlet_DLPortlet", (String)"RENDER_PHASE");
    }

    private boolean _hasViewInContextGroupLayout(ThemeDisplay themeDisplay, long groupId) {
        try {
            PortletLayoutFinder portletLayoutFinder = PortletLayoutFinderRegistryUtil.getPortletLayoutFinder((String)DLFileEntryConstants.getClassName());
            PortletLayoutFinder.Result result = portletLayoutFinder.find(themeDisplay, groupId);
            return result != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

