Liferay.Loader.define('document-library-web$clipboard@2.0.4/webpack.config', ['module', 'exports', 'require', './package.json', 'document-library-web$path', 'document-library-web$webpack', 'document-library-web$uglifyjs-webpack-plugin', 'document-library-web$os'], function (module, exports, require) {
    var define = undefined;
    const pkg = require('./package.json');
    const path = require('document-library-web$path');
    const webpack = require('document-library-web$webpack');
    const UglifyJSPlugin = require('document-library-web$uglifyjs-webpack-plugin');

    const production = true || false;

    const banner = `clipboard.js v${pkg.version}
https://zenorocha.github.io/clipboard.js

Licensed MIT © Zeno Rocha`;

    module.exports = {
        entry: './src/clipboard.js',
        mode: 'production',
        output: {
            filename: 'clipboard.min.js',
            path: path.resolve(__dirname, 'dist'),
            library: 'ClipboardJS',
            libraryTarget: 'umd',
            globalObject: 'this'
        },
        module: {
            rules: [{ test: /\.js$/, exclude: /node_modules/, loader: 'babel-loader' }]
        },
        optimization: {
            minimize: production,
            minimizer: [new UglifyJSPlugin({
                parallel: require('document-library-web$os').cpus().length,
                uglifyOptions: {
                    ie8: false,
                    keep_fnames: false,
                    output: {
                        beautify: false,
                        comments: (node, { value, type }) => type == 'comment2' && value.startsWith('!')
                    }
                }
            })]
        },
        plugins: [new webpack.BannerPlugin({ banner })]
    };
});
//# sourceMappingURL=webpack.config.js.map