/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.exportimport.changeset.Changeset;
import com.liferay.exportimport.changeset.portlet.action.ExportImportChangesetMVCActionCommand;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "mvc.command.name=/document_library/publish_folder"}, service={MVCActionCommand.class})
public class PublishFolderMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(PublishFolderMVCActionCommand.class);
    @Reference
    private DLAppLocalService _dlAppLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFolderLocalService _dlFolderLocalService;
    @Reference
    private ExportImportChangesetMVCActionCommand _exportImportChangesetMVCActionCommand;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        Folder folder = this._dlAppLocalService.getFolder(folderId);
        Changeset.Builder builder = Changeset.create();
        Changeset changeset = builder.addStagedModel(() -> this._getFolder(folderId)).addMultipleStagedModel(() -> this._getFoldersAndFileEntriesAndFileShortcuts(folder)).build();
        this._exportImportChangesetMVCActionCommand.processPublishAction(actionRequest, actionResponse, changeset);
    }

    private Folder _getFolder(long folderId) {
        try {
            return this._dlAppLocalService.getFolder(folderId);
        }
        catch (PortalException pe) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)("Unable to get folder " + folderId), (Throwable)pe);
            }
            return null;
        }
    }

    private List<StagedModel> _getFoldersAndFileEntriesAndFileShortcuts(Folder folder) {
        ArrayList<StagedModel> stagedModels;
        block5: {
            if (folder == null) {
                return Collections.emptyList();
            }
            stagedModels = new ArrayList<StagedModel>();
            try {
                List childObjects = this._dlAppService.getFoldersAndFileEntriesAndFileShortcuts(folder.getGroupId(), folder.getFolderId(), -1, false, -1, -1);
                for (Object childObject : childObjects) {
                    if (childObject instanceof Folder) {
                        Folder childFolder = (Folder)childObject;
                        stagedModels.add((StagedModel)childFolder);
                        stagedModels.addAll(this._getFoldersAndFileEntriesAndFileShortcuts(childFolder));
                        continue;
                    }
                    stagedModels.add((StagedModel)childObject);
                }
            }
            catch (PortalException pe) {
                if (!_log.isWarnEnabled()) break block5;
                _log.warn((Object)("Unable to get folders, file entries, file shortcuts for folder " + folder.getFolderId()), (Throwable)pe);
            }
        }
        return stagedModels;
    }
}

