/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.web.internal.portlet.action.ActionUtil;
import com.liferay.portal.kernel.exception.NoSuchRepositoryEntryException;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCRenderCommand;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Validator;
import javax.portlet.PortletException;
import javax.portlet.PortletRequest;
import javax.portlet.RenderRequest;
import javax.portlet.RenderResponse;

public abstract class GetFileEntryMVCRenderCommand
implements MVCRenderCommand {
    public String render(RenderRequest renderRequest, RenderResponse renderResponse) throws PortletException {
        try {
            FileEntry fileEntry = ActionUtil.getFileEntry((PortletRequest)renderRequest);
            renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)fileEntry);
            FileVersion fileVersion = ActionUtil.getFileVersion((PortletRequest)renderRequest, fileEntry);
            String version = ParamUtil.getString((PortletRequest)renderRequest, (String)"version");
            if (Validator.isNotNull((String)version)) {
                renderRequest.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)fileVersion);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileEntryException || e instanceof NoSuchFileVersionException || e instanceof NoSuchRepositoryEntryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)renderRequest, e.getClass());
                return "/document_library/error.jsp";
            }
            throw new PortletException((Throwable)e);
        }
        return this.getPath();
    }

    protected abstract String getPath();
}

