/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.DuplicateFolderNameException;
import com.liferay.document.library.kernel.exception.DuplicateRepositoryNameException;
import com.liferay.document.library.kernel.exception.FolderNameException;
import com.liferay.document.library.kernel.exception.RepositoryNameException;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.portal.kernel.exception.InvalidRepositoryException;
import com.liferay.portal.kernel.exception.NoSuchRepositoryException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.RepositoryService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.Portal;
import com.liferay.portal.kernel.util.PropertiesParamUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_repository"}, service={MVCActionCommand.class})
public class EditRepositoryMVCActionCommand
extends BaseMVCActionCommand {
    private static final Log _log = LogFactoryUtil.getLog(EditRepositoryMVCActionCommand.class);
    @Reference
    private Portal _portal;
    private RepositoryService _repositoryService;

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateRepository(actionRequest);
            } else if (cmd.equals("delete")) {
                this.unmountRepository(actionRequest);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchRepositoryException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
            }
            if (e instanceof DuplicateFolderNameException || e instanceof DuplicateRepositoryNameException || e instanceof FolderNameException || e instanceof InvalidRepositoryException || e instanceof RepositoryNameException) {
                if (e instanceof InvalidRepositoryException) {
                    _log.error((Object)e, (Throwable)e);
                }
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setRepositoryService(RepositoryService repositoryService) {
        this._repositoryService = repositoryService;
    }

    protected void unmountRepository(ActionRequest actionRequest) throws Exception {
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        this._repositoryService.deleteRepository(repositoryId);
    }

    protected void updateRepository(ActionRequest actionRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)actionRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        String className = ParamUtil.getString((PortletRequest)actionRequest, (String)"className");
        long classNameId = this._portal.getClassNameId(className);
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        String name = ParamUtil.getString((PortletRequest)actionRequest, (String)"name");
        String description = ParamUtil.getString((PortletRequest)actionRequest, (String)"description");
        UnicodeProperties typeSettingsProperties = PropertiesParamUtil.getProperties((PortletRequest)actionRequest, (String)"settings--");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFolder.class.getName(), (PortletRequest)actionRequest);
        if (repositoryId <= 0L) {
            this._repositoryService.addRepository(themeDisplay.getScopeGroupId(), classNameId, folderId, name, description, portletDisplay.getId(), typeSettingsProperties, serviceContext);
        } else {
            this._repositoryService.updateRepository(repositoryId, name, description);
        }
    }
}

