/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.exception.FileShortcutPermissionException;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileShortcutException;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLTrashService;
import com.liferay.portal.kernel.model.TrashedModel;
import com.liferay.portal.kernel.portlet.bridges.mvc.BaseMVCActionCommand;
import com.liferay.portal.kernel.portlet.bridges.mvc.MVCActionCommand;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.servlet.SessionErrors;
import com.liferay.portal.kernel.util.ParamUtil;
import java.util.ArrayList;
import java.util.HashMap;
import javax.portlet.ActionRequest;
import javax.portlet.ActionResponse;
import javax.portlet.PortletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_DLAdminPortlet", "javax.portlet.name=com_liferay_document_library_web_portlet_IGDisplayPortlet", "mvc.command.name=/document_library/edit_file_shortcut"}, service={MVCActionCommand.class})
public class EditFileShortcutMVCActionCommand
extends BaseMVCActionCommand {
    private DLAppService _dlAppService;
    private DLTrashService _dlTrashService;

    protected void deleteFileShortcut(ActionRequest actionRequest, boolean moveToTrash) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        if (moveToTrash) {
            FileShortcut fileShortcut = this._dlTrashService.moveFileShortcutToTrash(fileShortcutId);
            if (!(fileShortcut.getModel() instanceof TrashedModel)) {
                this.hideDefaultSuccessMessage((PortletRequest)actionRequest);
                return;
            }
            ArrayList<TrashedModel> trashedModels = new ArrayList<TrashedModel>();
            trashedModels.add((TrashedModel)fileShortcut.getModel());
            HashMap<String, ArrayList<TrashedModel>> data = new HashMap<String, ArrayList<TrashedModel>>();
            data.put("trashedModels", trashedModels);
            this.addDeleteSuccessData((PortletRequest)actionRequest, data);
        } else {
            this._dlAppService.deleteFileShortcut(fileShortcutId);
        }
    }

    protected void doProcessAction(ActionRequest actionRequest, ActionResponse actionResponse) throws Exception {
        String cmd = ParamUtil.getString((PortletRequest)actionRequest, (String)"cmd");
        try {
            if (cmd.equals("add") || cmd.equals("update")) {
                this.updateFileShortcut(actionRequest);
            } else if (cmd.equals("delete")) {
                this.deleteFileShortcut(actionRequest, false);
            } else if (cmd.equals("move_to_trash")) {
                this.deleteFileShortcut(actionRequest, true);
            }
        }
        catch (Exception e) {
            if (e instanceof NoSuchFileShortcutException || e instanceof PrincipalException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
                actionResponse.setRenderParameter("mvcPath", "/document_library/error.jsp");
            }
            if (e instanceof FileShortcutPermissionException || e instanceof NoSuchFileEntryException) {
                SessionErrors.add((PortletRequest)actionRequest, e.getClass());
            }
            throw e;
        }
    }

    @Reference(unbind="-")
    protected void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    protected void setDLTrashService(DLTrashService dlTrashService) {
        this._dlTrashService = dlTrashService;
    }

    protected void updateFileShortcut(ActionRequest actionRequest) throws Exception {
        long fileShortcutId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"fileShortcutId");
        long repositoryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"repositoryId");
        long folderId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"folderId");
        long toFileEntryId = ParamUtil.getLong((PortletRequest)actionRequest, (String)"toFileEntryId");
        ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileShortcutConstants.getClassName(), (PortletRequest)actionRequest);
        if (fileShortcutId <= 0L) {
            this._dlAppService.addFileShortcut(repositoryId, folderId, toFileEntryId, serviceContext);
        } else {
            this._dlAppService.updateFileShortcut(fileShortcutId, folderId, toFileEntryId, serviceContext);
        }
    }
}

