/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.exportimport.portlet.preferences.processor;

import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.exportimport.kernel.lar.PortletDataContext;
import com.liferay.exportimport.kernel.lar.PortletDataException;
import com.liferay.exportimport.kernel.lar.StagedModelDataHandlerUtil;
import com.liferay.exportimport.kernel.staging.MergeLayoutPrototypesThreadLocal;
import com.liferay.exportimport.portlet.preferences.processor.Capability;
import com.liferay.exportimport.portlet.preferences.processor.ExportImportPortletPreferencesProcessor;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.StagedModel;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.MapUtil;
import com.liferay.portal.kernel.util.StringBundler;
import com.liferay.portal.kernel.xml.Element;
import java.util.List;
import java.util.Map;
import javax.portlet.PortletPreferences;
import javax.portlet.ReadOnlyException;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet"}, service={DLExportImportPortletPreferencesProcessor.class, ExportImportPortletPreferencesProcessor.class})
public class DLExportImportPortletPreferencesProcessor
implements ExportImportPortletPreferencesProcessor {
    private static final Log _log = LogFactoryUtil.getLog(DLExportImportPortletPreferencesProcessor.class);
    private DLAppLocalService _dlAppLocalService;
    @Reference(target="(name=PortletDisplayTemplateExporter)")
    private Capability _exportCapability;
    @Reference(target="(name=PortletDisplayTemplateImporter)")
    private Capability _importCapability;

    public List<Capability> getExportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._exportCapability});
    }

    public List<Capability> getImportCapabilities() {
        return ListUtil.toList((Object[])new Capability[]{this._importCapability});
    }

    public PortletPreferences processExportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        if (!MapUtil.getBoolean((Map)portletDataContext.getParameterMap(), (String)"PORTLET_DATA") && MergeLayoutPrototypesThreadLocal.isInProgress()) {
            return portletPreferences;
        }
        String portletId = portletDataContext.getPortletId();
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId != 0L) {
            Folder folder = null;
            try {
                folder = this._dlAppLocalService.getFolder(rootFolderId);
            }
            catch (PortalException pe) {
                StringBundler sb = new StringBundler(4);
                sb.append("Portlet ");
                sb.append(portletId);
                sb.append(" refers to an invalid root folder ID ");
                sb.append(rootFolderId);
                _log.error((Object)sb.toString());
                throw new PortletDataException(sb.toString(), (Throwable)pe);
            }
            StagedModelDataHandlerUtil.exportReferenceStagedModel((PortletDataContext)portletDataContext, (String)portletId, (StagedModel)folder);
        }
        return portletPreferences;
    }

    public PortletPreferences processImportPortletPreferences(PortletDataContext portletDataContext, PortletPreferences portletPreferences) throws PortletDataException {
        Element foldersElement;
        List folderElements;
        long rootFolderId = GetterUtil.getLong((String)portletPreferences.getValue("rootFolderId", null));
        if (rootFolderId > 0L && !(folderElements = (foldersElement = portletDataContext.getImportDataGroupElement(DLFolder.class)).elements()).isEmpty()) {
            StagedModelDataHandlerUtil.importStagedModel((PortletDataContext)portletDataContext, (Element)((Element)folderElements.get(0)));
            Map folderIds = portletDataContext.getNewPrimaryKeysMap(Folder.class + ".folderIdsAndRepositoryEntryIds");
            rootFolderId = MapUtil.getLong((Map)folderIds, (long)rootFolderId, (long)rootFolderId);
            try {
                portletPreferences.setValue("rootFolderId", String.valueOf(rootFolderId));
            }
            catch (ReadOnlyException roe) {
                throw new PortletDataException("Unable to update portlet preferences during import", (Throwable)roe);
            }
        }
        return portletPreferences;
    }

    @Reference(unbind="-")
    protected void setDLAppLocalService(DLAppLocalService dlAppLocalService) {
        this._dlAppLocalService = dlAppLocalService;
    }
}

