/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.display.context;

import com.liferay.asset.kernel.service.AssetEntryServiceUtil;
import com.liferay.asset.kernel.service.persistence.AssetEntryQuery;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileShortcutConstants;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.kernel.util.comparator.RepositoryModelModifiedDateComparator;
import com.liferay.document.library.web.internal.display.context.logic.DLPortletInstanceSettingsHelper;
import com.liferay.document.library.web.internal.display.context.util.DLRequestHelper;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.bean.BeanPropertiesUtil;
import com.liferay.portal.kernel.dao.search.SearchContainer;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.PortalPreferences;
import com.liferay.portal.kernel.portlet.PortletPreferencesFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.search.Document;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Indexer;
import com.liferay.portal.kernel.search.IndexerRegistryUtil;
import com.liferay.portal.kernel.search.QueryConfig;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchContextFactory;
import com.liferay.portal.kernel.search.SearchResult;
import com.liferay.portal.kernel.search.SearchResultUtil;
import com.liferay.portal.kernel.search.Sort;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ArrayUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.HtmlUtil;
import com.liferay.portal.kernel.util.ListUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletURL;
import javax.servlet.http.HttpServletRequest;

public class DLAdminDisplayContext {
    private static final Log _log = LogFactoryUtil.getLog(DLAdminDisplayContext.class);
    private boolean _defaultFolderView;
    private final DLPortletInstanceSettings _dlPortletInstanceSettings;
    private final DLPortletInstanceSettingsHelper _dlPortletInstanceSettingsHelper;
    private final DLRequestHelper _dlRequestHelper;
    private Folder _folder;
    private long _folderId;
    private final LiferayPortletRequest _liferayPortletRequest;
    private final LiferayPortletResponse _liferayPortletResponse;
    private final PermissionChecker _permissionChecker;
    private final PortalPreferences _portalPreferences;
    private final HttpServletRequest _request;
    private long _rootFolderId;
    private String _rootFolderName;
    private SearchContainer _searchContainer;
    private final ThemeDisplay _themeDisplay;

    public DLAdminDisplayContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) {
        this._liferayPortletRequest = liferayPortletRequest;
        this._liferayPortletResponse = liferayPortletResponse;
        this._request = liferayPortletRequest.getHttpServletRequest();
        this._dlRequestHelper = new DLRequestHelper(this._request);
        this._dlPortletInstanceSettings = this._dlRequestHelper.getDLPortletInstanceSettings();
        this._dlPortletInstanceSettingsHelper = new DLPortletInstanceSettingsHelper(this._dlRequestHelper);
        this._portalPreferences = PortletPreferencesFactoryUtil.getPortalPreferences((PortletRequest)liferayPortletRequest);
        this._themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        this._permissionChecker = this._themeDisplay.getPermissionChecker();
        this._computeFolders();
    }

    public String getDisplayStyle() {
        Object displayStyle = ParamUtil.getString((HttpServletRequest)this._request, (String)"displayStyle");
        Object[] displayViews = this._dlPortletInstanceSettings.getDisplayViews();
        if (Validator.isNull((String)displayStyle)) {
            displayStyle = this._portalPreferences.getValue("com_liferay_document_library_web_portlet_DLPortlet", "display-style", PropsValues.DL_DEFAULT_DISPLAY_VIEW);
        } else if (ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            this._portalPreferences.setValue("com_liferay_document_library_web_portlet_DLPortlet", "display-style", (String)displayStyle);
            this._request.setAttribute("LIFERAY_SHARED_SINGLE_PAGE_APPLICATION_CLEAR_CACHE", (Object)Boolean.TRUE);
        }
        if (!ArrayUtil.contains((Object[])displayViews, (Object)displayStyle)) {
            displayStyle = displayViews[0];
        }
        return displayStyle;
    }

    public Folder getFolder() {
        return this._folder;
    }

    public long getFolderId() {
        return this._folderId;
    }

    public String getNavigation() {
        return ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"home");
    }

    public String getOrderByCol() {
        String orderByCol = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByCol");
        long fileEntryTypeId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"fileEntryTypeId", (long)-1L);
        if (orderByCol.equals("downloads") && fileEntryTypeId >= 0L) {
            orderByCol = "modifiedDate";
        }
        if (Validator.isNotNull((String)orderByCol)) {
            this._portalPreferences.setValue("com_liferay_document_library_web_portlet_DLPortlet", "order-by-col", orderByCol);
        } else {
            orderByCol = this._portalPreferences.getValue("com_liferay_document_library_web_portlet_DLPortlet", "order-by-col", "modifiedDate");
        }
        return orderByCol;
    }

    public String getOrderByType() {
        String orderByType = ParamUtil.getString((HttpServletRequest)this._request, (String)"orderByType");
        if (Validator.isNotNull((String)orderByType)) {
            this._portalPreferences.setValue("com_liferay_document_library_web_portlet_DLPortlet", "order-by-type", orderByType);
        } else {
            orderByType = this._portalPreferences.getValue("com_liferay_document_library_web_portlet_DLPortlet", "order-by-type", "asc");
        }
        return orderByType;
    }

    public long getRepositoryId() {
        Folder folder = this.getFolder();
        if (folder != null) {
            return folder.getRepositoryId();
        }
        return this._themeDisplay.getScopeGroupId();
    }

    public long getRootFolderId() {
        return this._rootFolderId;
    }

    public String getRootFolderName() {
        return this._rootFolderName;
    }

    public SearchContainer getSearchContainer() {
        if (this._searchContainer == null) {
            try {
                this._searchContainer = this.isSearch() ? this._getSearchSearchContainer() : this._getDLSearchContainer();
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
        return this._searchContainer;
    }

    public PortletURL getSearchSearchContainerURL() {
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/document_library/search");
        String redirect = ParamUtil.getString((HttpServletRequest)this._request, (String)"redirect");
        portletURL.setParameter("redirect", redirect);
        long searchFolderId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchFolderId");
        portletURL.setParameter("searchFolderId", String.valueOf(searchFolderId));
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        portletURL.setParameter("keywords", keywords);
        return portletURL;
    }

    public boolean isDefaultFolderView() {
        return this._defaultFolderView;
    }

    public boolean isSearch() {
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)this._request, (String)"mvcRenderCommandName");
        return mvcRenderCommandName.equals("/document_library/search");
    }

    private void _computeFolders() {
        try {
            this._computeRootFolder();
            this._folder = (Folder)this._request.getAttribute("DOCUMENT_LIBRARY_FOLDER");
            this._folderId = BeanPropertiesUtil.getLong((Object)this._folder, (String)"folderId", (long)this.getRootFolderId());
            this._defaultFolderView = false;
            if (this._folder == null && this._folderId != 0L) {
                this._defaultFolderView = true;
            }
            if (this._defaultFolderView) {
                try {
                    this._folder = DLAppLocalServiceUtil.getFolder((long)this._folderId);
                }
                catch (NoSuchFolderException nsfe) {
                    this._folderId = 0L;
                    if (_log.isWarnEnabled()) {
                        _log.warn((Object)("Unable to get folder " + this._folderId), (Throwable)nsfe);
                    }
                }
            }
        }
        catch (PortalException pe) {
            throw new SystemException((Throwable)pe);
        }
    }

    private void _computeRootFolder() {
        this._rootFolderId = this._dlPortletInstanceSettings.getRootFolderId();
        this._rootFolderName = "";
        if (this._rootFolderId != 0L) {
            try {
                Folder rootFolder = DLAppLocalServiceUtil.getFolder((long)this._rootFolderId);
                this._rootFolderName = rootFolder.getName();
                if (rootFolder.getGroupId() != this._themeDisplay.getScopeGroupId()) {
                    this._rootFolderId = 0L;
                    this._rootFolderName = "";
                }
            }
            catch (NoSuchFolderException nsfe) {
                this._rootFolderId = 0L;
                if (_log.isWarnEnabled()) {
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Could not find folder {folderId=", this._rootFolderId, "}"}), (Throwable)nsfe);
                }
            }
            catch (PortalException pe) {
                throw new SystemException((Throwable)pe);
            }
        }
    }

    private SearchContainer _getDLSearchContainer() throws PortalException {
        String navigation = ParamUtil.getString((HttpServletRequest)this._request, (String)"navigation", (String)"home");
        String currentFolder = ParamUtil.getString((HttpServletRequest)this._request, (String)"curFolder");
        String deltaFolder = ParamUtil.getString((HttpServletRequest)this._request, (String)"deltaFolder");
        long fileEntryTypeId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"fileEntryTypeId", (long)-1L);
        String dlFileEntryTypeName = LanguageUtil.get((HttpServletRequest)this._request, (String)"basic-document");
        int status = 0;
        User user = this._themeDisplay.getUser();
        if (this._permissionChecker.isContentReviewer(user.getCompanyId(), this._themeDisplay.getScopeGroupId())) {
            status = -1;
        }
        long categoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"categoryId");
        String tagName = ParamUtil.getString((HttpServletRequest)this._request, (String)"tag");
        boolean useAssetEntryQuery = false;
        if (categoryId > 0L || Validator.isNotNull((String)tagName)) {
            useAssetEntryQuery = true;
        }
        PortletURL portletURL = this._liferayPortletResponse.createRenderURL();
        long folderId = this.getFolderId();
        if (folderId == 0L) {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        } else {
            portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        }
        portletURL.setParameter("navigation", navigation);
        portletURL.setParameter("curFolder", currentFolder);
        portletURL.setParameter("deltaFolder", deltaFolder);
        portletURL.setParameter("folderId", String.valueOf(folderId));
        SearchContainer dlSearchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, null, null, "curEntry", this._dlPortletInstanceSettings.getEntriesPerPage(), portletURL, null, null);
        Object[] entryColumns = this._dlPortletInstanceSettingsHelper.getEntryColumns();
        dlSearchContainer.setHeaderNames(ListUtil.fromArray((Object[])entryColumns));
        String orderByCol = this.getOrderByCol();
        String orderByType = this.getOrderByType();
        boolean orderByModel = false;
        if (navigation.equals("home")) {
            orderByModel = true;
        }
        OrderByComparator orderByComparator = DLUtil.getRepositoryModelOrderByComparator((String)orderByCol, (String)orderByType, (boolean)orderByModel);
        if (navigation.equals("recent")) {
            orderByComparator = new RepositoryModelModifiedDateComparator();
        }
        dlSearchContainer.setOrderByCol(orderByCol);
        dlSearchContainer.setOrderByComparator(orderByComparator);
        dlSearchContainer.setOrderByType(orderByType);
        List<FileEntry> results = new ArrayList();
        int total = 0;
        if (fileEntryTypeId >= 0L) {
            Indexer indexer = IndexerRegistryUtil.getIndexer((String)DLFileEntryConstants.getClassName());
            if (fileEntryTypeId > 0L) {
                DLFileEntryType dlFileEntryType = DLFileEntryTypeLocalServiceUtil.getFileEntryType((long)fileEntryTypeId);
                dlFileEntryTypeName = dlFileEntryType.getName(this._request.getLocale());
            }
            SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
            searchContext.setAttribute("paginationType", (Serializable)((Object)"none"));
            searchContext.setEnd(dlSearchContainer.getEnd());
            int type = 3;
            String fieldName = orderByCol;
            if (orderByCol.equals("creationDate")) {
                fieldName = "createDate";
                type = 6;
            } else if (orderByCol.equals("modifiedDate")) {
                fieldName = "modified";
                type = 6;
            } else if (orderByCol.equals("size")) {
                type = 6;
            }
            Sort sort = new Sort(fieldName, type, !StringUtil.equalsIgnoreCase((String)orderByType, (String)"asc"));
            searchContext.setSorts(new Sort[]{sort});
            searchContext.setStart(dlSearchContainer.getStart());
            Hits hits = indexer.search(searchContext);
            total = hits.getLength();
            dlSearchContainer.setTotal(total);
            for (Document doc : hits.getDocs()) {
                long fileEntryId = GetterUtil.getLong((String)doc.get("entryClassPK"));
                FileEntry fileEntry = null;
                try {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)fileEntryId);
                }
                catch (Exception e) {
                    if (!_log.isWarnEnabled()) continue;
                    _log.warn((Object)StringBundler.concat((Object[])new Object[]{"Documents and Media search index is stale ", "and contains file entry {", fileEntryId, "}"}));
                    continue;
                }
                results.add(fileEntry);
            }
        } else if (navigation.equals("home")) {
            if (useAssetEntryQuery) {
                long[] classNameIds = new long[]{PortalUtil.getClassNameId((String)DLFileEntryConstants.getClassName()), PortalUtil.getClassNameId((String)DLFileShortcutConstants.getClassName())};
                AssetEntryQuery assetEntryQuery = new AssetEntryQuery(classNameIds, dlSearchContainer);
                assetEntryQuery.setEnablePermissions(true);
                assetEntryQuery.setExcludeZeroViewCount(false);
                total = AssetEntryServiceUtil.getEntriesCount((AssetEntryQuery)assetEntryQuery);
                dlSearchContainer.setTotal(total);
                results = AssetEntryServiceUtil.getEntries((AssetEntryQuery)assetEntryQuery);
            } else {
                long repositoryId = this.getRepositoryId();
                total = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcutsCount((long)repositoryId, (long)folderId, (int)status, (boolean)true);
                dlSearchContainer.setTotal(total);
                results = DLAppServiceUtil.getFoldersAndFileEntriesAndFileShortcuts((long)repositoryId, (long)folderId, (int)status, (boolean)true, (int)dlSearchContainer.getStart(), (int)dlSearchContainer.getEnd(), (OrderByComparator)dlSearchContainer.getOrderByComparator());
            }
        } else if (navigation.equals("mine") || navigation.equals("recent")) {
            long groupFileEntriesUserId = 0L;
            if (navigation.equals("mine") && this._themeDisplay.isSignedIn()) {
                groupFileEntriesUserId = this._themeDisplay.getUserId();
                status = -1;
            }
            long repositoryId = this.getRepositoryId();
            total = DLAppServiceUtil.getGroupFileEntriesCount((long)repositoryId, (long)groupFileEntriesUserId, (long)folderId, null, (int)status);
            dlSearchContainer.setTotal(total);
            results = DLAppServiceUtil.getGroupFileEntries((long)repositoryId, (long)groupFileEntriesUserId, (long)folderId, null, (int)status, (int)dlSearchContainer.getStart(), (int)dlSearchContainer.getEnd(), (OrderByComparator)dlSearchContainer.getOrderByComparator());
        }
        dlSearchContainer.setResults(results);
        if (fileEntryTypeId >= 0L) {
            dlSearchContainer.setEmptyResultsMessage(LanguageUtil.format((HttpServletRequest)this._request, (String)"there-are-no-documents-or-media-files-of-type-x", (Object)HtmlUtil.escape((String)dlFileEntryTypeName)));
        } else {
            dlSearchContainer.setEmptyResultsMessage("there-are-no-documents-or-media-files-in-this-folder");
        }
        return dlSearchContainer;
    }

    private List _getSearchResults(SearchContainer searchContainer) throws PortalException {
        SearchContext searchContext = SearchContextFactory.getInstance((HttpServletRequest)this._request);
        searchContext.setAttribute("paginationType", (Serializable)((Object)"regular"));
        long searchRepositoryId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchRepositoryId");
        if (searchRepositoryId == 0L) {
            searchRepositoryId = this._themeDisplay.getScopeGroupId();
        }
        searchContext.setAttribute("searchRepositoryId", (Serializable)Long.valueOf(searchRepositoryId));
        searchContext.setEnd(searchContainer.getEnd());
        long searchFolderId = ParamUtil.getLong((HttpServletRequest)this._request, (String)"searchFolderId");
        searchContext.setFolderIds(new long[]{searchFolderId});
        searchContext.setIncludeDiscussions(true);
        String keywords = ParamUtil.getString((HttpServletRequest)this._request, (String)"keywords");
        searchContext.setKeywords(keywords);
        QueryConfig queryConfig = searchContext.getQueryConfig();
        queryConfig.setSearchSubfolders(true);
        searchContext.setStart(searchContainer.getStart());
        Hits hits = DLAppServiceUtil.search((long)searchRepositoryId, (SearchContext)searchContext);
        List searchResults = SearchResultUtil.getSearchResults((Hits)hits, (Locale)this._request.getLocale());
        ArrayList<Object> dlSearchResults = new ArrayList<Object>();
        for (SearchResult searchResult : searchResults) {
            FileEntry fileEntry = null;
            Folder curFolder = null;
            String className = searchResult.getClassName();
            try {
                List fileEntryRelatedSearchResults = searchResult.getFileEntryRelatedSearchResults();
                if (!fileEntryRelatedSearchResults.isEmpty()) {
                    fileEntryRelatedSearchResults.forEach(fileEntryRelatedSearchResult -> dlSearchResults.add(fileEntryRelatedSearchResult.getModel()));
                    continue;
                }
                if (className.equals(DLFileEntry.class.getName()) || FileEntry.class.isAssignableFrom(Class.forName(className))) {
                    fileEntry = DLAppLocalServiceUtil.getFileEntry((long)searchResult.getClassPK());
                    dlSearchResults.add(fileEntry);
                    continue;
                }
                if (!className.equals(DLFolder.class.getName())) continue;
                curFolder = DLAppLocalServiceUtil.getFolder((long)searchResult.getClassPK());
                dlSearchResults.add(curFolder);
            }
            catch (ClassNotFoundException cnfe) {
                throw new PortalException((Throwable)cnfe);
            }
        }
        return dlSearchResults;
    }

    private SearchContainer _getSearchSearchContainer() throws PortalException {
        SearchContainer searchContainer = new SearchContainer((PortletRequest)this._liferayPortletRequest, this.getSearchSearchContainerURL(), null, null);
        List results = this._getSearchResults(searchContainer);
        searchContainer.setResults(results);
        searchContainer.setTotal(results.size());
        return searchContainer;
    }
}

