/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.util;

import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.web.internal.settings.DLPortletInstanceSettings;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.portlet.LiferayWindowState;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import javax.portlet.PortletURL;
import javax.portlet.RenderResponse;
import javax.portlet.WindowStateException;
import javax.servlet.http.HttpServletRequest;

public class DLBreadcrumbUtil {
    public static void addPortletBreadcrumbEntries(FileEntry fileEntry, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = fileEntry.getFolder();
        if (folder.getFolderId() != 0L) {
            DLBreadcrumbUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        PortletURL portletURL = renderResponse.createRenderURL();
        FileEntry unescapedFileEntry = (FileEntry)fileEntry.toUnescapedModel();
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileEntry.getFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFileEntry.getTitle(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(FileShortcut fileShortcut, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder = fileShortcut.getFolder();
        if (folder.getFolderId() != 0L) {
            DLBreadcrumbUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
        FileShortcut unescapedDLFileShortcut = (FileShortcut)fileShortcut.toUnescapedModel();
        PortletURL portletURL = renderResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(fileShortcut.getToFileEntryId()));
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedDLFileShortcut.getToTitle(), (String)portletURL.toString());
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, LiferayPortletResponse liferayPortletResponse) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PortletURL portletURL = liferayPortletResponse.createRenderURL();
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("direction-right", Boolean.TRUE.toString());
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
        data.put("folder-id", dlPortletInstanceSettings.getRootFolderId());
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString(), data);
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
        DLBreadcrumbUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, PortletURL portletURL) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long rootFolderId = 0L;
        boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ignoreRootFolder");
        if (!ignoreRootFolder) {
            PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
            DLPortletInstanceSettings dlPortletInstanceSettings = DLPortletInstanceSettings.getInstance(themeDisplay.getLayout(), portletDisplay.getId());
            rootFolderId = dlPortletInstanceSettings.getRootFolderId();
        }
        List ancestorFolders = Collections.emptyList();
        if (folder != null && folder.getFolderId() != rootFolderId) {
            ancestorFolders = folder.getAncestors();
            int indexOfRootFolder = -1;
            for (int i = 0; i < ancestorFolders.size(); ++i) {
                Folder ancestorFolder = (Folder)ancestorFolders.get(i);
                if (rootFolderId != ancestorFolder.getFolderId()) continue;
                indexOfRootFolder = i;
            }
            if (indexOfRootFolder > -1) {
                ancestorFolders = ancestorFolders.subList(0, indexOfRootFolder);
            }
        }
        Collections.reverse(ancestorFolders);
        for (Folder ancestorFolder : ancestorFolders) {
            portletURL.setParameter("folderId", String.valueOf(ancestorFolder.getFolderId()));
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", ancestorFolder.getFolderId());
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)ancestorFolder.getName(), (String)portletURL.toString(), data);
        }
        long folderId = 0L;
        if (folder != null) {
            folderId = folder.getFolderId();
        }
        portletURL.setParameter("folderId", String.valueOf(folderId));
        if (folderId != 0L && folderId != rootFolderId) {
            Folder unescapedFolder = (Folder)folder.toUnescapedModel();
            HashMap<String, Object> data = new HashMap<String, Object>();
            data.put("direction-right", Boolean.TRUE.toString());
            data.put("folder-id", folderId);
            PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)unescapedFolder.getName(), (String)portletURL.toString(), data);
        }
    }

    public static void addPortletBreadcrumbEntries(Folder folder, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        String mvcRenderCommandName = ParamUtil.getString((HttpServletRequest)request, (String)"mvcRenderCommandName");
        PortletURL portletURL = renderResponse.createRenderURL();
        if (mvcRenderCommandName.equals("/document_library/select_file_entry") || mvcRenderCommandName.equals("/document_library/select_folder")) {
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId");
            boolean ignoreRootFolder = ParamUtil.getBoolean((HttpServletRequest)request, (String)"ignoreRootFolder");
            DLBreadcrumbUtil._addPortletBreadcrumbEntry(request, "mvcRenderCommandName", mvcRenderCommandName, groupId, ignoreRootFolder, portletURL);
        } else {
            long folderId = 0L;
            if (folder != null) {
                folderId = folder.getFolderId();
            }
            if (folderId != 0L) {
                portletURL.setParameter("mvcRenderCommandName", "/document_library/view_folder");
            } else {
                portletURL.setParameter("mvcRenderCommandName", "/document_library/view");
            }
        }
        DLBreadcrumbUtil.addPortletBreadcrumbEntries(folder, request, portletURL);
    }

    public static void addPortletBreadcrumbEntries(long folderId, HttpServletRequest request, RenderResponse renderResponse) throws Exception {
        Folder folder;
        if (folderId != 0L && (folder = DLAppLocalServiceUtil.getFolder((long)folderId)).getFolderId() != 0L) {
            DLBreadcrumbUtil.addPortletBreadcrumbEntries(folder, request, renderResponse);
        }
    }

    private static void _addPortletBreadcrumbEntry(HttpServletRequest request, String parameterName, String parameterValue, long groupId, boolean ignoreRootFolder, PortletURL portletURL) throws WindowStateException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        portletURL.setParameter(parameterName, parameterValue);
        portletURL.setParameter("groupId", String.valueOf(groupId));
        portletURL.setParameter("ignoreRootFolder", String.valueOf(ignoreRootFolder));
        portletURL.setWindowState(LiferayWindowState.POP_UP);
        PortalUtil.addPortletBreadcrumbEntry((HttpServletRequest)request, (String)themeDisplay.translate("home"), (String)portletURL.toString());
    }
}

