/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.upload;

import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.util.DLValidator;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermission;
import com.liferay.portal.kernel.security.permission.resource.ModelResourcePermissionHelper;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.ServiceContextFactory;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.upload.UploadPortletRequest;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.upload.UniqueFileNameProvider;
import com.liferay.upload.UploadFileEntryHandler;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLUploadFileEntryHandler.class})
public class DLUploadFileEntryHandler
implements UploadFileEntryHandler {
    private static final String _PARAMETER_NAME = "imageSelectorFileName";
    private static final Log _log = LogFactoryUtil.getLog(DLUploadFileEntryHandler.class);
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLValidator _dlValidator;
    @Reference(target="(model.class.name=com.liferay.portal.kernel.repository.model.Folder)")
    private ModelResourcePermission<Folder> _folderModelResourcePermission;
    @Reference
    private UniqueFileNameProvider _uniqueFileNameProvider;

    public FileEntry upload(UploadPortletRequest uploadPortletRequest) throws IOException, PortalException {
        ThemeDisplay themeDisplay = (ThemeDisplay)uploadPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        long folderId = ParamUtil.getLong((HttpServletRequest)uploadPortletRequest, (String)"folderId");
        ModelResourcePermissionHelper.check(this._folderModelResourcePermission, (PermissionChecker)themeDisplay.getPermissionChecker(), (long)themeDisplay.getScopeGroupId(), (long)folderId, (String)"ADD_DOCUMENT");
        String fileName = uploadPortletRequest.getFileName(_PARAMETER_NAME);
        long size = uploadPortletRequest.getSize(_PARAMETER_NAME);
        this._dlValidator.validateFileSize(fileName, size);
        String contentType = uploadPortletRequest.getContentType(_PARAMETER_NAME);
        try (InputStream inputStream = uploadPortletRequest.getFileAsStream(_PARAMETER_NAME);){
            String uniqueFileName = this._uniqueFileNameProvider.provide(fileName, curFileName -> this._exists(themeDisplay.getScopeGroupId(), folderId, (String)curFileName));
            ServiceContext serviceContext = ServiceContextFactory.getInstance((String)DLFileEntry.class.getName(), (UploadPortletRequest)uploadPortletRequest);
            FileEntry fileEntry = this._dlAppService.addFileEntry(themeDisplay.getScopeGroupId(), folderId, uniqueFileName, contentType, uniqueFileName, "", "", inputStream, size, serviceContext);
            return fileEntry;
        }
    }

    private boolean _exists(long groupId, long folderId, String fileName) {
        try {
            return this._dlAppService.getFileEntry(groupId, folderId, fileName) != null;
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
    }
}

