/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.toolbar.contributor;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFolder;
import com.liferay.document.library.kernel.service.DLFileEntryTypeService;
import com.liferay.document.library.portlet.toolbar.contributor.DLPortletToolbarContributor;
import com.liferay.document.library.portlet.toolbar.contributor.DLPortletToolbarContributorContext;
import com.liferay.document.library.web.internal.portlet.toolbar.contributor.helper.DLPortletToolbarContributorHelper;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerList;
import com.liferay.osgi.service.tracker.collections.list.ServiceTrackerListFactory;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.portlet.LiferayPortletURL;
import com.liferay.portal.kernel.portlet.PortletURLFactoryUtil;
import com.liferay.portal.kernel.portlet.toolbar.contributor.BasePortletToolbarContributor;
import com.liferay.portal.kernel.portlet.toolbar.contributor.PortletToolbarContributor;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.permission.BaseModelPermissionChecker;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.theme.PortletDisplay;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Portal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.servlet.http.HttpServletRequest;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"javax.portlet.name=com_liferay_document_library_web_portlet_DLPortlet", "mvc.render.command.name=-", "mvc.render.command.name=/document_library/view", "mvc.render.command.name=/document_library/view_folder"}, service={DLPortletToolbarContributor.class, PortletToolbarContributor.class})
public class DefaultDLPortletToolbarContributor
extends BasePortletToolbarContributor
implements DLPortletToolbarContributor {
    private static final Log _log = LogFactoryUtil.getLog(DefaultDLPortletToolbarContributor.class);
    @Reference(target="(model.class.name=com.liferay.document.library.kernel.model.DLFolder)")
    private BaseModelPermissionChecker _baseModelPermissionChecker;
    @Reference
    private DLFileEntryTypeService _dlFileEntryTypeService;
    private ServiceTrackerList<DLPortletToolbarContributorContext, DLPortletToolbarContributorContext> _dlPortletToolbarContributorContexts;
    @Reference
    private DLPortletToolbarContributorHelper _dlPortletToolbarContributorHelper;
    @Reference
    private Portal _portal;

    public MenuItem getFileEntryTypeMenuItem(PortletRequest portletRequest, Folder folder, List<DLFileEntryType> fileEntryTypes, DLFileEntryType fileEntryType, ThemeDisplay themeDisplay) throws PortalException {
        URLMenuItem urlMenuItem = new URLMenuItem();
        String label = LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)fileEntryType.getUnambiguousName(fileEntryTypes, themeDisplay.getScopeGroupId(), themeDisplay.getLocale()));
        urlMenuItem.setLabel(label);
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "add");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(themeDisplay, folder)));
        portletURL.setParameter("folderId", String.valueOf(this._getFolderId(folder)));
        portletURL.setParameter("fileEntryTypeId", String.valueOf(fileEntryType.getFileEntryTypeId()));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public List<MenuItem> getPortletTitleAddDocumentMenuItems(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_DOCUMENT")) {
            return Collections.emptyList();
        }
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        long repositoryId = this._getRepositoryId(themeDisplay, folder);
        if (themeDisplay.getScopeGroupId() != repositoryId) {
            menuItems.add(this._getPortletTitleAddBasicDocumentMenuItem(folder, themeDisplay, portletRequest));
        } else {
            menuItems.addAll(this._getPortletTitleAddDocumentTypeMenuItems(folder, themeDisplay, portletRequest));
        }
        return menuItems;
    }

    public MenuItem getPortletTitleAddFolderMenuItem(ThemeDisplay themeDisplay, PortletRequest portletRequest, Folder folder) {
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_FOLDER")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)(folder != null ? "subfolder" : "folder")));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_folder");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(themeDisplay, folder)));
        portletURL.setParameter("parentFolderId", String.valueOf(folderId));
        portletURL.setParameter("ignoreRootFolder", Boolean.TRUE.toString());
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public MenuItem getPortletTitleAddMultipleDocumentsMenuItem(ThemeDisplay themeDisplay, PortletRequest portletRequest, Folder folder) {
        if (folder != null && !folder.isSupportsMultipleUpload()) {
            return null;
        }
        List<DLFileEntryType> fileEntryTypes = this.getFileEntryTypes(themeDisplay.getScopeGroupId(), folder);
        if (fileEntryTypes.isEmpty()) {
            return null;
        }
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_DOCUMENT")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"multiple-documents"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/upload_multiple_file_entries");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(themeDisplay, folder)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public URLMenuItem getPortletTitleAddRepositoryMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        if (folder != null) {
            return null;
        }
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), 0L, "ADD_REPOSITORY")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"repository"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_repository");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    public URLMenuItem getPortletTitleAddShortcutMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        if (folder != null && !folder.isSupportsShortcuts()) {
            return null;
        }
        long folderId = this._getFolderId(folder);
        if (!this.containsPermission(themeDisplay.getPermissionChecker(), themeDisplay.getScopeGroupId(), folderId, "ADD_SHORTCUT")) {
            return null;
        }
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"shortcut"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_shortcut");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(themeDisplay, folder)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    @Activate
    protected void activate(BundleContext bundleContext) {
        this._dlPortletToolbarContributorContexts = ServiceTrackerListFactory.open((BundleContext)bundleContext, DLPortletToolbarContributorContext.class);
    }

    protected void addPortletTitleAddDocumentMenuItems(List<MenuItem> menuItems, Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        menuItems.addAll(this.getPortletTitleAddDocumentMenuItems(folder, themeDisplay, portletRequest));
    }

    protected void addPortletTitleAddFolderMenuItem(List<MenuItem> menuItems, Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        MenuItem portletTitleAddFolderMenuItem = this.getPortletTitleAddFolderMenuItem(themeDisplay, portletRequest, folder);
        if (portletTitleAddFolderMenuItem != null) {
            menuItems.add(portletTitleAddFolderMenuItem);
        }
    }

    protected void addPortletTitleAddMultipleDocumentsMenuItem(List<MenuItem> menuItems, Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        MenuItem portletTitleAddMultipleDocumentsMenuItem = this.getPortletTitleAddMultipleDocumentsMenuItem(themeDisplay, portletRequest, folder);
        if (portletTitleAddMultipleDocumentsMenuItem != null) {
            menuItems.add(portletTitleAddMultipleDocumentsMenuItem);
        }
    }

    protected void addPortletTitleAddRepositoryMenuItem(List<MenuItem> menuItems, Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        URLMenuItem portletTitleAddRepositoryMenuItem = this.getPortletTitleAddRepositoryMenuItem(folder, themeDisplay, portletRequest);
        if (portletTitleAddRepositoryMenuItem != null) {
            menuItems.add((MenuItem)portletTitleAddRepositoryMenuItem);
        }
    }

    protected void addPortletTitleAddShortcutMenuItem(List<MenuItem> menuItems, Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        URLMenuItem portletTitleAddShortcutMenuItem = this.getPortletTitleAddShortcutMenuItem(folder, themeDisplay, portletRequest);
        if (portletTitleAddShortcutMenuItem != null) {
            menuItems.add((MenuItem)portletTitleAddShortcutMenuItem);
        }
    }

    protected boolean containsPermission(PermissionChecker permissionChecker, long groupId, long folderId, String actionId) {
        try {
            this._baseModelPermissionChecker.checkBaseModel(permissionChecker, groupId, folderId, actionId);
        }
        catch (PortalException pe) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)pe, (Throwable)pe);
            }
            return false;
        }
        return true;
    }

    @Deactivate
    protected void deactivate() {
        this._dlPortletToolbarContributorContexts.close();
    }

    protected List<DLFileEntryType> getFileEntryTypes(long groupId, Folder folder) {
        DLFolder dlFolder;
        long folderId = this._getFolderId(folder);
        boolean inherited = true;
        if (folder != null && folder.getModel() instanceof DLFolder && (dlFolder = (DLFolder)folder.getModel()).getRestrictionType() == 1) {
            inherited = false;
        }
        List fileEntryTypes = Collections.emptyList();
        if (folder == null || folder.isSupportsMetadata()) {
            try {
                fileEntryTypes = this._dlFileEntryTypeService.getFolderFileEntryTypes(this._portal.getCurrentAndAncestorSiteGroupIds(groupId), folderId, inherited);
            }
            catch (PortalException pe) {
                _log.error((Object)StringBundler.concat((Object[])new Object[]{"Unable to get file entry types for group ", groupId, " and folder ", folderId}), (Throwable)pe);
            }
        }
        return fileEntryTypes;
    }

    protected List<MenuItem> getPortletTitleMenuItems(PortletRequest portletRequest, PortletResponse portletResponse) {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        Folder folder = this._dlPortletToolbarContributorHelper.getFolder(themeDisplay, portletRequest);
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        this.addPortletTitleAddFolderMenuItem(menuItems, folder, themeDisplay, portletRequest);
        this.addPortletTitleAddShortcutMenuItem(menuItems, folder, themeDisplay, portletRequest);
        this.addPortletTitleAddRepositoryMenuItem(menuItems, folder, themeDisplay, portletRequest);
        this.addPortletTitleAddMultipleDocumentsMenuItem(menuItems, folder, themeDisplay, portletRequest);
        this.addPortletTitleAddDocumentMenuItems(menuItems, folder, themeDisplay, portletRequest);
        for (DLPortletToolbarContributorContext dlPortletToolbarContributorContext : this._dlPortletToolbarContributorContexts) {
            dlPortletToolbarContributorContext.updatePortletTitleMenuItems(menuItems, folder, themeDisplay, portletRequest, portletResponse);
        }
        return menuItems;
    }

    private long _getFolderId(Folder folder) {
        long folderId = 0L;
        if (folder != null) {
            folderId = folder.getFolderId();
        }
        return folderId;
    }

    private MenuItem _getPortletTitleAddBasicDocumentMenuItem(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        long folderId = this._getFolderId(folder);
        URLMenuItem urlMenuItem = new URLMenuItem();
        urlMenuItem.setLabel(LanguageUtil.get((HttpServletRequest)this._portal.getHttpServletRequest(portletRequest), (String)"basic-document"));
        PortletDisplay portletDisplay = themeDisplay.getPortletDisplay();
        LiferayPortletURL portletURL = PortletURLFactoryUtil.create((PortletRequest)portletRequest, (String)portletDisplay.getId(), (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("cmd", "add");
        portletURL.setParameter("redirect", this._portal.getCurrentURL(portletRequest));
        portletURL.setParameter("repositoryId", String.valueOf(this._getRepositoryId(themeDisplay, folder)));
        portletURL.setParameter("folderId", String.valueOf(folderId));
        urlMenuItem.setURL(portletURL.toString());
        return urlMenuItem;
    }

    private List<MenuItem> _getPortletTitleAddDocumentTypeMenuItems(Folder folder, ThemeDisplay themeDisplay, PortletRequest portletRequest) {
        ArrayList<MenuItem> menuItems = new ArrayList<MenuItem>();
        List<DLFileEntryType> fileEntryTypes = this.getFileEntryTypes(themeDisplay.getScopeGroupId(), folder);
        for (DLFileEntryType fileEntryType : fileEntryTypes) {
            try {
                MenuItem urlMenuItem = this.getFileEntryTypeMenuItem(portletRequest, folder, fileEntryTypes, fileEntryType, themeDisplay);
                menuItems.add(urlMenuItem);
            }
            catch (PortalException pe) {
                _log.error((Object)("Unable to add menu item for file entry type " + fileEntryType.getName()), (Throwable)pe);
            }
        }
        return menuItems;
    }

    private long _getRepositoryId(ThemeDisplay themeDisplay, Folder folder) {
        long repositoryId = themeDisplay.getScopeGroupId();
        if (folder != null) {
            repositoryId = folder.getRepositoryId();
        }
        return repositoryId;
    }
}

