/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.portlet.action;

import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLAppServiceUtil;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.portal.kernel.flash.FlashMagicBytesUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.auth.PrincipalException;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.servlet.ServletResponseUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.HttpUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.repository.liferayrepository.model.LiferayFileEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GetFileActionHelper {
    public void processRequest(HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            long fileEntryId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileEntryId");
            long folderId = ParamUtil.getLong((HttpServletRequest)request, (String)"folderId");
            String name = ParamUtil.getString((HttpServletRequest)request, (String)"name");
            String title = ParamUtil.getString((HttpServletRequest)request, (String)"title");
            String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
            long fileShortcutId = ParamUtil.getLong((HttpServletRequest)request, (String)"fileShortcutId");
            String uuid = ParamUtil.getString((HttpServletRequest)request, (String)"uuid");
            String targetExtension = ParamUtil.getString((HttpServletRequest)request, (String)"targetExtension");
            ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            long groupId = ParamUtil.getLong((HttpServletRequest)request, (String)"groupId", (long)themeDisplay.getScopeGroupId());
            this.getFile(fileEntryId, folderId, name, title, version, fileShortcutId, uuid, groupId, targetExtension, request, response);
        }
        catch (NoSuchFileEntryException nsfee) {
            PortalUtil.sendError((int)404, (Exception)((Object)nsfee), (HttpServletRequest)request, (HttpServletResponse)response);
        }
        catch (PrincipalException pe) {
            this.processPrincipalException(pe, request, response);
        }
        catch (Exception e) {
            PortalUtil.sendError((Exception)e, (HttpServletRequest)request, (HttpServletResponse)response);
        }
    }

    protected void getFile(long fileEntryId, long folderId, String name, String title, String version, long fileShortcutId, String uuid, long groupId, String targetExtension, HttpServletRequest request, HttpServletResponse response) throws Exception {
        FlashMagicBytesUtil.Result flashMagicBytesUtilResult;
        String id;
        File convertedFile;
        if (name.startsWith("DLFE-")) {
            name = name.substring(5);
        }
        name = FileUtil.stripExtension((String)name);
        FileEntry fileEntry = null;
        if (Validator.isNotNull((String)uuid) && groupId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntryByUuidAndGroupId((String)uuid, (long)groupId);
            folderId = fileEntry.getFolderId();
        }
        if (fileEntryId > 0L) {
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        } else if (fileShortcutId <= 0L) {
            if (Validator.isNotNull((String)title)) {
                fileEntry = DLAppServiceUtil.getFileEntry((long)groupId, (long)folderId, (String)title);
            } else if (Validator.isNotNull((String)name)) {
                List dlFileEntries;
                DLFileEntry dlFileEntry = DLFileEntryLocalServiceUtil.fetchFileEntryByName((long)groupId, (long)folderId, (String)name);
                if (dlFileEntry == null && !(dlFileEntries = DLFileEntryLocalServiceUtil.getFileEntries((long)folderId, (String)name)).isEmpty()) {
                    dlFileEntry = (DLFileEntry)dlFileEntries.get(0);
                }
                if (dlFileEntry != null) {
                    ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
                    PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
                    DLFileEntryPermission.check(permissionChecker, dlFileEntry, "VIEW");
                    fileEntry = new LiferayFileEntry(dlFileEntry);
                }
            }
        } else {
            FileShortcut fileShortcut = DLAppServiceUtil.getFileShortcut((long)fileShortcutId);
            fileEntryId = fileShortcut.getToFileEntryId();
            fileEntry = DLAppServiceUtil.getFileEntry((long)fileEntryId);
        }
        if (Validator.isNull((String)version)) {
            if (fileEntry != null && Validator.isNotNull((String)fileEntry.getVersion())) {
                version = fileEntry.getVersion();
            } else {
                throw new NoSuchFileEntryException("{fileEntryId=" + fileEntryId + "}");
            }
        }
        FileVersion fileVersion = fileEntry.getFileVersion(version);
        InputStream is = fileVersion.getContentStream(true);
        String fileName = fileVersion.getTitle();
        String sourceExtension = fileVersion.getExtension();
        if (Validator.isNotNull((String)sourceExtension) && !fileName.endsWith("." + sourceExtension)) {
            fileName = fileName + "." + sourceExtension;
        }
        long contentLength = fileVersion.getSize();
        String contentType = fileVersion.getMimeType();
        if (Validator.isNotNull((String)targetExtension) && (convertedFile = DocumentConversionUtil.convert((String)(id = DLUtil.getTempFileId((long)fileEntry.getFileEntryId(), (String)version)), (InputStream)is, (String)sourceExtension, (String)targetExtension)) != null) {
            fileName = FileUtil.stripExtension((String)fileName).concat(".").concat(targetExtension);
            is = new FileInputStream(convertedFile);
            contentLength = convertedFile.length();
            contentType = MimeTypesUtil.getContentType((String)fileName);
        }
        if ((flashMagicBytesUtilResult = FlashMagicBytesUtil.check((InputStream)is)).isFlash()) {
            fileName = FileUtil.stripExtension((String)fileName) + ".swf";
        }
        is = flashMagicBytesUtilResult.getInputStream();
        ServletResponseUtil.sendFile((HttpServletRequest)request, (HttpServletResponse)response, (String)fileName, (InputStream)is, (long)contentLength, (String)contentType);
    }

    protected void processPrincipalException(Throwable t, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        ThemeDisplay themeDisplay = (ThemeDisplay)request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        PermissionChecker permissionChecker = themeDisplay.getPermissionChecker();
        User user = permissionChecker.getUser();
        if (user != null && !user.isDefaultUser()) {
            PortalUtil.sendError((int)401, (Exception)((Exception)t), (HttpServletRequest)request, (HttpServletResponse)response);
            return;
        }
        String redirect = PortalUtil.getPathMain() + "/portal/login";
        String currentURL = PortalUtil.getCurrentURL((HttpServletRequest)request);
        redirect = HttpUtil.addParameter((String)redirect, (String)"redirect", (String)currentURL);
        response.sendRedirect(redirect);
    }
}

