/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.web.internal.asset;

import com.liferay.asset.kernel.model.AssetRendererFactory;
import com.liferay.asset.kernel.model.BaseJSPAssetRenderer;
import com.liferay.asset.kernel.model.DDMFormValuesReader;
import com.liferay.document.library.kernel.document.conversion.DocumentConversionUtil;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.service.DLFileEntryLocalService;
import com.liferay.document.library.kernel.service.DLFileEntryLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.web.internal.security.permission.resource.DLFileEntryPermission;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.model.Group;
import com.liferay.portal.kernel.portlet.LiferayPortletRequest;
import com.liferay.portal.kernel.portlet.LiferayPortletResponse;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.GroupLocalServiceUtil;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.trash.TrashRenderer;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.kernel.util.PortalUtil;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PropsValues;
import com.liferay.portlet.documentlibrary.asset.DLFileEntryDDMFormValuesReader;
import com.liferay.trash.TrashHelper;
import java.util.Date;
import java.util.Locale;
import javax.portlet.PortletRequest;
import javax.portlet.PortletResponse;
import javax.portlet.PortletURL;
import javax.portlet.WindowState;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DLFileEntryAssetRenderer
extends BaseJSPAssetRenderer<FileEntry>
implements TrashRenderer {
    private final DLFileEntryLocalService _dlFileEntryLocalService;
    private final FileEntry _fileEntry;
    private FileVersion _fileVersion;
    private final TrashHelper _trashHelper;

    @Deprecated
    public DLFileEntryAssetRenderer(FileEntry fileEntry, FileVersion fileVersion) {
        this(fileEntry, fileVersion, DLFileEntryLocalServiceUtil.getService());
    }

    @Deprecated
    public DLFileEntryAssetRenderer(FileEntry fileEntry, FileVersion fileVersion, DLFileEntryLocalService dlFileEntryLocalService) {
        this(fileEntry, fileVersion, dlFileEntryLocalService, null);
    }

    public DLFileEntryAssetRenderer(FileEntry fileEntry, FileVersion fileVersion, DLFileEntryLocalService dlFileEntryLocalService, TrashHelper trashHelper) {
        this._fileEntry = fileEntry;
        this._fileVersion = fileVersion;
        this._dlFileEntryLocalService = dlFileEntryLocalService;
        this._trashHelper = trashHelper;
    }

    public FileEntry getAssetObject() {
        return this._fileEntry;
    }

    public String getClassName() {
        return DLFileEntry.class.getName();
    }

    public long getClassPK() {
        String version = this._fileVersion.getVersion();
        if (!this._fileVersion.isApproved() && this._fileVersion.isDraft() && !this._fileVersion.isPending() && !version.equals("1.0")) {
            return this._fileVersion.getFileVersionId();
        }
        return this._fileEntry.getFileEntryId();
    }

    public DDMFormValuesReader getDDMFormValuesReader() {
        return new DLFileEntryDDMFormValuesReader(this._fileEntry, this._fileVersion);
    }

    public String getDiscussionPath() {
        if (PropsValues.DL_FILE_ENTRY_COMMENTS_ENABLED) {
            return "edit_file_entry_discussion";
        }
        return null;
    }

    @Deprecated
    public Date getDisplayDate() {
        return this._fileEntry.getModifiedDate();
    }

    public long getGroupId() {
        return this._fileEntry.getGroupId();
    }

    public String getIconCssClass() {
        return this._fileEntry.getIconCssClass();
    }

    public String getJspPath(HttpServletRequest request, String template) {
        if (template.equals("abstract") || template.equals("full_content")) {
            return "/document_library/asset/file_entry_" + template + ".jsp";
        }
        return null;
    }

    public String getNewName(String oldName, String token) {
        String extension = FileUtil.getExtension((String)oldName);
        if (Validator.isNull((String)extension)) {
            return super.getNewName(oldName, token);
        }
        StringBundler sb = new StringBundler(5);
        int index = oldName.lastIndexOf(46);
        sb.append(oldName.substring(0, index));
        sb.append(" ");
        sb.append(token);
        sb.append(".");
        sb.append(extension);
        return sb.toString();
    }

    public String getPortletId() {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        return assetRendererFactory.getPortletId();
    }

    public int getStatus() {
        return this._fileVersion.getStatus();
    }

    public String getSummary(PortletRequest portletRequest, PortletResponse portletResponse) {
        return this._fileEntry.getDescription();
    }

    public String[] getSupportedConversions() {
        return DocumentConversionUtil.getConversions((String)this._fileEntry.getExtension());
    }

    public String getThumbnailPath(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        String thumbnailSrc = DLUtil.getThumbnailSrc((FileEntry)this._fileEntry, (ThemeDisplay)themeDisplay);
        if (Validator.isNotNull((String)thumbnailSrc)) {
            return thumbnailSrc;
        }
        return super.getThumbnailPath(portletRequest);
    }

    public String getTitle(Locale locale) {
        String title = null;
        title = this.getAssetRendererType() == 0 ? this._fileVersion.getTitle() : this._fileEntry.getTitle();
        if (this._trashHelper == null) {
            return title;
        }
        return this._trashHelper.getOriginalTitle(title);
    }

    public String getType() {
        return "document";
    }

    public String getURLDownload(ThemeDisplay themeDisplay) {
        return DLUtil.getDownloadURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)themeDisplay, (String)"");
    }

    public PortletURL getURLEdit(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        Group group = GroupLocalServiceUtil.fetchGroup((long)this._fileEntry.getGroupId());
        if (group.isCompany()) {
            ThemeDisplay themeDisplay = (ThemeDisplay)liferayPortletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            group = themeDisplay.getScopeGroup();
        }
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (Group)group, (String)"com_liferay_document_library_web_portlet_DLPortlet", (long)0L, (long)0L, (String)"RENDER_PHASE");
        portletURL.setParameter("mvcRenderCommandName", "/document_library/edit_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        return portletURL;
    }

    public PortletURL getURLExport(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse) throws Exception {
        PortletURL portletURL = PortalUtil.getControlPanelPortletURL((PortletRequest)liferayPortletRequest, (String)"com_liferay_document_library_web_portlet_DLPortlet", (String)"ACTION_PHASE");
        portletURL.setParameter("javax.portlet.action", "/document_library/get_file");
        portletURL.setParameter("groupId", String.valueOf(this._fileEntry.getRepositoryId()));
        portletURL.setParameter("folderId", String.valueOf(this._fileEntry.getFolderId()));
        portletURL.setParameter("title", String.valueOf(this._fileEntry.getTitle()));
        return portletURL;
    }

    public String getURLImagePreview(PortletRequest portletRequest) throws Exception {
        ThemeDisplay themeDisplay = (ThemeDisplay)portletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        return DLUtil.getImagePreviewURL((FileEntry)this._fileEntry, (FileVersion)this._fileVersion, (ThemeDisplay)themeDisplay);
    }

    public String getURLView(LiferayPortletResponse liferayPortletResponse, WindowState windowState) throws Exception {
        AssetRendererFactory assetRendererFactory = this.getAssetRendererFactory();
        PortletURL portletURL = assetRendererFactory.getURLView(liferayPortletResponse, windowState);
        portletURL.setParameter("mvcRenderCommandName", "/document_library/view_file_entry");
        portletURL.setParameter("fileEntryId", String.valueOf(this._fileEntry.getFileEntryId()));
        portletURL.setWindowState(windowState);
        return portletURL.toString();
    }

    public String getURLViewInContext(LiferayPortletRequest liferayPortletRequest, LiferayPortletResponse liferayPortletResponse, String noSuchEntryRedirect) {
        return this.getURLViewInContext(liferayPortletRequest, noSuchEntryRedirect, "/document_library/find_file_entry", "fileEntryId", this._fileEntry.getFileEntryId());
    }

    public long getUserId() {
        return this._fileEntry.getUserId();
    }

    public String getUserName() {
        return this._fileEntry.getUserName();
    }

    public String getUuid() {
        return this._fileEntry.getUuid();
    }

    public boolean hasDeletePermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "DELETE");
    }

    public boolean hasEditPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "UPDATE");
    }

    public boolean hasViewPermission(PermissionChecker permissionChecker) throws PortalException {
        return DLFileEntryPermission.contains(permissionChecker, this._fileEntry.getFileEntryId(), "VIEW");
    }

    public boolean include(HttpServletRequest request, HttpServletResponse response, String template) throws Exception {
        request.setAttribute("DOCUMENT_LIBRARY_FILE_ENTRY", (Object)this._fileEntry);
        String version = ParamUtil.getString((HttpServletRequest)request, (String)"version");
        if (this.getAssetRendererType() == 0 || Validator.isNotNull((String)version)) {
            if (this._fileEntry != null && Validator.isNotNull((String)version)) {
                this._fileVersion = this._fileEntry.getFileVersion(version);
            }
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileVersion);
        } else {
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)this._fileEntry.getFileVersion());
        }
        return super.include(request, response, template);
    }

    public boolean isCategorizable(long groupId) {
        long classPK = this.getClassPK();
        DLFileEntry dlFileEntry = this._dlFileEntryLocalService.fetchDLFileEntry(classPK);
        if (dlFileEntry == null || dlFileEntry.getRepositoryId() != groupId) {
            return false;
        }
        return super.isCategorizable(groupId);
    }

    public boolean isConvertible() {
        return true;
    }

    public boolean isPrintable() {
        return false;
    }
}

