/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.expando.kernel.model.ExpandoBridge;
import com.liferay.expando.kernel.util.ExpandoBridgeFactoryUtil;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.model.RepositoryModel;
import com.liferay.portal.kernel.service.UserLocalServiceUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Date;
import java.util.Map;

public abstract class ExtRepositoryModelAdapter<T>
implements Cloneable,
RepositoryModel<T> {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryModelAdapter.class);
    private final ExtRepositoryAdapter _extRepositoryAdapter;
    private final ExtRepositoryModel _extRepositoryModel;
    private final long _extRepositoryObjectId;
    private final String _uuid;

    public T clone() {
        try {
            return (T)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException(cloneNotSupportedException);
        }
    }

    public Map<String, Serializable> getAttributes() {
        return Collections.emptyMap();
    }

    public long getCompanyId() {
        return this._extRepositoryAdapter.getCompanyId();
    }

    public Date getCreateDate() {
        return this._extRepositoryModel.getCreateDate();
    }

    public String getDescription() {
        return "";
    }

    public ExpandoBridge getExpandoBridge() {
        return ExpandoBridgeFactoryUtil.getExpandoBridge((long)this.getCompanyId(), (String)this.getModelClassName(), (long)this.getPrimaryKey());
    }

    public ExtRepositoryModel getExtRepositoryModel() {
        return this._extRepositoryModel;
    }

    public long getGroupId() {
        return this._extRepositoryAdapter.getGroupId();
    }

    public Date getLastPublishDate() {
        return null;
    }

    public Object getModel() {
        return this._extRepositoryModel;
    }

    public String getModelClassName() {
        Class modelClass = this.getModelClass();
        return modelClass.getName();
    }

    public long getPrimaryKey() {
        return this._extRepositoryObjectId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getRepositoryId() {
        return this._extRepositoryAdapter.getRepositoryId();
    }

    public long getSize() {
        return this._extRepositoryModel.getSize();
    }

    public long getUserId() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        return user.getUserId();
    }

    public String getUserName() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        return user.getFullName();
    }

    public String getUserUuid() {
        User user = this.getUser(this._extRepositoryModel.getOwner());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public void setCompanyId(long companyId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setCreateDate(Date date) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setGroupId(long groupId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setLastPublishDate(Date lastPublishDate) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setModifiedDate(Date modifiedDate) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setUserId(long userId) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setUserName(String userName) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setUserUuid(String userUuid) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public void setUuid(String uuid) {
        throw new UnsupportedOperationException("Model is read only");
    }

    public T toEscapedModel() {
        return (T)this;
    }

    public T toUnescapedModel() {
        return (T)this;
    }

    protected ExtRepositoryModelAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryModel extRepositoryModel) {
        this._extRepositoryAdapter = extRepositoryAdapter;
        this._extRepositoryObjectId = extRepositoryObjectId;
        this._uuid = uuid;
        this._extRepositoryModel = extRepositoryModel;
    }

    protected ExtRepositoryAdapter getRepository() {
        return this._extRepositoryAdapter;
    }

    protected User getUser(String extRepositoryUserName) {
        User user;
        block12: {
            block11: {
                user = null;
                if (Validator.isNotNull((String)extRepositoryUserName)) {
                    String liferayLogin = this._extRepositoryAdapter.getLiferayLogin(extRepositoryUserName);
                    try {
                        String authType = this._extRepositoryAdapter.getAuthType();
                        if (authType.equals("userId")) {
                            user = UserLocalServiceUtil.getUser((long)GetterUtil.getLong((String)liferayLogin));
                        } else if (authType.equals("emailAddress")) {
                            user = UserLocalServiceUtil.getUserByEmailAddress((long)this.getCompanyId(), (String)liferayLogin);
                        } else if (authType.equals("screenName")) {
                            user = UserLocalServiceUtil.getUserByScreenName((long)this.getCompanyId(), (String)liferayLogin);
                        }
                    }
                    catch (Exception exception) {
                        if (!_log.isDebugEnabled()) break block11;
                        _log.debug((Throwable)exception);
                    }
                }
            }
            if (user == null) {
                try {
                    user = UserLocalServiceUtil.getDefaultUser((long)this.getCompanyId());
                }
                catch (Exception exception) {
                    if (!_log.isDebugEnabled()) break block12;
                    _log.debug((Throwable)exception);
                }
            }
        }
        return user;
    }
}

