/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external.model;

import com.liferay.document.library.kernel.model.DLFolderConstants;
import com.liferay.document.library.kernel.service.DLAppLocalServiceUtil;
import com.liferay.document.library.repository.external.ExtRepositoryAdapter;
import com.liferay.document.library.repository.external.ExtRepositoryFolder;
import com.liferay.document.library.repository.external.model.ExtRepositoryObjectAdapter;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import java.util.Date;

public class ExtRepositoryFolderAdapter
extends ExtRepositoryObjectAdapter<Folder>
implements Folder {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryFolderAdapter.class);
    private final ExtRepositoryFolder _extRepositoryFolder;

    public ExtRepositoryFolderAdapter(ExtRepositoryAdapter extRepositoryAdapter, long extRepositoryObjectId, String uuid, ExtRepositoryFolder extRepositoryFolder) {
        super(extRepositoryAdapter, extRepositoryObjectId, uuid, extRepositoryFolder);
        this._extRepositoryFolder = extRepositoryFolder;
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((Folder)this);
    }

    @Override
    public ExtRepositoryFolder getExtRepositoryModel() {
        return this._extRepositoryFolder;
    }

    public long getFolderId() {
        return this.getPrimaryKey();
    }

    public Date getLastPostDate() {
        return this.getModifiedDate();
    }

    public Class<?> getModelClass() {
        return Folder.class;
    }

    @Override
    public String getName() {
        if (this.isRoot()) {
            try {
                Folder folder = DLAppLocalServiceUtil.getMountFolder((long)this.getRepositoryId());
                return folder.getName();
            }
            catch (Exception e) {
                _log.error((Object)e, (Throwable)e);
            }
        }
        return this._extRepositoryFolder.getName();
    }

    public long getParentFolderId() {
        try {
            Folder parentFolder = this.getParentFolder();
            if (parentFolder != null) {
                return parentFolder.getFolderId();
            }
        }
        catch (Exception e) {
            _log.error((Object)e, (Throwable)e);
        }
        return 0L;
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return (T)repository.getCapability(capabilityClass);
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFolderConstants.getClassName());
    }

    public boolean hasInheritableLock() {
        return false;
    }

    public boolean hasLock() {
        return false;
    }

    public boolean isLocked() {
        return false;
    }

    public boolean isMountPoint() {
        return false;
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this._getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isRoot() {
        return this._extRepositoryFolder.isRoot();
    }

    public boolean isSupportsLocking() {
        return false;
    }

    public boolean isSupportsMultipleUpload() {
        return false;
    }

    public boolean isSupportsShortcuts() {
        return false;
    }

    public boolean isSupportsSubscribing() {
        return false;
    }

    private Repository _getRepository() {
        try {
            return RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to get repository for folder " + this.getFolderId(), (Throwable)pe);
        }
    }
}

