/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.external;

import com.liferay.document.library.repository.external.ExtRepositoryModel;
import com.liferay.document.library.repository.external.model.ExtRepositoryModelAdapter;
import com.liferay.petra.lang.CentralizedThreadLocal;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import java.util.HashMap;
import java.util.Map;

public class ExtRepositoryAdapterCache
implements Cloneable {
    private static final Log _log = LogFactoryUtil.getLog(ExtRepositoryAdapterCache.class);
    private static final ThreadLocal<ExtRepositoryAdapterCache> _extRepositoryAdapterThreadLocal = new CentralizedThreadLocal(ExtRepositoryAdapterCache.class.getName(), ExtRepositoryAdapterCache::new);
    private Map<String, ExtRepositoryModelAdapter<?>> _extRepositoryAdapters;

    public static ExtRepositoryAdapterCache getInstance() {
        return _extRepositoryAdapterThreadLocal.get();
    }

    public void clear() {
        this._extRepositoryAdapters.clear();
    }

    public ExtRepositoryAdapterCache clone() {
        if (_log.isInfoEnabled()) {
            Thread currentThread = Thread.currentThread();
            _log.info((Object)("Create " + currentThread.getName()));
        }
        try {
            return (ExtRepositoryAdapterCache)super.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse);
        }
    }

    public <T extends ExtRepositoryModelAdapter<?>> T get(String extRepositoryModelKey) {
        Map<String, ExtRepositoryModelAdapter<?>> extRepositoryAdapters = this._getExtRepositoryAdapters();
        ExtRepositoryModelAdapter<?> extRepositoryAdapter = extRepositoryAdapters.get(extRepositoryModelKey);
        if (extRepositoryAdapter != null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)("Hit " + extRepositoryModelKey));
            }
        } else if (_log.isDebugEnabled()) {
            _log.debug((Object)("Miss " + extRepositoryModelKey));
        }
        return (T)extRepositoryAdapter;
    }

    public void put(ExtRepositoryModelAdapter<?> extRepositoryModelAdapter) {
        Map<String, ExtRepositoryModelAdapter<?>> extRepositoryAdapters = this._getExtRepositoryAdapters();
        ExtRepositoryModel extRepositoryModel = extRepositoryModelAdapter.getExtRepositoryModel();
        String extRepositoryModelKey = extRepositoryModel.getExtRepositoryModelKey();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Put " + extRepositoryModelKey));
        }
        extRepositoryAdapters.put(extRepositoryModelKey, extRepositoryModelAdapter);
    }

    public void remove(String extRepositoryModelKey) {
        Map<String, ExtRepositoryModelAdapter<?>> extRepositoryAdapters = this._getExtRepositoryAdapters();
        if (_log.isInfoEnabled()) {
            _log.info((Object)("Remove " + extRepositoryModelKey));
        }
        extRepositoryAdapters.remove(extRepositoryModelKey);
    }

    private Map<String, ExtRepositoryModelAdapter<?>> _getExtRepositoryAdapters() {
        if (this._extRepositoryAdapters == null) {
            this._extRepositoryAdapters = new HashMap();
        }
        return this._extRepositoryAdapters;
    }
}

