/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal.model;

import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.exception.NoSuchFileVersionException;
import com.liferay.document.library.kernel.model.DLFileEntryConstants;
import com.liferay.document.library.kernel.service.DLAppHelperLocalServiceUtil;
import com.liferay.document.library.kernel.util.DLUtil;
import com.liferay.document.library.repository.cmis.internal.CMISRepository;
import com.liferay.document.library.repository.cmis.internal.model.BaseCMISModel;
import com.liferay.exportimport.kernel.lar.StagedModelType;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.RepositoryEntry;
import com.liferay.portal.kernel.model.User;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.RepositoryException;
import com.liferay.portal.kernel.repository.RepositoryProviderUtil;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryModelOperation;
import com.liferay.portal.kernel.security.auth.PrincipalThreadLocal;
import com.liferay.portal.kernel.security.permission.PermissionChecker;
import com.liferay.portal.kernel.service.RepositoryEntryLocalServiceUtil;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.MimeTypesUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.client.api.CmisObject;
import org.apache.chemistry.opencmis.client.api.Document;
import org.apache.chemistry.opencmis.commons.data.AllowableActions;
import org.apache.chemistry.opencmis.commons.data.CmisExtensionElement;
import org.apache.chemistry.opencmis.commons.data.ContentStream;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;

public class CMISFileEntry
extends BaseCMISModel
implements FileEntry {
    private static final Log _log = LogFactoryUtil.getLog(CMISFileEntry.class);
    private List<Document> _allVersions;
    private final CMISRepository _cmisRepository;
    private Document _document;
    private long _fileEntryId;
    private FileVersion _latestFileVersion;
    private final LockManager _lockManager;
    private final String _uuid;

    public CMISFileEntry(CMISRepository cmisRepository, String uuid, long fileEntryId, Document document, LockManager lockManager) {
        this._cmisRepository = cmisRepository;
        this._uuid = uuid;
        this._fileEntryId = fileEntryId;
        this._document = document;
        this._lockManager = lockManager;
    }

    public Object clone() {
        CMISFileEntry cmisFileEntry;
        block2: {
            cmisFileEntry = new CMISFileEntry(this._cmisRepository, this._uuid, this._fileEntryId, this._document, this._lockManager);
            cmisFileEntry.setCompanyId(this.getCompanyId());
            cmisFileEntry.setFileEntryId(this.getFileEntryId());
            cmisFileEntry.setGroupId(this.getGroupId());
            try {
                cmisFileEntry.setParentFolder(this.getParentFolder());
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block2;
                _log.debug((Throwable)exception);
            }
        }
        cmisFileEntry.setPrimaryKey(this.getPrimaryKey());
        return cmisFileEntry;
    }

    public boolean containsPermission(PermissionChecker permissionChecker, String actionId) {
        return this.containsPermission((CmisObject)this._document, actionId);
    }

    public boolean equals(Object object) {
        if (!(object instanceof CMISFileEntry)) {
            return false;
        }
        String versionSeriesId = this._document.getVersionSeriesId();
        CMISFileEntry fileEntry2 = (CMISFileEntry)object;
        return versionSeriesId.equals(fileEntry2._document.getVersionSeriesId());
    }

    public void execute(RepositoryModelOperation repositoryModelOperation) throws PortalException {
        repositoryModelOperation.execute((FileEntry)this);
    }

    public Map<String, Serializable> getAttributes() {
        return new HashMap<String, Serializable>();
    }

    @Override
    public long getCompanyId() {
        return this._cmisRepository.getCompanyId();
    }

    public InputStream getContentStream() {
        ContentStream contentStream = this._document.getContentStream();
        try {
            DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        if (contentStream == null) {
            return null;
        }
        return contentStream.getStream();
    }

    public InputStream getContentStream(String version) throws PortalException {
        if (Validator.isNull((String)version)) {
            return this.getContentStream();
        }
        for (Document document : this.getAllVersions()) {
            if (!version.equals(document.getVersionLabel())) continue;
            ContentStream contentStream = document.getContentStream();
            try {
                DLAppHelperLocalServiceUtil.getFileAsStream((long)PrincipalThreadLocal.getUserId(), (FileEntry)this, (boolean)true);
            }
            catch (Exception exception) {
                _log.error((Throwable)exception);
            }
            if (contentStream == null) {
                return null;
            }
            return contentStream.getStream();
        }
        throw new NoSuchFileVersionException(StringBundler.concat((Object[])new Object[]{"No CMIS file version with {fileEntryId=", this.getFileEntryId(), ", version=", version, "}"}));
    }

    public Date getCreateDate() {
        GregorianCalendar creationDate = this._document.getCreationDate();
        return creationDate.getTime();
    }

    public Date getExpirationDate() {
        return null;
    }

    public String getExtension() {
        return FileUtil.getExtension((String)this.getTitle());
    }

    public long getFileEntryId() {
        return this._fileEntryId;
    }

    public String getFileName() {
        return DLUtil.getSanitizedFileName((String)this.getTitle(), (String)this.getExtension());
    }

    public List<FileShortcut> getFileShortcuts() {
        return Collections.emptyList();
    }

    public FileVersion getFileVersion() throws PortalException {
        return this.getLatestFileVersion();
    }

    public FileVersion getFileVersion(String version) throws PortalException {
        if (Validator.isNull((String)version)) {
            return this.getFileVersion();
        }
        for (Document document : this.getAllVersions()) {
            if (!version.equals(document.getVersionLabel())) continue;
            return this._cmisRepository.toFileVersion(this, document);
        }
        throw new NoSuchFileVersionException(StringBundler.concat((Object[])new Object[]{"No CMIS file version with {fileEntryId=", this.getFileEntryId(), ", version=", version, "}"}));
    }

    public List<FileVersion> getFileVersions(int status) {
        try {
            List<Document> documents = this.getAllVersions();
            ArrayList<FileVersion> fileVersions = new ArrayList<FileVersion>(documents.size());
            for (Document document : documents) {
                FileVersion fileVersion = this._cmisRepository.toFileVersion(this, document);
                fileVersions.add(fileVersion);
            }
            return fileVersions;
        }
        catch (PortalException portalException) {
            throw new RepositoryException((Throwable)portalException);
        }
    }

    public List<FileVersion> getFileVersions(int status, int start, int end) {
        return this.getFileVersions(status);
    }

    public int getFileVersionsCount(int status) {
        try {
            List<Document> documents = this.getAllVersions();
            return documents.size();
        }
        catch (PortalException portalException) {
            throw new RepositoryException((Throwable)portalException);
        }
    }

    public Folder getFolder() {
        Folder parentFolder;
        block6: {
            parentFolder = null;
            try {
                parentFolder = super.getParentFolder();
                if (parentFolder != null) {
                    return parentFolder;
                }
            }
            catch (Exception exception) {
                if (!_log.isDebugEnabled()) break block6;
                _log.debug((Throwable)exception);
            }
        }
        try {
            List cmisParentFolders = this._document.getParents();
            if (cmisParentFolders.isEmpty()) {
                this._document = this._document.getObjectOfLatestVersion(false);
                cmisParentFolders = this._document.getParents();
            }
            parentFolder = this._cmisRepository.toFolder((org.apache.chemistry.opencmis.client.api.Folder)cmisParentFolders.get(0));
            this.setParentFolder(parentFolder);
        }
        catch (Exception exception) {
            _log.error((Throwable)exception);
        }
        return parentFolder;
    }

    public long getFolderId() {
        Folder folder = this.getFolder();
        return folder.getFolderId();
    }

    public long getGroupId() {
        return this._cmisRepository.getGroupId();
    }

    public String getIcon() {
        return DLUtil.getFileIcon((String)this.getExtension());
    }

    public String getIconCssClass() {
        return DLUtil.getFileIconCssClass((String)this.getExtension());
    }

    public Date getLastPublishDate() {
        return null;
    }

    public FileVersion getLatestFileVersion() throws PortalException {
        if (this._latestFileVersion != null) {
            return this._latestFileVersion;
        }
        List<Document> documents = this.getAllVersions();
        if (!documents.isEmpty()) {
            Document latestDocumentVersion = documents.get(0);
            this._latestFileVersion = this._cmisRepository.toFileVersion(this, latestDocumentVersion);
        } else {
            this._latestFileVersion = this._cmisRepository.toFileVersion(this, this._document);
        }
        return this._latestFileVersion;
    }

    public FileVersion getLatestFileVersion(boolean trusted) throws PortalException {
        return this.getLatestFileVersion();
    }

    public Lock getLock() {
        if (!this.isCheckedOut()) {
            return null;
        }
        String checkedOutBy = this._document.getVersionSeriesCheckedOutBy();
        User user = this.getUser(checkedOutBy);
        long userId = 0L;
        String userName = null;
        if (user != null) {
            userId = user.getUserId();
            userName = user.getFullName();
        }
        return this._lockManager.createLock(0L, this.getCompanyId(), userId, userName);
    }

    public String getMimeType() {
        String mimeType = this._document.getContentStreamMimeType();
        if (Validator.isNotNull((String)mimeType)) {
            return mimeType;
        }
        return MimeTypesUtil.getContentType((String)this.getTitle());
    }

    public String getMimeType(String version) {
        if (Validator.isNull((String)version)) {
            return this.getMimeType();
        }
        try {
            for (Document document : this.getAllVersions()) {
                if (!version.equals(document.getVersionLabel())) continue;
                String mimeType = document.getContentStreamMimeType();
                if (Validator.isNotNull((String)mimeType)) {
                    return mimeType;
                }
                return MimeTypesUtil.getContentType((String)document.getName());
            }
        }
        catch (PortalException portalException) {
            _log.error((Throwable)portalException);
        }
        return "application/octet-stream";
    }

    public Object getModel() {
        return this._document;
    }

    public Class<?> getModelClass() {
        return FileEntry.class;
    }

    @Override
    public String getModelClassName() {
        return FileEntry.class.getName();
    }

    public Date getModifiedDate() {
        GregorianCalendar lastModificationDate = this._document.getLastModificationDate();
        return lastModificationDate.getTime();
    }

    @Override
    public long getPrimaryKey() {
        return this._fileEntryId;
    }

    public Serializable getPrimaryKeyObj() {
        return Long.valueOf(this.getPrimaryKey());
    }

    public long getReadCount() {
        return 0L;
    }

    public <T extends Capability> T getRepositoryCapability(Class<T> capabilityClass) {
        try {
            Repository repository = RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
            return (T)repository.getCapability(capabilityClass);
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to access repository " + this.getRepositoryId(), (Throwable)portalException);
        }
    }

    public long getRepositoryId() {
        return this._cmisRepository.getRepositoryId();
    }

    public Date getReviewDate() {
        return null;
    }

    public long getSize() {
        return this._document.getContentStreamLength();
    }

    public StagedModelType getStagedModelType() {
        return new StagedModelType(DLFileEntryConstants.getClassName());
    }

    public String getTitle() {
        return this._document.getName();
    }

    public long getUserId() {
        User user = this.getUser(this._document.getCreatedBy());
        if (user == null) {
            return 0L;
        }
        return user.getUserId();
    }

    public String getUserName() {
        User user = this.getUser(this._document.getCreatedBy());
        if (user == null) {
            return "";
        }
        return user.getFullName();
    }

    public String getUserUuid() {
        User user = this.getUser(this._document.getCreatedBy());
        try {
            return user.getUserUuid();
        }
        catch (Exception exception) {
            if (_log.isDebugEnabled()) {
                _log.debug((Throwable)exception);
            }
            return "";
        }
    }

    public String getUuid() {
        return this._uuid;
    }

    public String getVersion() {
        return GetterUtil.getString((String)this._document.getVersionLabel(), null);
    }

    public int hashCode() {
        String versionSeriesId = this._document.getVersionSeriesId();
        return versionSeriesId.hashCode();
    }

    public boolean hasLock() {
        if (!this.isCheckedOut()) {
            return false;
        }
        AllowableActions allowableActions = this._document.getAllowableActions();
        Set allowableActionsSet = allowableActions.getAllowableActions();
        if (allowableActionsSet.contains(Action.CAN_CHECK_IN)) {
            return true;
        }
        List cmisExtensionElements = allowableActions.getExtensions();
        if (cmisExtensionElements == null) {
            return false;
        }
        for (CmisExtensionElement cmisExtensionElement : cmisExtensionElements) {
            String name = cmisExtensionElement.getName();
            if (name == null || !name.equals("canCheckInSpecified")) continue;
            return GetterUtil.getBoolean((String)cmisExtensionElement.getValue());
        }
        return false;
    }

    public boolean isCheckedOut() {
        return this._document.isVersionSeriesCheckedOut();
    }

    public boolean isDefaultRepository() {
        return false;
    }

    public boolean isEscapedModel() {
        return false;
    }

    public boolean isInTrash() {
        return false;
    }

    public boolean isInTrashContainer() {
        return false;
    }

    public boolean isManualCheckInRequired() {
        try {
            RepositoryEntry repositoryEntry = RepositoryEntryLocalServiceUtil.getRepositoryEntry((long)this._fileEntryId);
            return repositoryEntry.isManualCheckInRequired();
        }
        catch (Exception exception) {
            if (_log.isInfoEnabled()) {
                _log.info((Object)"Unable to retrieve repository entry", (Throwable)exception);
            }
            return false;
        }
    }

    public <T extends Capability> boolean isRepositoryCapabilityProvided(Class<T> capabilityClass) {
        Repository repository = this.getRepository();
        return repository.isCapabilityProvided(capabilityClass);
    }

    public boolean isSupportsLocking() {
        return true;
    }

    public boolean isSupportsMetadata() {
        return false;
    }

    public boolean isSupportsSocial() {
        return false;
    }

    public void setCompanyId(long companyId) {
        this._cmisRepository.setCompanyId(companyId);
    }

    public void setCreateDate(Date createDate) {
    }

    public void setFileEntryId(long fileEntryId) {
        this._fileEntryId = fileEntryId;
    }

    public void setGroupId(long groupId) {
        this._cmisRepository.setGroupId(groupId);
    }

    public void setLastPublishDate(Date lastPublishDate) {
    }

    public void setModifiedDate(Date modifiedDate) {
    }

    public void setPrimaryKey(long primaryKey) {
        this.setFileEntryId(primaryKey);
    }

    public void setPrimaryKeyObj(Serializable primaryKeyObj) {
        Long primaryKeyLong = (Long)primaryKeyObj;
        this.setPrimaryKey(primaryKeyLong);
    }

    public void setUserId(long userId) {
    }

    public void setUserName(String userName) {
    }

    public void setUserUuid(String userUuid) {
    }

    public void setUuid(String uuid) {
    }

    public FileEntry toEscapedModel() {
        return this;
    }

    public FileEntry toUnescapedModel() {
        return this;
    }

    protected List<Document> getAllVersions() throws PortalException {
        if (this._allVersions == null) {
            try {
                this._allVersions = this._document.getAllVersions();
            }
            catch (CmisObjectNotFoundException cmisObjectNotFoundException) {
                throw new NoSuchFileEntryException((Throwable)cmisObjectNotFoundException);
            }
        }
        return this._allVersions;
    }

    @Override
    protected CMISRepository getCmisRepository() {
        return this._cmisRepository;
    }

    protected Repository getRepository() {
        try {
            return RepositoryProviderUtil.getRepository((long)this.getRepositoryId());
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to get repository for file entry " + this.getFileEntryId(), (Throwable)portalException);
        }
    }
}

