/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.petra.concurrent.ConcurrentReferenceValueHashMap;
import com.liferay.petra.memory.FinalizeManager;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.servlet.PortalSessionThreadLocal;
import com.liferay.portal.kernel.util.TransientValue;
import java.util.Enumeration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.servlet.http.HttpSession;
import org.apache.chemistry.opencmis.client.api.Session;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;

@Component(service={CMISSessionCache.class})
public class CMISSessionCache {
    private static final Log _log = LogFactoryUtil.getLog(CMISSessionCache.class);
    private final ConcurrentMap<String, HttpSession> _sessions = new ConcurrentReferenceValueHashMap(new ConcurrentHashMap(), FinalizeManager.WEAK_REFERENCE_FACTORY);

    public Session get(String key) {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            return null;
        }
        TransientValue transientValue = (TransientValue)httpSession.getAttribute(key);
        if (transientValue == null) {
            return null;
        }
        Object value = transientValue.getValue();
        if (value instanceof Session) {
            return (Session)value;
        }
        httpSession.removeAttribute(key);
        return null;
    }

    public void put(String key, Session session) {
        HttpSession httpSession = PortalSessionThreadLocal.getHttpSession();
        if (httpSession == null) {
            if (_log.isWarnEnabled()) {
                _log.warn((Object)"Unable to get HTTP session");
            }
            return;
        }
        httpSession.setAttribute(key, (Object)new TransientValue((Object)session));
        this._sessions.putIfAbsent(httpSession.getId(), httpSession);
    }

    @Deactivate
    protected void deactivate() {
        for (Map.Entry entry : this._sessions.entrySet()) {
            this._clearSession((HttpSession)entry.getValue());
        }
        this._sessions.clear();
    }

    private void _clearSession(HttpSession httpSession) {
        Enumeration enumeration = httpSession.getAttributeNames();
        while (enumeration.hasMoreElements()) {
            String attributeName = (String)enumeration.nextElement();
            if (!attributeName.startsWith(Session.class.getName())) continue;
            httpSession.removeAttribute(attributeName);
            break;
        }
    }
}

