/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.asset.kernel.service.AssetEntryLocalService;
import com.liferay.document.library.kernel.service.DLAppHelperLocalService;
import com.liferay.document.library.kernel.service.DLFolderLocalService;
import com.liferay.document.library.repository.cmis.BaseCmisRepository;
import com.liferay.document.library.repository.cmis.CMISRepositoryHandler;
import com.liferay.document.library.repository.cmis.configuration.CMISRepositoryConfiguration;
import com.liferay.document.library.repository.cmis.internal.CMISRepository;
import com.liferay.document.library.repository.cmis.internal.CMISSessionCache;
import com.liferay.document.library.repository.cmis.internal.RepositoryProxyBean;
import com.liferay.document.library.repository.cmis.search.BaseCmisSearchQueryBuilder;
import com.liferay.document.library.repository.cmis.search.CMISSearchQueryBuilder;
import com.liferay.exportimport.kernel.lar.ExportImportThreadLocal;
import com.liferay.portal.kernel.bean.ClassLoaderBeanHandler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.LockManager;
import com.liferay.portal.kernel.model.Repository;
import com.liferay.portal.kernel.repository.BaseRepository;
import com.liferay.portal.kernel.repository.LocalRepository;
import com.liferay.portal.kernel.repository.RepositoryFactory;
import com.liferay.portal.kernel.service.CompanyLocalService;
import com.liferay.portal.kernel.service.RepositoryEntryLocalService;
import com.liferay.portal.kernel.service.RepositoryLocalService;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.ProxyUtil;
import java.lang.reflect.InvocationHandler;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseCMISRepositoryFactory<T extends CMISRepositoryHandler>
implements RepositoryFactory {
    @Reference
    protected AssetEntryLocalService assetEntryLocalService;
    @Reference
    protected CMISSessionCache cmisSessionCache;
    @Reference
    protected CompanyLocalService companyLocalService;
    @Reference
    protected DLAppHelperLocalService dlAppHelperLocalService;
    @Reference
    protected DLFolderLocalService dlFolderLocalService;
    @Reference
    protected LockManager lockManager;
    @Reference
    protected RepositoryEntryLocalService repositoryEntryLocalService;
    @Reference
    protected RepositoryLocalService repositoryLocalService;
    @Reference
    protected UserLocalService userLocalService;
    private CMISRepositoryConfiguration _cmisRepositoryConfiguration;
    private final CMISSearchQueryBuilder _cmisSearchQueryBuilder = new BaseCmisSearchQueryBuilder();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LocalRepository createLocalRepository(long repositoryId) throws PortalException {
        Thread currentThread = Thread.currentThread();
        ClassLoader contextClassLoader = currentThread.getContextClassLoader();
        currentThread.setContextClassLoader(BaseCMISRepositoryFactory.class.getClassLoader());
        try {
            BaseRepository baseRepository = this.createBaseRepository(repositoryId);
            LocalRepository localRepository = baseRepository.getLocalRepository();
            return localRepository;
        }
        finally {
            currentThread.setContextClassLoader(contextClassLoader);
        }
    }

    public com.liferay.portal.kernel.repository.Repository createRepository(long repositoryId) throws PortalException {
        return (com.liferay.portal.kernel.repository.Repository)ProxyUtil.newProxyInstance((ClassLoader)com.liferay.portal.kernel.repository.Repository.class.getClassLoader(), (Class[])new Class[]{com.liferay.portal.kernel.repository.Repository.class}, (InvocationHandler)new ClassLoaderBeanHandler((Object)new RepositoryProxyBean((com.liferay.portal.kernel.repository.Repository)this.createBaseRepository(repositoryId), BaseCMISRepositoryFactory.class.getClassLoader()), BaseCMISRepositoryFactory.class.getClassLoader()));
    }

    protected abstract T createBaseRepository();

    protected BaseRepository createBaseRepository(long repositoryId) throws PortalException {
        T baseRepository = this.createBaseRepository();
        Repository repository = this.repositoryLocalService.getRepository(repositoryId);
        CMISRepository cmisRepository = new CMISRepository(this._cmisRepositoryConfiguration, (CMISRepositoryHandler)baseRepository, this._cmisSearchQueryBuilder, this.cmisSessionCache, this.lockManager);
        baseRepository.setCmisRepository((BaseCmisRepository)cmisRepository);
        this._setupRepository(repositoryId, repository, (BaseRepository)cmisRepository);
        this._setupRepository(repositoryId, repository, (BaseRepository)baseRepository);
        if (!ExportImportThreadLocal.isImportInProcess()) {
            baseRepository.initRepository();
        }
        return baseRepository;
    }

    protected void setCMISRepositoryConfiguration(CMISRepositoryConfiguration cmisRepositoryConfiguration) {
        this._cmisRepositoryConfiguration = cmisRepositoryConfiguration;
    }

    private void _setupRepository(long repositoryId, Repository repository, BaseRepository baseRepository) {
        baseRepository.setAssetEntryLocalService(this.assetEntryLocalService);
        baseRepository.setCompanyId(repository.getCompanyId());
        baseRepository.setCompanyLocalService(this.companyLocalService);
        baseRepository.setDLAppHelperLocalService(this.dlAppHelperLocalService);
        baseRepository.setDLFolderLocalService(this.dlFolderLocalService);
        baseRepository.setGroupId(repository.getGroupId());
        baseRepository.setRepositoryEntryLocalService(this.repositoryEntryLocalService);
        baseRepository.setRepositoryId(repositoryId);
        baseRepository.setTypeSettingsProperties(repository.getTypeSettingsProperties());
        baseRepository.setUserLocalService(this.userLocalService);
    }
}

