/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.repository.cmis.internal;

import com.liferay.document.library.kernel.model.DLVersionNumberIncrease;
import com.liferay.document.library.repository.cmis.internal.ContextClassLoaderSetter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.lock.Lock;
import com.liferay.portal.kernel.repository.Repository;
import com.liferay.portal.kernel.repository.capabilities.Capability;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.repository.model.RepositoryEntry;
import com.liferay.portal.kernel.repository.proxy.FileEntryProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileShortcutProxyBean;
import com.liferay.portal.kernel.repository.proxy.FileVersionProxyBean;
import com.liferay.portal.kernel.repository.proxy.FolderProxyBean;
import com.liferay.portal.kernel.repository.proxy.RepositoryModelProxyBean;
import com.liferay.portal.kernel.search.Hits;
import com.liferay.portal.kernel.search.Query;
import com.liferay.portal.kernel.search.SearchContext;
import com.liferay.portal.kernel.search.SearchException;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.OrderByComparator;
import java.io.File;
import java.io.InputStream;
import java.util.List;

public class RepositoryProxyBean
extends RepositoryModelProxyBean
implements Repository {
    private final ClassLoader _classLoader;
    private final Repository _repository;

    public RepositoryProxyBean(Repository repository, ClassLoader classLoader) {
        super(classLoader);
        this._repository = repository;
        this._classLoader = classLoader;
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, File file, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, file, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry addFileEntry(long userId, long folderId, String sourceFileName, String mimeType, String title, String description, String changeLog, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.addFileEntry(userId, folderId, sourceFileName, mimeType, title, description, changeLog, is, size, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileShortcut addFileShortcut(long userId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileShortcut fileShortcut = this._repository.addFileShortcut(userId, folderId, toFileEntryId, serviceContext);
            FileShortcutProxyBean fileShortcutProxyBean = this.newFileShortcutProxyBean(fileShortcut);
            return fileShortcutProxyBean;
        }
    }

    public Folder addFolder(long userId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.addFolder(userId, parentFolderId, name, description, serviceContext);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public FileVersion cancelCheckOut(long fileEntryId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileVersion fileVersion = this._repository.cancelCheckOut(fileEntryId);
            FileVersionProxyBean fileVersionProxyBean = this.newFileVersionProxyBean(fileVersion);
            return fileVersionProxyBean;
        }
    }

    @Deprecated
    public void checkInFileEntry(long userId, long fileEntryId, boolean majorVersion, String changeLog, ServiceContext serviceContext) throws PortalException {
        this.checkInFileEntry(userId, fileEntryId, DLVersionNumberIncrease.fromMajorVersion((boolean)majorVersion), changeLog, serviceContext);
    }

    public void checkInFileEntry(long userId, long fileEntryId, DLVersionNumberIncrease dlVersionNumberIncrease, String changeLog, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.checkInFileEntry(userId, fileEntryId, dlVersionNumberIncrease, changeLog, serviceContext);
        }
    }

    public void checkInFileEntry(long userId, long fileEntryId, String lockUuid, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.checkInFileEntry(userId, fileEntryId, lockUuid, serviceContext);
        }
    }

    public FileEntry checkOutFileEntry(long fileEntryId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.checkOutFileEntry(fileEntryId, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry checkOutFileEntry(long fileEntryId, String owner, long expirationTime, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.checkOutFileEntry(fileEntryId, owner, expirationTime, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry copyFileEntry(long userId, long groupId, long fileEntryId, long destFolderId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.copyFileEntry(userId, groupId, fileEntryId, destFolderId, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public void deleteAll() throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteAll();
        }
    }

    public void deleteFileEntry(long fileEntryId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileEntry(fileEntryId);
        }
    }

    public void deleteFileEntry(long folderId, String title) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileEntry(folderId, title);
        }
    }

    public void deleteFileShortcut(long fileShortcutId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileShortcut(fileShortcutId);
        }
    }

    public void deleteFileShortcuts(long toFileEntryId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileShortcuts(toFileEntryId);
        }
    }

    public void deleteFileVersion(long fileVersionId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileVersion(fileVersionId);
        }
    }

    public void deleteFileVersion(long fileEntryId, String version) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFileVersion(fileEntryId, version);
        }
    }

    public void deleteFolder(long folderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFolder(folderId);
        }
    }

    public void deleteFolder(long parentFolderId, String name) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.deleteFolder(parentFolderId, name);
        }
    }

    public <T extends Capability> T getCapability(Class<T> capabilityClass) {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Capability capability = this._repository.getCapability(capabilityClass);
            return (T)capability;
        }
    }

    public List<FileEntry> getFileEntries(long folderId, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntries = this._repository.getFileEntries(folderId, status, start, end, obc);
            List list = this.toFileEntryProxyBeans(fileEntries);
            return list;
        }
    }

    public List<FileEntry> getFileEntries(long folderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntries = this._repository.getFileEntries(folderId, start, end, obc);
            List list = this.toFileEntryProxyBeans(fileEntries);
            return list;
        }
    }

    public List<FileEntry> getFileEntries(long folderId, long fileEntryTypeId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntries = this._repository.getFileEntries(folderId, fileEntryTypeId, start, end, obc);
            List list = this.toFileEntryProxyBeans(fileEntries);
            return list;
        }
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntries = this._repository.getFileEntries(folderId, mimeTypes, status, start, end, obc);
            List list = this.toFileEntryProxyBeans(fileEntries);
            return list;
        }
    }

    public List<FileEntry> getFileEntries(long folderId, String[] mimeTypes, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntries = this._repository.getFileEntries(folderId, mimeTypes, start, end, obc);
            List list = this.toFileEntryProxyBeans(fileEntries);
            return list;
        }
    }

    public List<RepositoryEntry> getFileEntriesAndFileShortcuts(long folderId, int status, int start, int end) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List fileEntriesAndFileShortcuts = this._repository.getFileEntriesAndFileShortcuts(folderId, status, start, end);
            List list = this.toObjectProxyBeans(fileEntriesAndFileShortcuts);
            return list;
        }
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesAndFileShortcutsCount(folderId, status);
            return n;
        }
    }

    public int getFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimeTypes) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesAndFileShortcutsCount(folderId, status, mimeTypes);
            return n;
        }
    }

    public int getFileEntriesCount(long folderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesCount(folderId);
            return n;
        }
    }

    public int getFileEntriesCount(long folderId, int status) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesCount(folderId, status);
            return n;
        }
    }

    public int getFileEntriesCount(long folderId, long fileEntryTypeId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesCount(folderId, fileEntryTypeId);
            return n;
        }
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesCount(folderId, mimeTypes);
            return n;
        }
    }

    public int getFileEntriesCount(long folderId, String[] mimeTypes, int status) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFileEntriesCount(folderId, mimeTypes, status);
            return n;
        }
    }

    public FileEntry getFileEntry(long fileEntryId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.getFileEntry(fileEntryId);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry getFileEntry(long folderId, String title) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.getFileEntry(folderId, title);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry getFileEntryByUuid(String uuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntryByUuid = this._repository.getFileEntryByUuid(uuid);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntryByUuid);
            return fileEntryProxyBean;
        }
    }

    public FileShortcut getFileShortcut(long fileShortcutId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileShortcut fileShortcut = this._repository.getFileShortcut(fileShortcutId);
            FileShortcutProxyBean fileShortcutProxyBean = this.newFileShortcutProxyBean(fileShortcut);
            return fileShortcutProxyBean;
        }
    }

    public FileVersion getFileVersion(long fileVersionId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileVersion fileVersion = this._repository.getFileVersion(fileVersionId);
            FileVersionProxyBean fileVersionProxyBean = this.newFileVersionProxyBean(fileVersion);
            return fileVersionProxyBean;
        }
    }

    public Folder getFolder(long folderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.getFolder(folderId);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public Folder getFolder(long parentFolderId, String name) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.getFolder(parentFolderId, name);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public List<Folder> getFolders(long parentFolderId, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List folders = this._repository.getFolders(parentFolderId, includeMountFolders, start, end, obc);
            List list = this.toFolderProxyBeans(folders);
            return list;
        }
    }

    public List<Folder> getFolders(long parentFolderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List folders = this._repository.getFolders(parentFolderId, status, includeMountFolders, start, end, obc);
            List list = this.toFolderProxyBeans(folders);
            return list;
        }
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List foldersAndFileEntriesAndFileShortcuts = this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, includeMountFolders, start, end, obc);
            List list = this.toObjectProxyBeans(foldersAndFileEntriesAndFileShortcuts);
            return list;
        }
    }

    public List<RepositoryEntry> getFoldersAndFileEntriesAndFileShortcuts(long folderId, int status, String[] mimetypes, boolean includeMountFolders, int start, int end, OrderByComparator<?> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List foldersAndFileEntriesAndFileShortcuts = this._repository.getFoldersAndFileEntriesAndFileShortcuts(folderId, status, mimetypes, includeMountFolders, start, end, obc);
            List list = this.toObjectProxyBeans(foldersAndFileEntriesAndFileShortcuts);
            return list;
        }
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, boolean includeMountFolders) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, includeMountFolders);
            return n;
        }
    }

    public int getFoldersAndFileEntriesAndFileShortcutsCount(long folderId, int status, String[] mimetypes, boolean includeMountFolders) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFoldersAndFileEntriesAndFileShortcutsCount(folderId, status, mimetypes, includeMountFolders);
            return n;
        }
    }

    public int getFoldersCount(long parentFolderId, boolean includeMountfolders) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFoldersCount(parentFolderId, includeMountfolders);
            return n;
        }
    }

    public int getFoldersCount(long parentFolderId, int status, boolean includeMountfolders) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFoldersCount(parentFolderId, status, includeMountfolders);
            return n;
        }
    }

    public int getFoldersFileEntriesCount(List<Long> folderIds, int status) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getFoldersFileEntriesCount(folderIds, status);
            return n;
        }
    }

    public List<Folder> getMountFolders(long parentFolderId, int start, int end, OrderByComparator<Folder> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List mountFolders = this._repository.getMountFolders(parentFolderId, start, end, obc);
            List list = this.toFolderProxyBeans(mountFolders);
            return list;
        }
    }

    public int getMountFoldersCount(long parentFolderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getMountFoldersCount(parentFolderId);
            return n;
        }
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List repositoryFileEntries = this._repository.getRepositoryFileEntries(userId, rootFolderId, start, end, obc);
            List list = this.toFileEntryProxyBeans(repositoryFileEntries);
            return list;
        }
    }

    public List<FileEntry> getRepositoryFileEntries(long userId, long rootFolderId, String[] mimeTypes, int status, int start, int end, OrderByComparator<FileEntry> obc) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List repositoryFileEntries = this._repository.getRepositoryFileEntries(userId, rootFolderId, mimeTypes, status, start, end, obc);
            List list = this.toFileEntryProxyBeans(repositoryFileEntries);
            return list;
        }
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getRepositoryFileEntriesCount(userId, rootFolderId);
            return n;
        }
    }

    public int getRepositoryFileEntriesCount(long userId, long rootFolderId, String[] mimeTypes, int status) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            int n = this._repository.getRepositoryFileEntriesCount(userId, rootFolderId, mimeTypes, status);
            return n;
        }
    }

    public long getRepositoryId() {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            long l = this._repository.getRepositoryId();
            return l;
        }
    }

    public void getSubfolderIds(List<Long> folderIds, long folderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.getSubfolderIds(folderIds, folderId);
        }
    }

    public List<Long> getSubfolderIds(long folderId, boolean recurse) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            List list = this._repository.getSubfolderIds(folderId, recurse);
            return list;
        }
    }

    public <T extends Capability> boolean isCapabilityProvided(Class<T> capabilityClass) {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            boolean bl = this._repository.isCapabilityProvided(capabilityClass);
            return bl;
        }
    }

    public Lock lockFolder(long folderId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Lock lock = this._repository.lockFolder(folderId);
            return lock;
        }
    }

    public Lock lockFolder(long folderId, String owner, boolean inheritable, long expirationTime) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Lock lock = this._repository.lockFolder(folderId, owner, inheritable, expirationTime);
            return lock;
        }
    }

    public FileEntry moveFileEntry(long userId, long fileEntryId, long newFolderId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.moveFileEntry(userId, fileEntryId, newFolderId, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public Folder moveFolder(long userId, long folderId, long parentFolderId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.moveFolder(userId, folderId, parentFolderId, serviceContext);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public Lock refreshFileEntryLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Lock lock = this._repository.refreshFileEntryLock(lockUuid, companyId, expirationTime);
            return lock;
        }
    }

    public Lock refreshFolderLock(String lockUuid, long companyId, long expirationTime) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Lock lock = this._repository.refreshFolderLock(lockUuid, companyId, expirationTime);
            return lock;
        }
    }

    public void revertFileEntry(long userId, long fileEntryId, String version, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.revertFileEntry(userId, fileEntryId, version, serviceContext);
        }
    }

    public Hits search(long creatorUserId, int status, int start, int end) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Hits hits = this._repository.search(creatorUserId, status, start, end);
            return hits;
        }
    }

    public Hits search(long creatorUserId, long folderId, String[] mimeTypes, int status, int start, int end) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Hits hits = this._repository.search(creatorUserId, folderId, mimeTypes, status, start, end);
            return hits;
        }
    }

    public Hits search(SearchContext searchContext) throws SearchException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Hits hits = this._repository.search(searchContext);
            return hits;
        }
    }

    public Hits search(SearchContext searchContext, Query query) throws SearchException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Hits hits = this._repository.search(searchContext, query);
            return hits;
        }
    }

    public void unlockFolder(long folderId, String lockUuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.unlockFolder(folderId, lockUuid);
        }
    }

    public void unlockFolder(long parentFolderId, String name, String lockUuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.unlockFolder(parentFolderId, name, lockUuid);
        }
    }

    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, File file, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion((boolean)majorVersion), file, serviceContext);
    }

    @Deprecated
    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, boolean majorVersion, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        return this.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, DLVersionNumberIncrease.fromMajorVersion((boolean)majorVersion), is, size, serviceContext);
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, File file, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, file, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileEntry updateFileEntry(long userId, long fileEntryId, String sourceFileName, String mimeType, String title, String description, String changeLog, DLVersionNumberIncrease dlVersionNumberIncrease, InputStream is, long size, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileEntry fileEntry = this._repository.updateFileEntry(userId, fileEntryId, sourceFileName, mimeType, title, description, changeLog, dlVersionNumberIncrease, is, size, serviceContext);
            FileEntryProxyBean fileEntryProxyBean = this.newFileEntryProxyBean(fileEntry);
            return fileEntryProxyBean;
        }
    }

    public FileShortcut updateFileShortcut(long userId, long fileShortcutId, long folderId, long toFileEntryId, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            FileShortcut fileShortcut = this._repository.updateFileShortcut(userId, fileShortcutId, folderId, toFileEntryId, serviceContext);
            FileShortcutProxyBean fileShortcutProxyBean = this.newFileShortcutProxyBean(fileShortcut);
            return fileShortcutProxyBean;
        }
    }

    public void updateFileShortcuts(long oldToFileEntryId, long newToFileEntryId) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            this._repository.updateFileShortcuts(oldToFileEntryId, newToFileEntryId);
        }
    }

    public Folder updateFolder(long folderId, long parentFolderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.updateFolder(folderId, parentFolderId, name, description, serviceContext);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public Folder updateFolder(long folderId, String name, String description, ServiceContext serviceContext) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            Folder folder = this._repository.updateFolder(folderId, name, description, serviceContext);
            FolderProxyBean folderProxyBean = this.newFolderProxyBean(folder);
            return folderProxyBean;
        }
    }

    public boolean verifyFileEntryCheckOut(long fileEntryId, String lockUuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            boolean bl = this._repository.verifyFileEntryCheckOut(fileEntryId, lockUuid);
            return bl;
        }
    }

    public boolean verifyFileEntryLock(long fileEntryId, String lockUuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            boolean bl = this._repository.verifyFileEntryLock(fileEntryId, lockUuid);
            return bl;
        }
    }

    public boolean verifyInheritableLock(long folderId, String lockUuid) throws PortalException {
        try (ContextClassLoaderSetter contextClassLoaderSetter = new ContextClassLoaderSetter(this._classLoader);){
            boolean bl = this._repository.verifyInheritableLock(folderId, lockUuid);
            return bl;
        }
    }
}

