Liferay.Loader.define("document-library-preview-image@2.0.16/preview/js/ImagePreviewer.es", ['module', 'exports', 'require', '@frontend-taglib-clay$clayui/button', '@frontend-taglib-clay$clayui/icon', 'frontend-js-react-web', 'frontend-js-web', 'frontend-js-react-web$prop-types', 'frontend-js-react-web$react'], function (module, exports, require) {
  var define = undefined;
  function _typeof(obj) {
    "@babel/helpers - typeof";
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports["default"] = void 0;

  var _button = _interopRequireDefault(require("@frontend-taglib-clay$clayui/button"));

  var _icon = _interopRequireDefault(require("@frontend-taglib-clay$clayui/icon"));

  var _frontendJsReactWeb = require("frontend-js-react-web");

  var _frontendJsWeb = require("frontend-js-web");

  var _propTypes = _interopRequireDefault(require("frontend-js-react-web$prop-types"));

  var _react = _interopRequireWildcard(require("frontend-js-react-web$react"));

  function _getRequireWildcardCache() {
    if (typeof WeakMap !== "function") return null;var cache = new WeakMap();_getRequireWildcardCache = function _getRequireWildcardCache() {
      return cache;
    };return cache;
  }

  function _interopRequireWildcard(obj) {
    if (obj && obj.__esModule) {
      return obj;
    }if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") {
      return { "default": obj };
    }var cache = _getRequireWildcardCache();if (cache && cache.has(obj)) {
      return cache.get(obj);
    }var newObj = {};var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor;for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null;if (desc && (desc.get || desc.set)) {
          Object.defineProperty(newObj, key, desc);
        } else {
          newObj[key] = obj[key];
        }
      }
    }newObj["default"] = obj;if (cache) {
      cache.set(obj, newObj);
    }return newObj;
  }

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { "default": obj };
  }

  function _slicedToArray(arr, i) {
    return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _nonIterableRest();
  }

  function _nonIterableRest() {
    throw new TypeError("Invalid attempt to destructure non-iterable instance");
  }

  function _iterableToArrayLimit(arr, i) {
    if (!(Symbol.iterator in Object(arr) || Object.prototype.toString.call(arr) === "[object Arguments]")) {
      return;
    }var _arr = [];var _n = true;var _d = false;var _e = undefined;try {
      for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) {
        _arr.push(_s.value);if (i && _arr.length === i) break;
      }
    } catch (err) {
      _d = true;_e = err;
    } finally {
      try {
        if (!_n && _i["return"] != null) _i["return"]();
      } finally {
        if (_d) throw _e;
      }
    }return _arr;
  }

  function _arrayWithHoles(arr) {
    if (Array.isArray(arr)) return arr;
  }

  /**
   * Zoom ratio limit that fire the autocenter
   * @type {number}
   */
  var MIN_ZOOM_RATIO_AUTOCENTER = 3;
  /**
   * Available zoom sizes
   * @type {Array<number>}
   */

  var ZOOM_LEVELS = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1];
  /**
   * Available reversed zoom sizes
   * @type {Array<number>}
   */

  var ZOOM_LEVELS_REVERSED = ZOOM_LEVELS.slice().reverse();
  /**
   * Component that create an image preview to allow zoom
   * @review
   */

  var ImagePreviewer = function ImagePreviewer(_ref) {
    var alt = _ref.alt,
        imageURL = _ref.imageURL;

    var _useState = (0, _react.useState)(1),
        _useState2 = _slicedToArray(_useState, 2),
        currentZoom = _useState2[0],
        setCurrentZoom = _useState2[1];

    var _useState3 = (0, _react.useState)(null),
        _useState4 = _slicedToArray(_useState3, 2),
        imageHeight = _useState4[0],
        setImageHeight = _useState4[1];

    var _useState5 = (0, _react.useState)(null),
        _useState6 = _slicedToArray(_useState5, 2),
        imageWidth = _useState6[0],
        setImageWidth = _useState6[1];

    var _useState7 = (0, _react.useState)(null),
        _useState8 = _slicedToArray(_useState7, 2),
        imageMargin = _useState8[0],
        setImageMargin = _useState8[1];

    var _useState9 = (0, _react.useState)(true),
        _useState10 = _slicedToArray(_useState9, 2),
        zoomInDisabled = _useState10[0],
        setZoomInDisabled = _useState10[1];

    var _useState11 = (0, _react.useState)(false),
        _useState12 = _slicedToArray(_useState11, 2),
        zoomOutDisabled = _useState12[0],
        setZoomOutDisabled = _useState12[1];

    var _useState13 = (0, _react.useState)(false),
        _useState14 = _slicedToArray(_useState13, 2),
        zoomRatio = _useState14[0],
        setZoomRatio = _useState14[1];

    var image = (0, _react.useRef)();
    var imageContainer = (0, _react.useRef)();
    var isMounted = (0, _frontendJsReactWeb.useIsMounted)();

    var applyZoom = function applyZoom(zoom) {
      var imageElement = image.current;
      setImageHeight(imageElement.naturalHeight * zoom);
      setImageWidth(imageElement.naturalWidth * zoom);
      setZoomRatio(zoom / currentZoom);
      updateToolbar(zoom);
    };

    var getFittingZoom = function getFittingZoom() {
      var imageElement = image.current;
      return imageElement.width / imageElement.naturalWidth;
    };

    var handleWindowResize = (0, _frontendJsWeb.debounce)(function () {
      if (isMounted() && !image.current.style.width) {
        updateToolbar(getFittingZoom());
      }
    }, 250);

    var updateToolbar = function updateToolbar(zoom) {
      setCurrentZoom(zoom);
      setZoomInDisabled(ZOOM_LEVELS_REVERSED[0] === zoom);
      setZoomOutDisabled(ZOOM_LEVELS[0] >= zoom);
    };

    (0, _frontendJsReactWeb.useEventListener)('resize', handleWindowResize, false, window);
    (0, _react.useLayoutEffect)(function () {
      var imageContainerElement = imageContainer.current;
      setImageMargin("".concat(imageHeight > imageContainerElement.clientHeight ? 0 : 'auto', " ").concat(imageWidth > imageContainerElement.clientWidth ? 0 : 'auto'));

      if (zoomRatio && (imageContainerElement.clientWidth < image.current.naturalWidth || imageContainerElement.clientHeight < image.current.naturalHeight)) {
        var scrollLeft;
        var scrollTop;

        if (zoomRatio < MIN_ZOOM_RATIO_AUTOCENTER) {
          scrollLeft = imageContainerElement.clientWidth * (zoomRatio - 1) / 2 + imageContainerElement.scrollLeft * zoomRatio;
          scrollTop = imageContainerElement.clientHeight * (zoomRatio - 1) / 2 + imageContainerElement.scrollTop * zoomRatio;
        } else {
          scrollTop = (imageHeight - imageContainerElement.clientHeight) / 2;
          scrollLeft = (imageWidth - imageContainerElement.clientWidth) / 2;
        }

        imageContainerElement.scrollLeft = scrollLeft;
        imageContainerElement.scrollTop = scrollTop;
        setZoomRatio(null);
      }

      if (!image.current.style.width) {
        updateToolbar(getFittingZoom());
      }
    }, [imageHeight, imageWidth, zoomRatio, imageMargin]);
    return _react["default"].createElement("div", {
      className: "preview-file"
    }, _react["default"].createElement("div", {
      className: "preview-file-container preview-file-max-height",
      ref: imageContainer
    }, _react["default"].createElement("img", {
      alt: alt,
      className: "preview-file-image",
      onLoad: function handleImageLoad() {
        updateToolbar(getFittingZoom());
      },
      ref: image,
      src: imageURL,
      style: function getImageStyles() {
        var imageStyles = {};

        if (imageHeight && imageWidth) {
          imageStyles.height = imageHeight;
          imageStyles.maxHeight = imageHeight;
          imageStyles.maxWidth = imageWidth;
          imageStyles.width = imageWidth;
        }

        if (imageMargin) {
          imageStyles.margin = imageMargin;
        }

        return imageStyles;
      }()
    })), _react["default"].createElement("div", {
      className: "preview-toolbar-container"
    }, _react["default"].createElement(_button["default"].Group, {
      className: "floating-bar"
    }, _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar",
      disabled: zoomOutDisabled,
      displayType: null,
      monospaced: true,
      onClick: function onClick() {
        applyZoom(ZOOM_LEVELS_REVERSED.find(function (zoom) {
          return zoom < currentZoom;
        }));
      },
      title: Liferay.Language.get('zoom-out')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "hr"
    })), _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar btn-floating-bar-text",
      displayType: null,
      onClick: function handlePercentButtonClick() {
        if (currentZoom === 1) {
          setImageHeight(null);
          setImageWidth(null);
        } else {
          applyZoom(1);
        }
      },
      title: currentZoom === 1 ? Liferay.Language.get('zoom-to-fit') : Liferay.Language.get('real-size')
    }, _react["default"].createElement("span", {
      className: "preview-toolbar-label-percent"
    }, Math.round((currentZoom || 0) * 100), "%")), _react["default"].createElement(_button["default"], {
      className: "btn-floating-bar",
      disabled: zoomInDisabled,
      displayType: null,
      monospaced: true,
      onClick: function onClick() {
        applyZoom(ZOOM_LEVELS.find(function (zoom) {
          return zoom > currentZoom;
        }));
      },
      title: Liferay.Language.get('zoom-in')
    }, _react["default"].createElement(_icon["default"], {
      symbol: "plus"
    })))));
  };

  var _default = ImagePreviewer;
  exports["default"] = _default;
  //# sourceMappingURL=ImagePreviewer.es.js.map
});
//# sourceMappingURL=ImagePreviewer.es.js.map