Liferay.Loader.define('document-library-preview-image$lodash-es@4.17.15/words', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import asciiWords from './_asciiWords.js';
  import hasUnicodeWord from './_hasUnicodeWord.js';
  import toString from './toString.js';
  import unicodeWords from './_unicodeWords.js';

  /**
   * Splits `string` into an array of its words.
   *
   * @static
   * @memberOf _
   * @since 3.0.0
   * @category String
   * @param {string} [string=''] The string to inspect.
   * @param {RegExp|string} [pattern] The pattern to match words.
   * @param- {Object} [guard] Enables use as an iteratee for methods like `_.map`.
   * @returns {Array} Returns the words of `string`.
   * @example
   *
   * _.words('fred, barney, & pebbles');
   * // => ['fred', 'barney', 'pebbles']
   *
   * _.words('fred, barney, & pebbles', /[^, ]+/g);
   * // => ['fred', 'barney', '&', 'pebbles']
   */
  function words(string, pattern, guard) {
    string = toString(string);
    pattern = guard ? undefined : pattern;

    if (pattern === undefined) {
      return hasUnicodeWord(string) ? unicodeWords(string) : asciiWords(string);
    }
    return string.match(pattern) || [];
  }

  export default words;
});
//# sourceMappingURL=words.js.map