Liferay.Loader.define('document-library-preview-image$lodash-es@4.17.15/without', ['module', 'exports', 'require'], function (module, exports, require) {
  var define = undefined;
  import baseDifference from './_baseDifference.js';
  import baseRest from './_baseRest.js';
  import isArrayLikeObject from './isArrayLikeObject.js';

  /**
   * Creates an array excluding all given values using
   * [`SameValueZero`](http://ecma-international.org/ecma-262/7.0/#sec-samevaluezero)
   * for equality comparisons.
   *
   * **Note:** Unlike `_.pull`, this method returns a new array.
   *
   * @static
   * @memberOf _
   * @since 0.1.0
   * @category Array
   * @param {Array} array The array to inspect.
   * @param {...*} [values] The values to exclude.
   * @returns {Array} Returns the new array of filtered values.
   * @see _.difference, _.xor
   * @example
   *
   * _.without([2, 1, 2, 3], 1, 2);
   * // => [3]
   */
  var without = baseRest(function (array, values) {
    return isArrayLikeObject(array) ? baseDifference(array, values) : [];
  });

  export default without;
});
//# sourceMappingURL=without.js.map