"use strict";

Liferay.Loader.define("document-library-preview-image@1.0.7/preview/js/ImagePreviewer.es", ['module', 'exports', 'require', 'frontend-js-metal-web$metal-state', 'frontend-js-metal-web$metal-debounce', 'frontend-js-metal-web$metal-component', 'frontend-js-metal-web$metal-soy', './ImagePreviewer.soy'], function (module, exports, require) {
  var define = undefined;
  Object.defineProperty(exports, "__esModule", {
    value: true
  });
  exports.default = exports.ImagePreviewer = void 0;

  var _metalState = require("frontend-js-metal-web$metal-state");

  var _metalDebounce = require("frontend-js-metal-web$metal-debounce");

  var _metalComponent = _interopRequireDefault(require("frontend-js-metal-web$metal-component"));

  var _metalSoy = _interopRequireDefault(require("frontend-js-metal-web$metal-soy"));

  var _ImagePreviewer = _interopRequireDefault(require("./ImagePreviewer.soy"));

  function _interopRequireDefault(obj) {
    return obj && obj.__esModule ? obj : { default: obj };
  }

  function _typeof(obj) {
    if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
      _typeof = function _typeof(obj) {
        return typeof obj;
      };
    } else {
      _typeof = function _typeof(obj) {
        return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
      };
    }return _typeof(obj);
  }

  function _classCallCheck(instance, Constructor) {
    if (!(instance instanceof Constructor)) {
      throw new TypeError("Cannot call a class as a function");
    }
  }

  function _defineProperties(target, props) {
    for (var i = 0; i < props.length; i++) {
      var descriptor = props[i];descriptor.enumerable = descriptor.enumerable || false;descriptor.configurable = true;if ("value" in descriptor) descriptor.writable = true;Object.defineProperty(target, descriptor.key, descriptor);
    }
  }

  function _createClass(Constructor, protoProps, staticProps) {
    if (protoProps) _defineProperties(Constructor.prototype, protoProps);if (staticProps) _defineProperties(Constructor, staticProps);return Constructor;
  }

  function _possibleConstructorReturn(self, call) {
    if (call && (_typeof(call) === "object" || typeof call === "function")) {
      return call;
    }return _assertThisInitialized(self);
  }

  function _assertThisInitialized(self) {
    if (self === void 0) {
      throw new ReferenceError("this hasn't been initialised - super() hasn't been called");
    }return self;
  }

  function _getPrototypeOf(o) {
    _getPrototypeOf = Object.setPrototypeOf ? Object.getPrototypeOf : function _getPrototypeOf(o) {
      return o.__proto__ || Object.getPrototypeOf(o);
    };return _getPrototypeOf(o);
  }

  function _inherits(subClass, superClass) {
    if (typeof superClass !== "function" && superClass !== null) {
      throw new TypeError("Super expression must either be null or a function");
    }subClass.prototype = Object.create(superClass && superClass.prototype, { constructor: { value: subClass, writable: true, configurable: true } });if (superClass) _setPrototypeOf(subClass, superClass);
  }

  function _setPrototypeOf(o, p) {
    _setPrototypeOf = Object.setPrototypeOf || function _setPrototypeOf(o, p) {
      o.__proto__ = p;return o;
    };return _setPrototypeOf(o, p);
  }

  /**
   * Zoom ratio limit that fire the autocenter
   * @type {number}
   */
  var MIN_ZOOM_RATIO_AUTOCENTER = 3;
  /**
   * Available zoom sizes
   * @type {Array<number>}
   */

  var ZOOM_LEVELS = [0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1];
  /**
   * Available reversed zoom sizes
   * @type {Array<number>}
   */

  var ZOOM_LEVELS_REVERSED = ZOOM_LEVELS.slice().reverse();
  /**
   * Component that create an image preview to allow zoom
   * @review
   */

  var ImagePreviewer =
  /*#__PURE__*/
  function (_Component) {
    _inherits(ImagePreviewer, _Component);

    function ImagePreviewer() {
      _classCallCheck(this, ImagePreviewer);

      return _possibleConstructorReturn(this, _getPrototypeOf(ImagePreviewer).apply(this, arguments));
    }

    _createClass(ImagePreviewer, [{
      key: "attached",

      /**
       * @inheritDoc
       */
      value: function attached() {
        this._imageNaturalHeight = this.refs.image.naturalHeight;
        this._imageNaturalWidth = this.refs.image.naturalWidth;
        this._isPreviewFit = true;

        this._updateDimensions();

        this._updateDimensionsDebounced = (0, _metalDebounce.debounce)(this._updateDimensions.bind(this), 250);
        window.addEventListener('resize', this._updateDimensionsDebounced);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "detached",
      value: function detached() {
        window.removeEventListener('resize', this._updateDimensionsDebounced);
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "rendered",
      value: function rendered() {
        if (this._zoomRatio) {
          this._setScrollContainer();
        }

        if (this._reCalculateCurrentZoom) {
          this._reCalculateCurrentZoom = false;

          this._calculateCurrentZoom();
        }
      }
      /**
       * @inheritDoc
       */

    }, {
      key: "syncCurrentZoom",
      value: function syncCurrentZoom() {
        this.zoomInDisabled = ZOOM_LEVELS_REVERSED[0] === this.currentZoom;
        this.zoomOutDisabled = ZOOM_LEVELS[0] >= this.currentZoom;
      }
      /**
       * Set the zoom based in multiplier
       * @param {number} zoomNumber
       * @private
       * @review
       */

    }, {
      key: "_applyZoom",
      value: function _applyZoom(zoomNumber) {
        this.imageHeight = this._imageNaturalHeight * zoomNumber;
        this.imageWidth = this._imageNaturalWidth * zoomNumber;
        this._zoomRatio = zoomNumber / this.currentZoom;
        this._isPreviewFit = false;
        this.currentZoom = zoomNumber;

        this._updateDimensions();
      }
      /**
       * Calculate actual zoom based in image rendered
       * @private
       * @review
       */

    }, {
      key: "_calculateCurrentZoom",
      value: function _calculateCurrentZoom() {
        this.currentZoom = this.refs.image.width / this._imageNaturalWidth;
      }
      /**
       * Clear zoom and allow the image fit the container in natural way
       * @private
       * @review
       */

    }, {
      key: "_clearZoom",
      value: function _clearZoom() {
        this.imageHeight = null;
        this.imageMargin = null;
        this.imageWidth = null;
        this._isPreviewFit = true;
        this._reCalculateCurrentZoom = true;
      }
      /**
       * Event handler executed when zoom changed
       * @param {!Event} event
       * @private
       * @review
       */

    }, {
      key: "_handleToolbarClick",
      value: function _handleToolbarClick(event) {
        var _this = this;

        var value = event.currentTarget.value;
        var zoomValue;

        if (value === 'in') {
          zoomValue = ZOOM_LEVELS.find(function (zoom) {
            return zoom > _this.currentZoom;
          });
        } else if (value === 'out') {
          zoomValue = ZOOM_LEVELS_REVERSED.find(function (zoom) {
            return zoom < _this.currentZoom;
          });
        } else if (value === 'real') {
          zoomValue = 1;
        } else if (value === 'fit') {
          this._clearZoom();
        }

        if (zoomValue) {
          this._applyZoom(zoomValue);
        }
      }
      /**
       * Move the scroll of the cointainer based in the actual position or center
       * @private
       * @review
       */

    }, {
      key: "_setScrollContainer",
      value: function _setScrollContainer() {
        var imageContainer = this.refs.imageContainer;
        var scrollLeft;
        var scrollTop;

        if (this._zoomRatio < MIN_ZOOM_RATIO_AUTOCENTER) {
          scrollLeft = imageContainer.clientWidth * (this._zoomRatio - 1) / 2 + imageContainer.scrollLeft * this._zoomRatio;
          scrollTop = imageContainer.clientHeight * (this._zoomRatio - 1) / 2 + imageContainer.scrollTop * this._zoomRatio;
        } else {
          scrollTop = (this.imageHeight - imageContainer.clientHeight) / 2;
          scrollLeft = (this.imageWidth - imageContainer.clientWidth) / 2;
        }

        imageContainer.scrollLeft = scrollLeft;
        imageContainer.scrollTop = scrollTop;
        this._zoomRatio = null;
      }
      /**
       * Calculate actual dimensions based in container rendered
       * @private
       * @review
       */

    }, {
      key: "_updateDimensions",
      value: function _updateDimensions() {
        this.imageMargin = "".concat(this.imageHeight > this.refs.imageContainer.clientHeight ? 0 : 'auto', " ").concat(this.imageWidth > this.refs.imageContainer.clientWidth ? 0 : 'auto');

        if (this._isPreviewFit) {
          this._calculateCurrentZoom();
        }
      }
    }]);

    return ImagePreviewer;
  }(_metalComponent.default);
  /**
   * State definition.
   * @review
   * @static
   * @type {!Object}
   */

  exports.ImagePreviewer = ImagePreviewer;
  ImagePreviewer.STATE = {
    /**
     * The current zoom value that is shown in the toolbar.
     * @type {Number}
     */
    currentZoom: _metalState.Config.number(),

    /**
     * The height of the <img> element.
     * @type {Number}
     */
    imageHeight: _metalState.Config.number(),

    /**
     * The margin of the <img> element
     * @type {String}
     */
    imageMargin: _metalState.Config.string(),

    /**
     * The "src" attribute of the <img> element
     * @type {String}
     */
    imageURL: _metalState.Config.string().required(),

    /**
     * The width of the <img> element.
     * @type {Number}
     */
    imageWidth: _metalState.Config.number(),

    /**
     * Path to icon images.
     * @type {String}
     */
    spritemap: _metalState.Config.string().required(),

    /**
     * Flag that indicate if 'zoom in' is disabled.
     * @type {Boolean}
     */
    zoomInDisabled: _metalState.Config.bool(),

    /**
     * Flag that indicate if 'zoom out' is disabled.
     * @type {Boolean}
     */
    zoomOutDisabled: _metalState.Config.bool()
  };

  _metalSoy.default.register(ImagePreviewer, _ImagePreviewer.default);

  var _default = ImagePreviewer;
  exports.default = _default;
  //# sourceMappingURL=ImagePreviewer.es.js.map
});
//# sourceMappingURL=ImagePreviewer.es.js.map