/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.preview.audio.internal;

import com.liferay.document.library.kernel.util.AudioProcessorUtil;
import com.liferay.document.library.kernel.util.DLProcessorRegistryUtil;
import com.liferay.document.library.preview.DLPreviewRenderer;
import com.liferay.document.library.preview.DLPreviewRendererProvider;
import com.liferay.document.library.preview.exception.DLFileEntryPreviewGenerationException;
import com.liferay.document.library.preview.exception.DLPreviewGenerationInProcessException;
import com.liferay.document.library.preview.exception.DLPreviewSizeException;
import com.liferay.document.library.service.DLFileVersionPreviewLocalService;
import com.liferay.document.library.util.DLURLHelper;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ParamUtil;
import com.liferay.portal.util.PropsValues;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

public class AudioDLPreviewRendererProvider
implements DLPreviewRendererProvider {
    private final DLFileVersionPreviewLocalService _dlFileVersionPreviewLocalService;
    private final DLURLHelper _dlURLHelper;
    private final ServletContext _servletContext;

    public AudioDLPreviewRendererProvider(DLFileVersionPreviewLocalService dlFileVersionPreviewLocalService, DLURLHelper dlURLHelper, ServletContext servletContext) {
        this._dlFileVersionPreviewLocalService = dlFileVersionPreviewLocalService;
        this._dlURLHelper = dlURLHelper;
        this._servletContext = servletContext;
    }

    public Optional<DLPreviewRenderer> getPreviewDLPreviewRendererOptional(FileVersion fileVersion) {
        if (!AudioProcessorUtil.isAudioSupported((FileVersion)fileVersion)) {
            return Optional.empty();
        }
        return Optional.of((request, response) -> {
            this.checkForPreviewGenerationExceptions(fileVersion);
            RequestDispatcher requestDispatcher = this._servletContext.getRequestDispatcher("/preview/view.jsp");
            request.setAttribute("DOCUMENT_LIBRARY_FILE_VERSION", (Object)fileVersion);
            request.setAttribute("PREVIEW_FILE_URLS", this._getPreviewFileURLs(fileVersion, request));
            requestDispatcher.include((ServletRequest)request, (ServletResponse)response);
        });
    }

    public Optional<DLPreviewRenderer> getThumbnailDLPreviewRendererOptional(FileVersion fileVersion) {
        return Optional.empty();
    }

    protected void checkForPreviewGenerationExceptions(FileVersion fileVersion) throws PortalException {
        if (this._dlFileVersionPreviewLocalService.hasDLFileVersionPreview(fileVersion.getFileEntryId(), fileVersion.getFileVersionId(), 1)) {
            throw new DLFileEntryPreviewGenerationException();
        }
        if (!AudioProcessorUtil.hasAudio((FileVersion)fileVersion)) {
            if (!DLProcessorRegistryUtil.isPreviewableSize((FileVersion)fileVersion)) {
                throw new DLPreviewSizeException();
            }
            throw new DLPreviewGenerationInProcessException();
        }
    }

    private List<String> _getPreviewFileURLs(FileVersion fileVersion, HttpServletRequest httpServletRequest) throws PortalException {
        int status = ParamUtil.getInteger((HttpServletRequest)httpServletRequest, (String)"status", (int)-1);
        String previewQueryString = "&audioPreview=1";
        if (status != -1) {
            previewQueryString = previewQueryString + "&status=" + status;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ArrayList<String> previewFileURLs = new ArrayList<String>();
        try {
            for (String dlFileEntryPreviewAudioContainer : PropsValues.DL_FILE_ENTRY_PREVIEW_AUDIO_CONTAINERS) {
                if (AudioProcessorUtil.getPreviewFileSize((FileVersion)fileVersion, (String)dlFileEntryPreviewAudioContainer) <= 0L) continue;
                previewFileURLs.add(this._dlURLHelper.getPreviewURL(fileVersion.getFileEntry(), fileVersion, themeDisplay, previewQueryString + "&type=" + dlFileEntryPreviewAudioContainer));
            }
        }
        catch (Exception e) {
            throw new PortalException((Throwable)e);
        }
        if (previewFileURLs.isEmpty()) {
            throw new PortalException("No preview available for " + fileVersion.getTitle());
        }
        return previewFileURLs;
    }
}

