/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.BaseDLViewFileVersionDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsUIItemsProcessor;
import com.liferay.document.library.google.docs.internal.helper.GoogleDocsMetadataHelper;
import com.liferay.frontend.taglib.clay.servlet.taglib.util.DropdownItem;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleDocsDLViewFileVersionDisplayContext
extends BaseDLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("7B61EA79-83AE-4FFD-A77A-1D47E06EBBE9");
    private final GoogleDocsMetadataHelper _googleDocsMetadataHelper;
    private final GoogleDocsUIItemsProcessor _googleDocsUIItemsProcessor;

    public GoogleDocsDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion, GoogleDocsMetadataHelper googleDocsMetadataHelper) {
        super(_UUID, parentDLDisplayContext, httpServletRequest, httpServletResponse, fileVersion);
        this._googleDocsMetadataHelper = googleDocsMetadataHelper;
        this._googleDocsUIItemsProcessor = new GoogleDocsUIItemsProcessor(httpServletRequest, googleDocsMetadataHelper);
    }

    public List<DropdownItem> getActionDropdownItems() throws PortalException {
        List actionDropdownItems = super.getActionDropdownItems();
        if (!this.isActionsVisible()) {
            return actionDropdownItems;
        }
        if (Validator.isNull((String)this._googleDocsMetadataHelper.getFieldValue("URL"))) {
            return actionDropdownItems;
        }
        actionDropdownItems.removeIf(dropdownItem -> Objects.equals(dropdownItem.get((Object)"key"), "#edit-with-image-editor"));
        this._googleDocsUIItemsProcessor.processDropdownItems(actionDropdownItems);
        return actionDropdownItems;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        List toolbarItems = super.getToolbarItems();
        this._googleDocsUIItemsProcessor.processToolbarItems(toolbarItems);
        return toolbarItems;
    }

    public void renderPreview(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws IOException {
        String previewURL;
        PrintWriter printWriter = httpServletResponse.getWriter();
        if (this._googleDocsMetadataHelper.containsField("EMBEDDABLE_URL") && Validator.isNotNull((String)(previewURL = this._googleDocsMetadataHelper.getFieldValue("EMBEDDABLE_URL")))) {
            printWriter.format("<iframe frameborder=\"0\" height=\"664px\" src=\"%s\" width=\"100%%\"></iframe>", previewURL);
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)httpServletRequest.getLocale(), ((Object)((Object)this)).getClass());
        printWriter.write("<div class=\"alert alert-info\">");
        printWriter.write(LanguageUtil.get((ResourceBundle)resourceBundle, (String)"google-docs-does-not-provide-a-preview-for-this-document"));
        printWriter.write("</div>");
    }
}

