/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.DLDisplayContextFactory;
import com.liferay.document.library.display.context.DLEditFileEntryDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsDLEditFileEntryDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsDLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.helper.GoogleDocsMetadataHelper;
import com.liferay.document.library.google.drive.configuration.DLGoogleDriveCompanyConfiguration;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.petra.reflect.ReflectionUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.module.configuration.ConfigurationException;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.Validator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-100"}, service={DLDisplayContextFactory.class})
public class GoogleDocsDLDisplayContextFactory
implements DLDisplayContextFactory {
    @Reference
    private ConfigurationProvider _configurationProvider;
    @Reference
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    @Reference
    private DDMStructureLocalService _ddmStructureLocalService;
    @Reference
    private DLAppService _dlAppService;
    @Reference
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    @Reference
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    @Reference
    private StorageEngine _storageEngine;

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DLFileEntryType dlFileEntryType) {
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._isEnabled(themeDisplay.getCompanyId())) {
            return parentDLEditFileEntryDisplayContext;
        }
        DDMStructure googleDocsDDMStructure = GoogleDocsMetadataHelper.getGoogleDocsDDMStructure(dlFileEntryType);
        if (googleDocsDDMStructure != null) {
            return new GoogleDocsDLEditFileEntryDisplayContext(parentDLEditFileEntryDisplayContext, httpServletRequest, httpServletResponse, dlFileEntryType);
        }
        return parentDLEditFileEntryDisplayContext;
    }

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileEntry fileEntry) {
        Object model = fileEntry.getModel();
        if (!(model instanceof DLFileEntry)) {
            return parentDLEditFileEntryDisplayContext;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._isEnabled(themeDisplay.getCompanyId())) {
            return parentDLEditFileEntryDisplayContext;
        }
        GoogleDocsMetadataHelper googleDocsMetadataHelper = new GoogleDocsMetadataHelper(this._ddmFormValuesToFieldsConverter, this._ddmStructureLocalService, (DLFileEntry)model, this._dlFileEntryMetadataLocalService, this._fieldsToDDMFormValuesConverter, this._storageEngine);
        if (googleDocsMetadataHelper.isGoogleDocs()) {
            return new GoogleDocsDLEditFileEntryDisplayContext(parentDLEditFileEntryDisplayContext, httpServletRequest, httpServletResponse, fileEntry, googleDocsMetadataHelper);
        }
        return parentDLEditFileEntryDisplayContext;
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileShortcut fileShortcut) {
        try {
            ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
            if (!this._isEnabled(themeDisplay.getCompanyId())) {
                return parentDLViewFileVersionDisplayContext;
            }
            long fileEntryId = fileShortcut.getToFileEntryId();
            FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
            return this.getDLViewFileVersionDisplayContext(parentDLViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileEntry.getFileVersion());
        }
        catch (PortalException portalException) {
            throw new SystemException("Unable to build GoogleDocsDLViewFileVersionDisplayContext for shortcut " + fileShortcut.getPrimaryKey(), (Throwable)portalException);
        }
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion) {
        Object model = fileVersion.getModel();
        if (!(model instanceof DLFileVersion)) {
            return parentDLViewFileVersionDisplayContext;
        }
        ThemeDisplay themeDisplay = (ThemeDisplay)httpServletRequest.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        if (!this._isEnabled(themeDisplay.getCompanyId())) {
            return parentDLViewFileVersionDisplayContext;
        }
        GoogleDocsMetadataHelper googleDocsMetadataHelper = new GoogleDocsMetadataHelper(this._ddmFormValuesToFieldsConverter, this._ddmStructureLocalService, (DLFileVersion)model, this._dlFileEntryMetadataLocalService, this._fieldsToDDMFormValuesConverter, this._storageEngine);
        if (googleDocsMetadataHelper.isGoogleDocs()) {
            return new GoogleDocsDLViewFileVersionDisplayContext(parentDLViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileVersion, googleDocsMetadataHelper);
        }
        return parentDLViewFileVersionDisplayContext;
    }

    private boolean _isEnabled(long companyId) {
        try {
            DLGoogleDriveCompanyConfiguration dlGoogleDriveCompanyConfiguration = (DLGoogleDriveCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(DLGoogleDriveCompanyConfiguration.class, companyId);
            return Validator.isNotNull((String)dlGoogleDriveCompanyConfiguration.pickerAPIKey());
        }
        catch (ConfigurationException configurationException) {
            return (Boolean)ReflectionUtil.throwException((Throwable)configurationException);
        }
    }
}

