/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.upgrade.v1_0_0;

import com.liferay.document.library.google.drive.configuration.DLGoogleDriveCompanyConfiguration;
import com.liferay.portal.kernel.module.configuration.ConfigurationProvider;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.util.HashMapDictionary;
import com.liferay.portal.kernel.util.PrefsProps;
import com.liferay.portal.kernel.util.Validator;
import com.liferay.portal.util.PortalInstances;
import java.util.Dictionary;
import javax.portlet.PortletPreferences;

public class UpgradePortletPreferences
extends UpgradeProcess {
    private final ConfigurationProvider _configurationProvider;
    private final PrefsProps _prefsProps;

    public UpgradePortletPreferences(ConfigurationProvider configurationProvider, PrefsProps prefsProps) {
        this._configurationProvider = configurationProvider;
        this._prefsProps = prefsProps;
    }

    protected void doUpgrade() throws Exception {
        for (long companyId : PortalInstances.getCompanyIdsBySQL()) {
            DLGoogleDriveCompanyConfiguration dlGoogleDriveCompanyConfiguration = (DLGoogleDriveCompanyConfiguration)this._configurationProvider.getCompanyConfiguration(DLGoogleDriveCompanyConfiguration.class, companyId);
            PortletPreferences portletPreferences = this._prefsProps.getPreferences(companyId);
            final String apiKey = portletPreferences.getValue("googleAppsAPIKey", "");
            final String clientId = portletPreferences.getValue("googleClientId", "");
            if (!Validator.isNotNull((String)apiKey) || !Validator.isNotNull((String)clientId) || !Validator.isNull((String)dlGoogleDriveCompanyConfiguration.clientId()) || !Validator.isNull((String)dlGoogleDriveCompanyConfiguration.clientSecret())) continue;
            this._configurationProvider.saveCompanyConfiguration(DLGoogleDriveCompanyConfiguration.class, companyId, (Dictionary)new HashMapDictionary<String, Object>(){
                {
                    this.put("clientId", clientId);
                    this.put("pickerAPIKey", apiKey);
                }
            });
        }
    }
}

