/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.upgrade.v1_0_0;

import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.RestrictionsFactoryUtil;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.upgrade.UpgradeException;
import com.liferay.portal.kernel.upgrade.UpgradeProcess;
import com.liferay.portal.kernel.upgrade.util.UpgradeProcessUtil;
import com.liferay.portal.kernel.util.LocaleUtil;
import java.sql.SQLException;
import java.util.Locale;
import java.util.Objects;

public class UpgradeFileEntryTypeName
extends UpgradeProcess {
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;

    public UpgradeFileEntryTypeName(DLFileEntryTypeLocalService dlFileEntryTypeLocalService) {
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
    }

    protected void doUpgrade() throws Exception {
        try {
            ActionableDynamicQuery actionableDynamicQuery = this._dlFileEntryTypeLocalService.getActionableDynamicQuery();
            actionableDynamicQuery.setAddCriteriaMethod(dynamicQuery -> dynamicQuery.add(RestrictionsFactoryUtil.eq((String)"fileEntryTypeKey", (Object)"GOOGLE_DOCS")));
            actionableDynamicQuery.setPerformActionMethod(dlFileEntryType -> this._upgradeGoogleDocsDLFileEntryType((DLFileEntryType)dlFileEntryType));
            actionableDynamicQuery.performActions();
        }
        catch (PortalException pe) {
            throw new UpgradeException((Throwable)pe);
        }
    }

    private void _upgradeGoogleDocsDLFileEntryType(DLFileEntryType dlFileEntryType) throws UpgradeException {
        try {
            boolean hasDefaultDescription;
            Locale locale = LocaleUtil.fromLanguageId((String)UpgradeProcessUtil.getDefaultLanguageId((long)dlFileEntryType.getCompanyId()));
            boolean hasDefaultName = Objects.equals(dlFileEntryType.getName(locale), "Google Docs");
            if (hasDefaultName) {
                dlFileEntryType.setName("Google Drive Shortcut", locale);
            }
            if (hasDefaultDescription = Objects.equals(dlFileEntryType.getDescription(locale), "Google Docs")) {
                dlFileEntryType.setDescription("", locale);
            }
            if (hasDefaultName || hasDefaultDescription) {
                this._dlFileEntryTypeLocalService.updateDLFileEntryType(dlFileEntryType);
            }
        }
        catch (SQLException sqle) {
            throw new UpgradeException((Throwable)sqle);
        }
    }
}

