/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsIGViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.util.GoogleDocsMetadataHelper;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.image.gallery.display.kernel.display.context.IGDisplayContextFactory;
import com.liferay.image.gallery.display.kernel.display.context.IGViewFileVersionDisplayContext;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, service={IGDisplayContextFactory.class})
public class GoogleDocsIGDisplayContextFactory
implements IGDisplayContextFactory {
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLAppService _dlAppService;
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    private StorageEngine _storageEngine;

    public IGViewFileVersionDisplayContext getIGViewFileVersionDisplayContext(IGViewFileVersionDisplayContext parentIGViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileShortcut fileShortcut) {
        try {
            long fileEntryId = fileShortcut.getToFileEntryId();
            FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
            FileVersion fileVersion = fileEntry.getFileVersion();
            return this.getIGViewFileVersionDisplayContext(parentIGViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileVersion);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build GoogleDocsDLViewFileVersionDisplayContext for shortcut " + fileShortcut.getPrimaryKey(), (Throwable)pe);
        }
    }

    public IGViewFileVersionDisplayContext getIGViewFileVersionDisplayContext(IGViewFileVersionDisplayContext parentIGViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion) {
        GoogleDocsMetadataHelper googleDocsMetadataHelper = new GoogleDocsMetadataHelper(this._ddmFormValuesToFieldsConverter, this._ddmStructureLocalService, (DLFileVersion)fileVersion.getModel(), this._dlFileEntryMetadataLocalService, this._fieldsToDDMFormValuesConverter, this._storageEngine);
        if (googleDocsMetadataHelper.isGoogleDocs()) {
            return new GoogleDocsIGViewFileVersionDisplayContext(parentIGViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileVersion, googleDocsMetadataHelper);
        }
        return parentIGViewFileVersionDisplayContext;
    }

    @Reference(unbind="-")
    public void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    public void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    public void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    public void setDLFileEntryMetadataLocalService(DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService) {
        this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
    }

    @Reference(unbind="-")
    public void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    @Reference(unbind="-")
    public void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

