/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.DLDisplayContextFactory;
import com.liferay.document.library.display.context.DLEditFileEntryDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsDLEditFileEntryDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsDLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.util.GoogleDocsMetadataHelper;
import com.liferay.document.library.kernel.model.DLFileEntry;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.model.DLFileVersion;
import com.liferay.document.library.kernel.service.DLAppService;
import com.liferay.document.library.kernel.service.DLFileEntryMetadataLocalService;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageEngine;
import com.liferay.dynamic.data.mapping.util.DDMFormValuesToFieldsConverter;
import com.liferay.dynamic.data.mapping.util.FieldsToDDMFormValuesConverter;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.FileShortcut;
import com.liferay.portal.kernel.repository.model.FileVersion;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true, property={"service.ranking:Integer=-100"}, service={DLDisplayContextFactory.class})
public class GoogleDocsDLDisplayContextFactory
implements DLDisplayContextFactory {
    private DDMFormValuesToFieldsConverter _ddmFormValuesToFieldsConverter;
    private DDMStructureLocalService _ddmStructureLocalService;
    private DLAppService _dlAppService;
    private DLFileEntryMetadataLocalService _dlFileEntryMetadataLocalService;
    private FieldsToDDMFormValuesConverter _fieldsToDDMFormValuesConverter;
    private StorageEngine _storageEngine;

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, DLFileEntryType dlFileEntryType) {
        DDMStructure googleDocsDDMStructure = GoogleDocsMetadataHelper.getGoogleDocsDDMStructure(dlFileEntryType);
        if (googleDocsDDMStructure != null) {
            return new GoogleDocsDLEditFileEntryDisplayContext(parentDLEditFileEntryDisplayContext, httpServletRequest, httpServletResponse, dlFileEntryType);
        }
        return parentDLEditFileEntryDisplayContext;
    }

    public DLEditFileEntryDisplayContext getDLEditFileEntryDisplayContext(DLEditFileEntryDisplayContext parentDLEditFileEntryDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileEntry fileEntry) {
        GoogleDocsMetadataHelper googleDocsMetadataHelper;
        Object model = fileEntry.getModel();
        if (model instanceof DLFileEntry && (googleDocsMetadataHelper = new GoogleDocsMetadataHelper(this._ddmFormValuesToFieldsConverter, this._ddmStructureLocalService, (DLFileEntry)model, this._dlFileEntryMetadataLocalService, this._fieldsToDDMFormValuesConverter, this._storageEngine)).isGoogleDocs()) {
            return new GoogleDocsDLEditFileEntryDisplayContext(parentDLEditFileEntryDisplayContext, httpServletRequest, httpServletResponse, fileEntry);
        }
        return parentDLEditFileEntryDisplayContext;
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileShortcut fileShortcut) {
        try {
            long fileEntryId = fileShortcut.getToFileEntryId();
            FileEntry fileEntry = this._dlAppService.getFileEntry(fileEntryId);
            FileVersion fileVersion = fileEntry.getFileVersion();
            return this.getDLViewFileVersionDisplayContext(parentDLViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileVersion);
        }
        catch (PortalException pe) {
            throw new SystemException("Unable to build GoogleDocsDLViewFileVersionDisplayContext for shortcut " + fileShortcut.getPrimaryKey(), (Throwable)pe);
        }
    }

    public DLViewFileVersionDisplayContext getDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLViewFileVersionDisplayContext, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse, FileVersion fileVersion) {
        GoogleDocsMetadataHelper googleDocsMetadataHelper;
        Object model = fileVersion.getModel();
        if (model instanceof DLFileVersion && (googleDocsMetadataHelper = new GoogleDocsMetadataHelper(this._ddmFormValuesToFieldsConverter, this._ddmStructureLocalService, (DLFileVersion)model, this._dlFileEntryMetadataLocalService, this._fieldsToDDMFormValuesConverter, this._storageEngine)).isGoogleDocs()) {
            return new GoogleDocsDLViewFileVersionDisplayContext(parentDLViewFileVersionDisplayContext, httpServletRequest, httpServletResponse, fileVersion, googleDocsMetadataHelper);
        }
        return parentDLViewFileVersionDisplayContext;
    }

    @Reference(unbind="-")
    public void setDDMFormValuesToFieldsConverter(DDMFormValuesToFieldsConverter ddmFormValuesToFieldsConverter) {
        this._ddmFormValuesToFieldsConverter = ddmFormValuesToFieldsConverter;
    }

    @Reference(unbind="-")
    public void setDDMStructureLocalService(DDMStructureLocalService ddmStructureLocalService) {
        this._ddmStructureLocalService = ddmStructureLocalService;
    }

    @Reference(unbind="-")
    public void setDLAppService(DLAppService dlAppService) {
        this._dlAppService = dlAppService;
    }

    @Reference(unbind="-")
    public void setDLFileEntryMetadataLocalService(DLFileEntryMetadataLocalService dlFileEntryMetadataLocalService) {
        this._dlFileEntryMetadataLocalService = dlFileEntryMetadataLocalService;
    }

    @Reference(unbind="-")
    public void setFieldsToDDMFormValuesConverter(FieldsToDDMFormValuesConverter fieldsToDDMFormValuesConverter) {
        this._fieldsToDDMFormValuesConverter = fieldsToDDMFormValuesConverter;
    }

    @Reference(unbind="-")
    public void setStorageEngine(StorageEngine storageEngine) {
        this._storageEngine = storageEngine;
    }
}

