/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.util;

import com.liferay.document.library.kernel.model.DLFileEntryMetadata;
import com.liferay.document.library.kernel.model.DLFileEntryType;
import com.liferay.document.library.kernel.service.DLFileEntryTypeLocalService;
import com.liferay.dynamic.data.mapping.io.DDMFormXSDDeserializer;
import com.liferay.dynamic.data.mapping.model.DDMForm;
import com.liferay.dynamic.data.mapping.model.DDMFormLayout;
import com.liferay.dynamic.data.mapping.model.DDMStructure;
import com.liferay.dynamic.data.mapping.service.DDMStructureLocalService;
import com.liferay.dynamic.data.mapping.storage.StorageType;
import com.liferay.dynamic.data.mapping.util.DDM;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.model.Company;
import com.liferay.portal.kernel.service.ClassNameLocalService;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.service.UserLocalService;
import com.liferay.portal.kernel.util.LocaleUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;

public class GoogleDocsDLFileEntryTypeHelper {
    private final ClassNameLocalService _classNameLocalService;
    private final Company _company;
    private final DDM _ddm;
    private final DDMFormXSDDeserializer _ddmFormXSDDeserializer;
    private final DDMStructureLocalService _ddmStructureLocalService;
    private final long _dlFileEntryMetadataClassNameId;
    private final DLFileEntryTypeLocalService _dlFileEntryTypeLocalService;
    private final UserLocalService _userLocalService;

    public GoogleDocsDLFileEntryTypeHelper(Company company, ClassNameLocalService classNameLocalService, DDM ddm, DDMFormXSDDeserializer ddmFormXSDDeserializer, DDMStructureLocalService ddmStructureLocalService, DLFileEntryTypeLocalService dlFileEntryTypeLocalService, UserLocalService userLocalService) {
        this._company = company;
        this._classNameLocalService = classNameLocalService;
        this._ddm = ddm;
        this._ddmFormXSDDeserializer = ddmFormXSDDeserializer;
        this._ddmStructureLocalService = ddmStructureLocalService;
        this._dlFileEntryTypeLocalService = dlFileEntryTypeLocalService;
        this._userLocalService = userLocalService;
        this._dlFileEntryMetadataClassNameId = this._classNameLocalService.getClassNameId(DLFileEntryMetadata.class);
    }

    public DDMStructure addGoogleDocsDDMStructure() throws PortalException {
        long defaultUserId = this._userLocalService.getDefaultUserId(this._company.getCompanyId());
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        for (Locale curLocale : LanguageUtil.getAvailableLocales((long)this._company.getCompanyId())) {
            nameMap.put(curLocale, "Google Docs Metadata");
            descriptionMap.put(curLocale, "Google Docs Metadata");
        }
        String definition = null;
        try {
            definition = StringUtil.read((InputStream)GoogleDocsDLFileEntryTypeHelper.class.getResourceAsStream("dependencies/ddm_structure_google_docs.xml"));
        }
        catch (IOException ioe) {
            throw new PortalException((Throwable)ioe);
        }
        Locale locale = this._company.getLocale();
        definition = StringUtil.replace((String)definition, (String)"[$LOCALE_DEFAULT$]", (String)locale.toString());
        DDMForm ddmForm = this._ddmFormXSDDeserializer.deserialize(definition);
        DDMFormLayout ddmFormLayout = this._ddm.getDefaultDDMFormLayout(ddmForm);
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setScopeGroupId(this._company.getGroupId());
        serviceContext.setUserId(defaultUserId);
        return this._ddmStructureLocalService.addStructure(defaultUserId, this._company.getGroupId(), 0L, this._dlFileEntryMetadataClassNameId, "GOOGLE_DOCS", nameMap, descriptionMap, ddmForm, ddmFormLayout, StorageType.JSON.toString(), 0, serviceContext);
    }

    public DLFileEntryType addGoogleDocsDLFileEntryType() throws PortalException {
        List dlFileEntryTypes;
        DDMStructure ddmStructure = this._ddmStructureLocalService.fetchStructure(this._company.getGroupId(), this._dlFileEntryMetadataClassNameId, "GOOGLE_DOCS");
        if (ddmStructure == null) {
            ddmStructure = this.addGoogleDocsDDMStructure();
        }
        if (!(dlFileEntryTypes = this._dlFileEntryTypeLocalService.getFileEntryTypes(ddmStructure.getStructureId())).isEmpty()) {
            return (DLFileEntryType)dlFileEntryTypes.get(0);
        }
        return this.addGoogleDocsDLFileEntryType(ddmStructure.getStructureId());
    }

    protected DLFileEntryType addGoogleDocsDLFileEntryType(long ddmStructureId) throws PortalException {
        long defaultUserId = this._userLocalService.getDefaultUserId(this._company.getCompanyId());
        HashMap<Locale, String> nameMap = new HashMap<Locale, String>();
        nameMap.put(LocaleUtil.getDefault(), "Google Docs");
        HashMap<Locale, String> descriptionMap = new HashMap<Locale, String>();
        descriptionMap.put(LocaleUtil.getDefault(), "Google Docs");
        ServiceContext serviceContext = new ServiceContext();
        serviceContext.setAddGuestPermissions(true);
        serviceContext.setAddGroupPermissions(true);
        serviceContext.setScopeGroupId(this._company.getGroupId());
        serviceContext.setUserId(defaultUserId);
        return this._dlFileEntryTypeLocalService.addFileEntryType(defaultUserId, this._company.getGroupId(), "GOOGLE_DOCS", nameMap, descriptionMap, new long[]{ddmStructureId}, serviceContext);
    }
}

