/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.DLUIItemKeys;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsUIItemKeys;
import com.liferay.document.library.google.docs.internal.util.GoogleDocsMetadataHelper;
import com.liferay.portal.kernel.language.LanguageUtil;
import com.liferay.portal.kernel.servlet.taglib.ui.MenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.UIItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLMenuItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLToolbarItem;
import com.liferay.portal.kernel.servlet.taglib.ui.URLUIItem;
import com.liferay.portal.kernel.theme.ThemeDisplay;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;

public class GoogleDocsUIItemsProcessor {
    private final GoogleDocsMetadataHelper _googleDocsMetadataHelper;
    private final HttpServletRequest _request;

    public GoogleDocsUIItemsProcessor(HttpServletRequest request, GoogleDocsMetadataHelper googleDocsMetadataHelper) {
        this._request = request;
        this._googleDocsMetadataHelper = googleDocsMetadataHelper;
    }

    public void processMenuItems(List<MenuItem> menuItems) {
        this._removeUnsupportedUIItems(menuItems);
        URLMenuItem urlMenuItem = (URLMenuItem)this._insertEditInGoogleURLUIItem((URLUIItem)new URLMenuItem(), (List)menuItems);
        urlMenuItem.setMethod("GET");
    }

    public void processToolbarItems(List<ToolbarItem> toolbarItems) {
        this._removeUnsupportedUIItems(toolbarItems);
        this._insertEditInGoogleURLUIItem((URLUIItem)new URLToolbarItem(), (List)toolbarItems);
    }

    private int _getIndex(List<? extends UIItem> uiItems, String key) {
        for (int i = 0; i < uiItems.size(); ++i) {
            UIItem uiItem = uiItems.get(i);
            if (!key.equals(uiItem.getKey())) continue;
            return i;
        }
        return -1;
    }

    private <T extends URLUIItem> T _insertEditInGoogleURLUIItem(T urlUIItem, List<? super T> urlUIItems) {
        if (!this._googleDocsMetadataHelper.containsField("URL")) {
            return urlUIItem;
        }
        int index = this._getIndex(urlUIItems, DLUIItemKeys.EDIT);
        if (index == -1) {
            index = 0;
        }
        urlUIItem.setKey(GoogleDocsUIItemKeys.EDIT_IN_GOOGLE);
        ThemeDisplay themeDisplay = (ThemeDisplay)this._request.getAttribute("LIFERAY_SHARED_THEME_DISPLAY");
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)themeDisplay.getLocale(), this.getClass());
        String message = LanguageUtil.get((ResourceBundle)resourceBundle, (String)"edit-in-google-docs");
        urlUIItem.setLabel(message);
        urlUIItem.setTarget("_blank");
        String editURL = this._googleDocsMetadataHelper.getFieldValue("URL");
        urlUIItem.setURL(editURL);
        urlUIItems.add(index, urlUIItem);
        return urlUIItem;
    }

    private void _removeUIItem(List<? extends UIItem> uiItems, String key) {
        int index = this._getIndex(uiItems, key);
        if (index != -1) {
            uiItems.remove(index);
        }
    }

    private void _removeUnsupportedUIItems(List<? extends UIItem> uiItems) {
        this._removeUIItem(uiItems, DLUIItemKeys.CANCEL_CHECKOUT);
        this._removeUIItem(uiItems, DLUIItemKeys.CHECKIN);
        this._removeUIItem(uiItems, DLUIItemKeys.CHECKOUT);
        this._removeUIItem(uiItems, DLUIItemKeys.DOWNLOAD);
        this._removeUIItem(uiItems, DLUIItemKeys.OPEN_IN_MS_OFFICE);
    }
}

