/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.google.docs.internal.display.context;

import com.liferay.document.library.display.context.BaseDLViewFileVersionDisplayContext;
import com.liferay.document.library.display.context.DLViewFileVersionDisplayContext;
import com.liferay.document.library.google.docs.internal.display.context.GoogleDocsUIItemsProcessor;
import com.liferay.document.library.google.docs.internal.util.GoogleDocsMetadataHelper;
import com.liferay.dynamic.data.mapping.kernel.DDMStructure;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.repository.model.FileVersion;
import com.liferay.portal.kernel.servlet.taglib.ui.Menu;
import com.liferay.portal.kernel.servlet.taglib.ui.ToolbarItem;
import com.liferay.portal.kernel.util.ResourceBundleUtil;
import com.liferay.portal.kernel.util.Validator;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class GoogleDocsDLViewFileVersionDisplayContext
extends BaseDLViewFileVersionDisplayContext {
    private static final UUID _UUID = UUID.fromString("7B61EA79-83AE-4FFD-A77A-1D47E06EBBE9");
    private final GoogleDocsMetadataHelper _googleDocsMetadataHelper;
    private final GoogleDocsUIItemsProcessor _googleDocsUIItemsProcessor;

    public GoogleDocsDLViewFileVersionDisplayContext(DLViewFileVersionDisplayContext parentDLDisplayContext, HttpServletRequest request, HttpServletResponse response, FileVersion fileVersion, GoogleDocsMetadataHelper googleDocsMetadataHelper) {
        super(_UUID, parentDLDisplayContext, request, response, fileVersion);
        this._googleDocsMetadataHelper = googleDocsMetadataHelper;
        this._googleDocsUIItemsProcessor = new GoogleDocsUIItemsProcessor(request, googleDocsMetadataHelper);
    }

    public List<DDMStructure> getDDMStructures() throws PortalException {
        List ddmStructures = super.getDDMStructures();
        Iterator iterator = ddmStructures.iterator();
        while (iterator.hasNext()) {
            DDMStructure ddmStructure = (DDMStructure)iterator.next();
            String structureKey = ddmStructure.getStructureKey();
            if (!structureKey.equals("GOOGLE_DOCS")) continue;
            iterator.remove();
            break;
        }
        return ddmStructures;
    }

    public Menu getMenu() throws PortalException {
        Menu menu = super.getMenu();
        if (Validator.isNull((String)this._googleDocsMetadataHelper.getFieldValue("URL"))) {
            return menu;
        }
        List menuItems = menu.getMenuItems();
        menuItems.removeIf(menuItem -> Objects.equals(menuItem.getKey(), "#edit-with-image-editor"));
        this._googleDocsUIItemsProcessor.processMenuItems(menuItems);
        return menu;
    }

    public List<ToolbarItem> getToolbarItems() throws PortalException {
        List toolbarItems = super.getToolbarItems();
        this._googleDocsUIItemsProcessor.processToolbarItems(toolbarItems);
        return toolbarItems;
    }

    public boolean hasPreview() {
        return false;
    }

    public boolean isDownloadLinkVisible() {
        return false;
    }

    public boolean isVersionInfoVisible() {
        return false;
    }

    public void renderPreview(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String previewURL;
        PrintWriter printWriter = response.getWriter();
        if (this._googleDocsMetadataHelper.containsField("EMBEDDABLE_URL") && Validator.isNotNull((String)(previewURL = this._googleDocsMetadataHelper.getFieldValue("EMBEDDABLE_URL")))) {
            printWriter.format("<iframe frameborder=\"0\" height=\"300\" src=\"%s\" width=\"100%%\"></iframe>", previewURL);
            return;
        }
        ResourceBundle resourceBundle = ResourceBundleUtil.getBundle((String)"content.Language", (Locale)request.getLocale(), ((Object)((Object)this)).getClass());
        printWriter.write("<div class=\"alert alert-info\">");
        printWriter.write(ResourceBundleUtil.getString((ResourceBundle)resourceBundle, (String)"google-docs-does-not-provide-a-preview-for-this-document"));
        printWriter.write("</div>");
    }
}

