/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.demo.data.creator.internal;

import com.liferay.document.library.demo.data.creator.FileEntryDemoDataCreator;
import com.liferay.document.library.kernel.exception.NoSuchFileEntryException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.FileEntry;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.security.RandomUtil;
import com.liferay.portal.kernel.service.ServiceContext;
import com.liferay.portal.kernel.util.FileUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(property={"source=unsplash", "type=image"}, service={FileEntryDemoDataCreator.class})
public class UnsplashFileEntryDemoDataCreatorImpl
implements FileEntryDemoDataCreator {
    private static final Log _log = LogFactoryUtil.getLog(UnsplashFileEntryDemoDataCreatorImpl.class);
    private static final List<String> _categories = Arrays.asList("buildings", "food", "nature", "people", "technology", "objects");
    private volatile int _categoryIndex = -1;
    @Reference
    private DLAppLocalService _dlAppLocalService;
    private final List<Long> _fileEntryIds = new CopyOnWriteArrayList<Long>();

    public FileEntry create(long userId, long folderId) throws IOException, PortalException {
        String sourceFileName = String.valueOf(UUID.randomUUID()) + ".jpeg";
        return this.create(userId, folderId, sourceFileName);
    }

    public FileEntry create(long userId, long folderId, String name) throws IOException, PortalException {
        Folder folder = this._dlAppLocalService.getFolder(folderId);
        FileEntry fileEntry = this._dlAppLocalService.addFileEntry(null, userId, folder.getGroupId(), folderId, name, "image/jpeg", this._getBytes(), null, null, new ServiceContext());
        this._fileEntryIds.add(fileEntry.getFileEntryId());
        return fileEntry;
    }

    public void delete() throws PortalException {
        for (long fileEntryId : this._fileEntryIds) {
            block3: {
                try {
                    this._dlAppLocalService.deleteFileEntry(fileEntryId);
                }
                catch (NoSuchFileEntryException noSuchFileEntryException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchFileEntryException);
                }
            }
            this._fileEntryIds.remove(fileEntryId);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] _getBytes() throws IOException, PortalException {
        URL url = this._getNextUrl();
        try (InputStream inputStream = url.openStream();){
            byte[] throwable3 = FileUtil.getBytes((InputStream)inputStream);
            return throwable3;
        }
        catch (IOException ioException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)ioException);
            }
            String fileName = String.format("dependencies/%d.jpg", RandomUtil.nextInt((int)5));
            try {
                return FileUtil.getBytes(this.getClass(), (String)fileName);
            }
            catch (Exception exception) {
                throw new PortalException((Throwable)exception);
            }
        }
    }

    private URL _getNextUrl() throws MalformedURLException {
        ++this._categoryIndex;
        if (this._categoryIndex == _categories.size()) {
            this._categoryIndex = 0;
        }
        String urlString = String.format("https://source.unsplash.com/category/%s/1920x1080", _categories.get(this._categoryIndex));
        return new URL(urlString);
    }
}

