/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.demo.data.creator.internal;

import com.liferay.document.library.demo.data.creator.BaseFolderDemoDataCreator;
import com.liferay.document.library.kernel.exception.NoSuchFolderException;
import com.liferay.document.library.kernel.service.DLAppLocalService;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.repository.model.Folder;
import com.liferay.portal.kernel.service.ServiceContext;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.osgi.service.component.annotations.Reference;

public abstract class BaseFolderDemoDataCreatorImpl
implements BaseFolderDemoDataCreator {
    @Reference
    protected DLAppLocalService dlAppLocalService;
    private static final Log _log = LogFactoryUtil.getLog(BaseFolderDemoDataCreatorImpl.class);
    private final List<Long> _folderIds = new CopyOnWriteArrayList<Long>();

    public void delete() throws PortalException {
        for (long folderId : this._folderIds) {
            block3: {
                try {
                    this.dlAppLocalService.deleteFolder(folderId);
                }
                catch (NoSuchFolderException noSuchFolderException) {
                    if (!_log.isWarnEnabled()) break block3;
                    _log.warn((Throwable)noSuchFolderException);
                }
            }
            this._folderIds.remove(folderId);
        }
    }

    protected Folder createFolder(long userId, long groupId, long folderId, String name) throws PortalException {
        Folder folder = null;
        try {
            folder = this.dlAppLocalService.getFolder(groupId, folderId, name);
        }
        catch (NoSuchFolderException noSuchFolderException) {
            if (_log.isWarnEnabled()) {
                _log.warn((Throwable)noSuchFolderException);
            }
            folder = this.dlAppLocalService.addFolder(userId, groupId, folderId, name, "", new ServiceContext());
        }
        this._folderIds.add(folder.getFolderId());
        return folder;
    }
}

