/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.content.service.base;

import com.liferay.counter.kernel.service.CounterLocalService;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.model.DLContentDataBlobModel;
import com.liferay.document.library.content.service.DLContentLocalService;
import com.liferay.document.library.content.service.persistence.DLContentPersistence;
import com.liferay.petra.function.UnsafeFunction;
import com.liferay.petra.io.AutoDeleteFileInputStream;
import com.liferay.petra.sql.dsl.query.DSLQuery;
import com.liferay.portal.aop.AopService;
import com.liferay.portal.kernel.dao.db.DB;
import com.liferay.portal.kernel.dao.db.DBManagerUtil;
import com.liferay.portal.kernel.dao.db.DBType;
import com.liferay.portal.kernel.dao.jdbc.ParamSetter;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdate;
import com.liferay.portal.kernel.dao.jdbc.SqlUpdateFactoryUtil;
import com.liferay.portal.kernel.dao.orm.ActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DefaultActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQuery;
import com.liferay.portal.kernel.dao.orm.DynamicQueryFactoryUtil;
import com.liferay.portal.kernel.dao.orm.IndexableActionableDynamicQuery;
import com.liferay.portal.kernel.dao.orm.Projection;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.exception.SystemException;
import com.liferay.portal.kernel.io.unsync.UnsyncByteArrayInputStream;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.model.PersistedModel;
import com.liferay.portal.kernel.module.framework.service.IdentifiableOSGiService;
import com.liferay.portal.kernel.search.Indexable;
import com.liferay.portal.kernel.search.IndexableType;
import com.liferay.portal.kernel.service.BaseLocalService;
import com.liferay.portal.kernel.service.BaseLocalServiceImpl;
import com.liferay.portal.kernel.service.PersistedModelLocalService;
import com.liferay.portal.kernel.service.change.tracking.CTService;
import com.liferay.portal.kernel.service.persistence.BasePersistence;
import com.liferay.portal.kernel.service.persistence.change.tracking.CTPersistence;
import com.liferay.portal.kernel.transaction.Transactional;
import com.liferay.portal.kernel.util.File;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PortalUtil;
import java.io.InputStream;
import java.io.Serializable;
import java.sql.Blob;
import java.util.List;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Reference;

public abstract class DLContentLocalServiceBaseImpl
extends BaseLocalServiceImpl
implements AopService,
DLContentLocalService,
IdentifiableOSGiService {
    protected DLContentLocalService dlContentLocalService;
    @Reference
    protected DLContentPersistence dlContentPersistence;
    @Reference
    protected CounterLocalService counterLocalService;
    @Reference
    protected File _file;
    private static final InputStream _EMPTY_INPUT_STREAM = new UnsyncByteArrayInputStream(new byte[0]);
    private boolean _useTempFile;

    @Indexable(type=IndexableType.REINDEX)
    public DLContent addDLContent(DLContent dlContent) {
        dlContent.setNew(true);
        return (DLContent)this.dlContentPersistence.update((BaseModel)dlContent);
    }

    @Transactional(enabled=false)
    public DLContent createDLContent(long contentId) {
        return this.dlContentPersistence.create(contentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLContent deleteDLContent(long contentId) throws PortalException {
        return this.dlContentPersistence.remove(contentId);
    }

    @Indexable(type=IndexableType.DELETE)
    public DLContent deleteDLContent(DLContent dlContent) {
        return (DLContent)this.dlContentPersistence.remove((BaseModel)dlContent);
    }

    public <T> T dslQuery(DSLQuery dslQuery) {
        return (T)this.dlContentPersistence.dslQuery(dslQuery);
    }

    public DynamicQuery dynamicQuery() {
        Class<?> clazz = ((Object)((Object)this)).getClass();
        return DynamicQueryFactoryUtil.forClass(DLContent.class, (ClassLoader)clazz.getClassLoader());
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery) {
        return this.dlContentPersistence.findWithDynamicQuery(dynamicQuery);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end) {
        return this.dlContentPersistence.findWithDynamicQuery(dynamicQuery, start, end);
    }

    public <T> List<T> dynamicQuery(DynamicQuery dynamicQuery, int start, int end, OrderByComparator<T> orderByComparator) {
        return this.dlContentPersistence.findWithDynamicQuery(dynamicQuery, start, end, orderByComparator);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery) {
        return this.dlContentPersistence.countWithDynamicQuery(dynamicQuery);
    }

    public long dynamicQueryCount(DynamicQuery dynamicQuery, Projection projection) {
        return this.dlContentPersistence.countWithDynamicQuery(dynamicQuery, projection);
    }

    public DLContent fetchDLContent(long contentId) {
        return this.dlContentPersistence.fetchByPrimaryKey(contentId);
    }

    public DLContent getDLContent(long contentId) throws PortalException {
        return this.dlContentPersistence.findByPrimaryKey(contentId);
    }

    public ActionableDynamicQuery getActionableDynamicQuery() {
        DefaultActionableDynamicQuery actionableDynamicQuery = new DefaultActionableDynamicQuery();
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
        return actionableDynamicQuery;
    }

    public IndexableActionableDynamicQuery getIndexableActionableDynamicQuery() {
        IndexableActionableDynamicQuery indexableActionableDynamicQuery = new IndexableActionableDynamicQuery();
        indexableActionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlContentLocalService);
        indexableActionableDynamicQuery.setClassLoader(this.getClassLoader());
        indexableActionableDynamicQuery.setModelClass(DLContent.class);
        indexableActionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
        return indexableActionableDynamicQuery;
    }

    protected void initActionableDynamicQuery(ActionableDynamicQuery actionableDynamicQuery) {
        actionableDynamicQuery.setBaseLocalService((BaseLocalService)this.dlContentLocalService);
        actionableDynamicQuery.setClassLoader(this.getClassLoader());
        actionableDynamicQuery.setModelClass(DLContent.class);
        actionableDynamicQuery.setPrimaryKeyPropertyName("contentId");
    }

    public PersistedModel createPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return this.dlContentPersistence.create(((Long)primaryKeyObj).longValue());
    }

    public PersistedModel deletePersistedModel(PersistedModel persistedModel) throws PortalException {
        return this.dlContentLocalService.deleteDLContent((DLContent)persistedModel);
    }

    public BasePersistence<DLContent> getBasePersistence() {
        return this.dlContentPersistence;
    }

    public PersistedModel getPersistedModel(Serializable primaryKeyObj) throws PortalException {
        return (PersistedModel)this.dlContentPersistence.findByPrimaryKey(primaryKeyObj);
    }

    public List<DLContent> getDLContents(int start, int end) {
        return this.dlContentPersistence.findAll(start, end);
    }

    public int getDLContentsCount() {
        return this.dlContentPersistence.countAll();
    }

    @Indexable(type=IndexableType.REINDEX)
    public DLContent updateDLContent(DLContent dlContent) {
        return (DLContent)this.dlContentPersistence.update((BaseModel)dlContent);
    }

    public DLContentDataBlobModel getDataBlobModel(Serializable primaryKey) {
        Session session = null;
        try {
            session = this.dlContentPersistence.openSession();
            DLContentDataBlobModel dLContentDataBlobModel = (DLContentDataBlobModel)session.get(DLContentDataBlobModel.class, primaryKey);
            return dLContentDataBlobModel;
        }
        catch (Exception exception) {
            throw this.dlContentPersistence.processException(exception);
        }
        finally {
            this.dlContentPersistence.closeSession(session);
        }
    }

    @Transactional(readOnly=true)
    public InputStream openDataInputStream(long contentId) {
        try {
            DLContentDataBlobModel DLContentDataBlobModel2 = this.getDataBlobModel(Long.valueOf(contentId));
            Blob blob = DLContentDataBlobModel2.getDataBlob();
            if (blob == null) {
                return _EMPTY_INPUT_STREAM;
            }
            InputStream inputStream = blob.getBinaryStream();
            if (this._useTempFile) {
                inputStream = new AutoDeleteFileInputStream(this._file.createTempFile(inputStream));
            }
            return inputStream;
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }

    @Activate
    protected void activate() {
        DB db = DBManagerUtil.getDB();
        if (db.getDBType() != DBType.DB2 && db.getDBType() != DBType.MYSQL && db.getDBType() != DBType.MARIADB && db.getDBType() != DBType.SYBASE) {
            this._useTempFile = true;
        }
    }

    public Class<?>[] getAopInterfaces() {
        return new Class[]{DLContentLocalService.class, IdentifiableOSGiService.class, CTService.class, PersistedModelLocalService.class};
    }

    public void setAopProxy(Object aopProxy) {
        this.dlContentLocalService = (DLContentLocalService)aopProxy;
    }

    public String getOSGiServiceIdentifier() {
        return DLContentLocalService.class.getName();
    }

    public CTPersistence<DLContent> getCTPersistence() {
        return this.dlContentPersistence;
    }

    public Class<DLContent> getModelClass() {
        return DLContent.class;
    }

    public <R, E extends Throwable> R updateWithUnsafeFunction(UnsafeFunction<CTPersistence<DLContent>, R, E> updateUnsafeFunction) throws E {
        return (R)updateUnsafeFunction.apply((Object)this.dlContentPersistence);
    }

    protected String getModelClassName() {
        return DLContent.class.getName();
    }

    protected void runSQL(String sql) {
        try {
            DataSource dataSource = this.dlContentPersistence.getDataSource();
            DB db = DBManagerUtil.getDB();
            sql = db.buildSQL(sql);
            sql = PortalUtil.transformSQL((String)sql);
            SqlUpdate sqlUpdate = SqlUpdateFactoryUtil.getSqlUpdate((DataSource)dataSource, (String)sql, (ParamSetter[])new ParamSetter[0]);
            sqlUpdate.update(new Object[0]);
        }
        catch (Exception exception) {
            throw new SystemException((Throwable)exception);
        }
    }
}

