/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.document.library.content.service.persistence.impl;

import com.liferay.document.library.content.exception.NoSuchContentException;
import com.liferay.document.library.content.model.DLContent;
import com.liferay.document.library.content.model.impl.DLContentImpl;
import com.liferay.document.library.content.model.impl.DLContentModelImpl;
import com.liferay.document.library.content.service.persistence.DLContentPersistence;
import com.liferay.document.library.content.service.persistence.DLContentUtil;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.configuration.Configuration;
import com.liferay.portal.kernel.dao.orm.Dialect;
import com.liferay.portal.kernel.dao.orm.EntityCache;
import com.liferay.portal.kernel.dao.orm.FinderCache;
import com.liferay.portal.kernel.dao.orm.FinderPath;
import com.liferay.portal.kernel.dao.orm.Query;
import com.liferay.portal.kernel.dao.orm.QueryPos;
import com.liferay.portal.kernel.dao.orm.QueryUtil;
import com.liferay.portal.kernel.dao.orm.Session;
import com.liferay.portal.kernel.dao.orm.SessionFactory;
import com.liferay.portal.kernel.log.Log;
import com.liferay.portal.kernel.log.LogFactoryUtil;
import com.liferay.portal.kernel.model.BaseModel;
import com.liferay.portal.kernel.security.auth.CompanyThreadLocal;
import com.liferay.portal.kernel.service.persistence.impl.BasePersistenceImpl;
import com.liferay.portal.kernel.util.GetterUtil;
import com.liferay.portal.kernel.util.OrderByComparator;
import com.liferay.portal.kernel.util.PropsUtil;
import com.liferay.portal.kernel.util.ProxyUtil;
import com.liferay.portal.kernel.util.SetUtil;
import com.liferay.portal.kernel.util.StringUtil;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;

@Component(service={DLContentPersistence.class})
public class DLContentPersistenceImpl
extends BasePersistenceImpl<DLContent>
implements DLContentPersistence {
    public static final String FINDER_CLASS_NAME_ENTITY = DLContentImpl.class.getName();
    public static final String FINDER_CLASS_NAME_LIST_WITH_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List1";
    public static final String FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION = FINDER_CLASS_NAME_ENTITY + ".List2";
    private FinderPath _finderPathWithPaginationFindAll;
    private FinderPath _finderPathWithoutPaginationFindAll;
    private FinderPath _finderPathCountAll;
    private FinderPath _finderPathWithPaginationFindByC_R;
    private FinderPath _finderPathWithoutPaginationFindByC_R;
    private FinderPath _finderPathCountByC_R;
    private static final String _FINDER_COLUMN_C_R_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_REPOSITORYID_2 = "dlContent.repositoryId = ?";
    private FinderPath _finderPathWithPaginationFindByC_R_P;
    private FinderPath _finderPathWithoutPaginationFindByC_R_P;
    private FinderPath _finderPathCountByC_R_P;
    private static final String _FINDER_COLUMN_C_R_P_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_PATH_2 = "dlContent.path = ?";
    private static final String _FINDER_COLUMN_C_R_P_PATH_3 = "(dlContent.path IS NULL OR dlContent.path = '')";
    private FinderPath _finderPathWithPaginationFindByC_R_LikeP;
    private FinderPath _finderPathWithPaginationCountByC_R_LikeP;
    private static final String _FINDER_COLUMN_C_R_LIKEP_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_LIKEP_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_LIKEP_PATH_2 = "dlContent.path LIKE ?";
    private static final String _FINDER_COLUMN_C_R_LIKEP_PATH_3 = "(dlContent.path IS NULL OR dlContent.path LIKE '')";
    private FinderPath _finderPathFetchByC_R_P_V;
    private FinderPath _finderPathCountByC_R_P_V;
    private static final String _FINDER_COLUMN_C_R_P_V_COMPANYID_2 = "dlContent.companyId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_REPOSITORYID_2 = "dlContent.repositoryId = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_PATH_2 = "dlContent.path = ? AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_PATH_3 = "(dlContent.path IS NULL OR dlContent.path = '') AND ";
    private static final String _FINDER_COLUMN_C_R_P_V_VERSION_2 = "dlContent.version = ?";
    private static final String _FINDER_COLUMN_C_R_P_V_VERSION_3 = "(dlContent.version IS NULL OR dlContent.version = '')";
    private int _valueObjectFinderCacheListThreshold;
    private boolean _columnBitmaskEnabled;
    @Reference
    protected EntityCache entityCache;
    @Reference
    protected FinderCache finderCache;
    private static final String _SQL_SELECT_DLCONTENT = "SELECT dlContent FROM DLContent dlContent";
    private static final String _SQL_SELECT_DLCONTENT_WHERE = "SELECT dlContent FROM DLContent dlContent WHERE ";
    private static final String _SQL_COUNT_DLCONTENT = "SELECT COUNT(dlContent) FROM DLContent dlContent";
    private static final String _SQL_COUNT_DLCONTENT_WHERE = "SELECT COUNT(dlContent) FROM DLContent dlContent WHERE ";
    private static final String _ORDER_BY_ENTITY_ALIAS = "dlContent.";
    private static final String _NO_SUCH_ENTITY_WITH_PRIMARY_KEY = "No DLContent exists with the primary key ";
    private static final String _NO_SUCH_ENTITY_WITH_KEY = "No DLContent exists with the key {";
    private static final Log _log = LogFactoryUtil.getLog(DLContentPersistenceImpl.class);
    private static final Set<String> _badColumnNames = SetUtil.fromArray((Object[])new String[]{"path", "data", "size"});

    public List<DLContent> findByC_R(long companyId, long repositoryId) {
        return this.findByC_R(companyId, repositoryId, -1, -1, null);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end) {
        return this.findByC_R(companyId, repositoryId, start, end, null);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R(companyId, repositoryId, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R(long companyId, long repositoryId, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_R;
                finderArgs = new Object[]{companyId, repositoryId};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_R;
            finderArgs = new Object[]{companyId, repositoryId, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId()) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(4 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(4);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_First(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_First(companyId, repositoryId, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_First(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R(companyId, repositoryId, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_Last(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_Last(companyId, repositoryId, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(6);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_Last(long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R(companyId, repositoryId);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R(companyId, repositoryId, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_PrevAndNext(long contentId, long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_PrevAndNext(session, dlContent, companyId, repositoryId, orderByComparator, true), dlContent, this.getByC_R_PrevAndNext(session, dlContent, companyId, repositoryId, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(4);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R(long companyId, long repositoryId) {
        for (DLContent dlContent : this.findByC_R(companyId, repositoryId, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R(long companyId, long repositoryId) {
        FinderPath finderPath = this._finderPathCountByC_R;
        Object[] finderArgs = new Object[]{companyId, repositoryId};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(3);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append(_FINDER_COLUMN_C_R_REPOSITORYID_2);
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path) {
        return this.findByC_R_P(companyId, repositoryId, path, -1, -1, null);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end) {
        return this.findByC_R_P(companyId, repositoryId, path, start, end, null);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R_P(companyId, repositoryId, path, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R_P(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        path = Objects.toString(path, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindByC_R_P;
                finderArgs = new Object[]{companyId, repositoryId, path};
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindByC_R_P;
            finderArgs = new Object[]{companyId, repositoryId, path, start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId() && path.equals(dlContent.getPath())) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_P_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_First(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", path=");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_P_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R_P(companyId, repositoryId, path, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_P_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_Last(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", path=");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_P_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R_P(companyId, repositoryId, path);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R_P(companyId, repositoryId, path, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_P_PrevAndNext(long contentId, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        path = Objects.toString(path, "");
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_P_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, true), dlContent, this.getByC_R_P_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_P_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append("dlContent.repositoryId = ? AND ");
        boolean bindPath = false;
        if (path.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
        } else {
            bindPath = true;
            sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (bindPath) {
            queryPos.add(path);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R_P(long companyId, long repositoryId, String path) {
        for (DLContent dlContent : this.findByC_R_P(companyId, repositoryId, path, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R_P(long companyId, long repositoryId, String path) {
        path = Objects.toString(path, "");
        FinderPath finderPath = this._finderPathCountByC_R_P;
        Object[] finderArgs = new Object[]{companyId, repositoryId, path};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_PATH_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, -1, -1, null);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, start, end, null);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findByC_R_LikeP(companyId, repositoryId, path, start, end, orderByComparator, true);
    }

    public List<DLContent> findByC_R_LikeP(long companyId, long repositoryId, String path, int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        path = Objects.toString(path, "");
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        finderPath = this._finderPathWithPaginationFindByC_R_LikeP;
        finderArgs = new Object[]{companyId, repositoryId, path, start, end, orderByComparator};
        List list = null;
        if (useFinderCache && (list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this)) != null && !list.isEmpty()) {
            for (DLContent dlContent : list) {
                if (companyId == dlContent.getCompanyId() && repositoryId == dlContent.getRepositoryId() && StringUtil.wildcardMatches((String)dlContent.getPath(), (String)path, (char)'_', (char)'%', (char)'\\', (boolean)true)) continue;
                list = null;
                break;
            }
        }
        if (list == null) {
            StringBundler sb = null;
            sb = orderByComparator != null ? new StringBundler(5 + orderByComparator.getOrderByFields().length * 2) : new StringBundler(5);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
            }
            if (orderByComparator != null) {
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
            } else {
                sb.append(" ORDER BY dlContent.version DESC");
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public DLContent findByC_R_LikeP_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_LikeP_First(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", pathLIKE");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_LikeP_First(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        List<DLContent> list = this.findByC_R_LikeP(companyId, repositoryId, path, 0, 1, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent findByC_R_LikeP_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_LikeP_Last(companyId, repositoryId, path, orderByComparator);
        if (dlContent != null) {
            return dlContent;
        }
        StringBundler sb = new StringBundler(8);
        sb.append(_NO_SUCH_ENTITY_WITH_KEY);
        sb.append("companyId=");
        sb.append(companyId);
        sb.append(", repositoryId=");
        sb.append(repositoryId);
        sb.append(", pathLIKE");
        sb.append(path);
        sb.append("}");
        throw new NoSuchContentException(sb.toString());
    }

    public DLContent fetchByC_R_LikeP_Last(long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) {
        int count = this.countByC_R_LikeP(companyId, repositoryId, path);
        if (count == 0) {
            return null;
        }
        List<DLContent> list = this.findByC_R_LikeP(companyId, repositoryId, path, count - 1, count, orderByComparator);
        if (!list.isEmpty()) {
            return list.get(0);
        }
        return null;
    }

    public DLContent[] findByC_R_LikeP_PrevAndNext(long contentId, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator) throws NoSuchContentException {
        path = Objects.toString(path, "");
        DLContent dlContent = this.findByPrimaryKey(contentId);
        Session session = null;
        try {
            session = this.openSession();
            DLContent[] array = new DLContentImpl[]{this.getByC_R_LikeP_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, true), dlContent, this.getByC_R_LikeP_PrevAndNext(session, dlContent, companyId, repositoryId, path, orderByComparator, false)};
            DLContent[] dLContentArray = array;
            return dLContentArray;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent getByC_R_LikeP_PrevAndNext(Session session, DLContent dlContent, long companyId, long repositoryId, String path, OrderByComparator<DLContent> orderByComparator, boolean previous) {
        List list;
        StringBundler sb = null;
        sb = orderByComparator != null ? new StringBundler(6 + orderByComparator.getOrderByConditionFields().length * 3 + orderByComparator.getOrderByFields().length * 3) : new StringBundler(5);
        sb.append(_SQL_SELECT_DLCONTENT_WHERE);
        sb.append("dlContent.companyId = ? AND ");
        sb.append("dlContent.repositoryId = ? AND ");
        boolean bindPath = false;
        if (path.isEmpty()) {
            sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
        } else {
            bindPath = true;
            sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
        }
        if (orderByComparator != null) {
            String[] orderByConditionFields = orderByComparator.getOrderByConditionFields();
            if (orderByConditionFields.length > 0) {
                sb.append(" AND ");
            }
            for (int i = 0; i < orderByConditionFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByConditionFields[i]);
                if (i + 1 < orderByConditionFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" >= ? AND ");
                        continue;
                    }
                    sb.append(" <= ? AND ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" >= ? ");
                    continue;
                }
                sb.append(" <= ? ");
            }
            sb.append(" ORDER BY ");
            String[] orderByFields = orderByComparator.getOrderByFields();
            for (int i = 0; i < orderByFields.length; ++i) {
                sb.append(_ORDER_BY_ENTITY_ALIAS);
                sb.append(orderByFields[i]);
                if (i + 1 < orderByFields.length) {
                    if (orderByComparator.isAscending() ^ previous) {
                        sb.append(" ASC, ");
                        continue;
                    }
                    sb.append(" DESC, ");
                    continue;
                }
                if (orderByComparator.isAscending() ^ previous) {
                    sb.append(" ASC");
                    continue;
                }
                sb.append(" DESC");
            }
        } else {
            sb.append(" ORDER BY dlContent.version DESC");
        }
        String sql = sb.toString();
        Query query = session.createQuery(sql);
        query.setFirstResult(0);
        query.setMaxResults(2);
        QueryPos queryPos = QueryPos.getInstance((Query)query);
        queryPos.add(companyId);
        queryPos.add(repositoryId);
        if (bindPath) {
            queryPos.add(path);
        }
        if (orderByComparator != null) {
            for (Object orderByConditionValue : orderByComparator.getOrderByConditionValues((Object)dlContent)) {
                queryPos.add(orderByConditionValue);
            }
        }
        if ((list = query.list()).size() == 2) {
            return (DLContent)list.get(1);
        }
        return null;
    }

    public void removeByC_R_LikeP(long companyId, long repositoryId, String path) {
        for (DLContent dlContent : this.findByC_R_LikeP(companyId, repositoryId, path, -1, -1, null)) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countByC_R_LikeP(long companyId, long repositoryId, String path) {
        path = Objects.toString(path, "");
        FinderPath finderPath = this._finderPathWithPaginationCountByC_R_LikeP;
        Object[] finderArgs = new Object[]{companyId, repositoryId, path};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(4);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_LIKEP_PATH_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLContent findByC_R_P_V(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        DLContent dlContent = this.fetchByC_R_P_V(companyId, repositoryId, path, version);
        if (dlContent == null) {
            StringBundler sb = new StringBundler(10);
            sb.append(_NO_SUCH_ENTITY_WITH_KEY);
            sb.append("companyId=");
            sb.append(companyId);
            sb.append(", repositoryId=");
            sb.append(repositoryId);
            sb.append(", path=");
            sb.append(path);
            sb.append(", version=");
            sb.append(version);
            sb.append("}");
            if (_log.isDebugEnabled()) {
                _log.debug((Object)sb.toString());
            }
            throw new NoSuchContentException(sb.toString());
        }
        return dlContent;
    }

    public DLContent fetchByC_R_P_V(long companyId, long repositoryId, String path, String version) {
        return this.fetchByC_R_P_V(companyId, repositoryId, path, version, true);
    }

    public DLContent fetchByC_R_P_V(long companyId, long repositoryId, String path, String version, boolean useFinderCache) {
        DLContent dlContent;
        path = Objects.toString(path, "");
        version = Objects.toString(version, "");
        Object[] finderArgs = null;
        if (useFinderCache) {
            finderArgs = new Object[]{companyId, repositoryId, path, version};
        }
        Object result = null;
        if (useFinderCache) {
            result = this.finderCache.getResult(this._finderPathFetchByC_R_P_V, finderArgs, (BasePersistenceImpl)this);
        }
        if (!(!(result instanceof DLContent) || companyId == (dlContent = (DLContent)result).getCompanyId() && repositoryId == dlContent.getRepositoryId() && Objects.equals(path, dlContent.getPath()) && Objects.equals(version, dlContent.getVersion()))) {
            result = null;
        }
        if (result == null) {
            StringBundler sb = new StringBundler(6);
            sb.append(_SQL_SELECT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                List list;
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                if (bindVersion) {
                    queryPos.add(version);
                }
                if ((list = query.list()).isEmpty()) {
                    if (useFinderCache) {
                        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, finderArgs, (Object)list);
                    }
                } else {
                    DLContent dlContent2 = (DLContent)list.get(0);
                    result = dlContent2;
                    this.cacheResult(dlContent2);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(this._finderPathFetchByC_R_P_V, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        if (result instanceof List) {
            return null;
        }
        return (DLContent)result;
    }

    public DLContent removeByC_R_P_V(long companyId, long repositoryId, String path, String version) throws NoSuchContentException {
        DLContent dlContent = this.findByC_R_P_V(companyId, repositoryId, path, version);
        return (DLContent)this.remove((BaseModel)dlContent);
    }

    public int countByC_R_P_V(long companyId, long repositoryId, String path, String version) {
        path = Objects.toString(path, "");
        version = Objects.toString(version, "");
        FinderPath finderPath = this._finderPathCountByC_R_P_V;
        Object[] finderArgs = new Object[]{companyId, repositoryId, path, version};
        Long count = (Long)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        if (count == null) {
            StringBundler sb = new StringBundler(5);
            sb.append(_SQL_COUNT_DLCONTENT_WHERE);
            sb.append("dlContent.companyId = ? AND ");
            sb.append("dlContent.repositoryId = ? AND ");
            boolean bindPath = false;
            if (path.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_3);
            } else {
                bindPath = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_PATH_2);
            }
            boolean bindVersion = false;
            if (version.isEmpty()) {
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_3);
            } else {
                bindVersion = true;
                sb.append(_FINDER_COLUMN_C_R_P_V_VERSION_2);
            }
            String sql = sb.toString();
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                QueryPos queryPos = QueryPos.getInstance((Query)query);
                queryPos.add(companyId);
                queryPos.add(repositoryId);
                if (bindPath) {
                    queryPos.add(path);
                }
                if (bindVersion) {
                    queryPos.add(version);
                }
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(finderPath, finderArgs, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(finderPath, finderArgs);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public DLContentPersistenceImpl() {
        HashMap<String, String> dbColumnNames = new HashMap<String, String>();
        dbColumnNames.put("path", "path_");
        dbColumnNames.put("data", "data_");
        dbColumnNames.put("size", "size_");
        this.setDBColumnNames(dbColumnNames);
        this.setModelClass(DLContent.class);
        this.setModelImplClass(DLContentImpl.class);
        this.setModelPKClass(Long.TYPE);
    }

    public void cacheResult(DLContent dlContent) {
        this.entityCache.putResult(this.entityCacheEnabled, DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey()), (Serializable)dlContent);
        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, new Object[]{dlContent.getCompanyId(), dlContent.getRepositoryId(), dlContent.getPath(), dlContent.getVersion()}, (Object)dlContent);
        dlContent.resetOriginalValues();
    }

    public void cacheResult(List<DLContent> dlContents) {
        if (this._valueObjectFinderCacheListThreshold == 0 || this._valueObjectFinderCacheListThreshold > 0 && dlContents.size() > this._valueObjectFinderCacheListThreshold) {
            return;
        }
        for (DLContent dlContent : dlContents) {
            if (this.entityCache.getResult(this.entityCacheEnabled, DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey())) == null) {
                this.cacheResult(dlContent);
                continue;
            }
            dlContent.resetOriginalValues();
        }
    }

    public void clearCache() {
        this.entityCache.clearCache(DLContentImpl.class);
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    public void clearCache(DLContent dlContent) {
        this.entityCache.removeResult(this.entityCacheEnabled, DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey()));
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        this.clearUniqueFindersCache((DLContentModelImpl)dlContent, true);
    }

    public void clearCache(List<DLContent> dlContents) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (DLContent dlContent : dlContents) {
            this.entityCache.removeResult(this.entityCacheEnabled, DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey()));
            this.clearUniqueFindersCache((DLContentModelImpl)dlContent, true);
        }
    }

    public void clearCache(Set<Serializable> primaryKeys) {
        this.finderCache.clearCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        for (Serializable primaryKey : primaryKeys) {
            this.entityCache.removeResult(this.entityCacheEnabled, DLContentImpl.class, primaryKey);
        }
    }

    protected void cacheUniqueFindersCache(DLContentModelImpl dlContentModelImpl) {
        Object[] args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId(), dlContentModelImpl.getPath(), dlContentModelImpl.getVersion()};
        this.finderCache.putResult(this._finderPathCountByC_R_P_V, args, (Object)1L, false);
        this.finderCache.putResult(this._finderPathFetchByC_R_P_V, args, (Object)dlContentModelImpl, false);
    }

    protected void clearUniqueFindersCache(DLContentModelImpl dlContentModelImpl, boolean clearCurrent) {
        Object[] args;
        if (clearCurrent) {
            args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId(), dlContentModelImpl.getPath(), dlContentModelImpl.getVersion()};
            this.finderCache.removeResult(this._finderPathCountByC_R_P_V, args);
            this.finderCache.removeResult(this._finderPathFetchByC_R_P_V, args);
        }
        if ((dlContentModelImpl.getColumnBitmask() & this._finderPathFetchByC_R_P_V.getColumnBitmask()) != 0L) {
            args = new Object[]{dlContentModelImpl.getOriginalCompanyId(), dlContentModelImpl.getOriginalRepositoryId(), dlContentModelImpl.getOriginalPath(), dlContentModelImpl.getOriginalVersion()};
            this.finderCache.removeResult(this._finderPathCountByC_R_P_V, args);
            this.finderCache.removeResult(this._finderPathFetchByC_R_P_V, args);
        }
    }

    public DLContent create(long contentId) {
        DLContentImpl dlContent = new DLContentImpl();
        dlContent.setNew(true);
        dlContent.setPrimaryKey(contentId);
        dlContent.setCompanyId(CompanyThreadLocal.getCompanyId());
        return dlContent;
    }

    public DLContent remove(long contentId) throws NoSuchContentException {
        return this.remove(Long.valueOf(contentId));
    }

    public DLContent remove(Serializable primaryKey) throws NoSuchContentException {
        Session session = null;
        try {
            session = this.openSession();
            DLContent dlContent = (DLContent)session.get(DLContentImpl.class, primaryKey);
            if (dlContent == null) {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
                }
                throw new NoSuchContentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
            }
            DLContent dLContent = (DLContent)this.remove((BaseModel)dlContent);
            return dLContent;
        }
        catch (NoSuchContentException noSuchEntityException) {
            throw noSuchEntityException;
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
    }

    protected DLContent removeImpl(DLContent dlContent) {
        Session session = null;
        try {
            session = this.openSession();
            if (!session.contains((Object)dlContent)) {
                dlContent = (DLContent)session.get(DLContentImpl.class, dlContent.getPrimaryKeyObj());
            }
            if (dlContent != null) {
                session.delete((Object)dlContent);
            }
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        if (dlContent != null) {
            this.clearCache(dlContent);
        }
        return dlContent;
    }

    public DLContent updateImpl(DLContent dlContent) {
        boolean isNew = dlContent.isNew();
        if (!(dlContent instanceof DLContentModelImpl)) {
            InvocationHandler invocationHandler = null;
            if (ProxyUtil.isProxyClass(dlContent.getClass())) {
                invocationHandler = ProxyUtil.getInvocationHandler((Object)dlContent);
                throw new IllegalArgumentException("Implement ModelWrapper in dlContent proxy " + invocationHandler.getClass());
            }
            throw new IllegalArgumentException("Implement ModelWrapper in custom DLContent implementation " + dlContent.getClass());
        }
        DLContentModelImpl dlContentModelImpl = (DLContentModelImpl)dlContent;
        Session session = null;
        try {
            session = this.openSession();
            if (isNew) {
                session.save((Object)dlContent);
                dlContent.setNew(false);
            } else {
                session.evict((Object)dlContent);
                session.saveOrUpdate((Object)dlContent);
            }
            session.flush();
            session.clear();
        }
        catch (Exception exception) {
            throw this.processException(exception);
        }
        finally {
            this.closeSession(session);
        }
        this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        if (!this._columnBitmaskEnabled) {
            this.finderCache.clearCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
        } else if (isNew) {
            Object[] args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId()};
            this.finderCache.removeResult(this._finderPathCountByC_R, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
            args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId(), dlContentModelImpl.getPath()};
            this.finderCache.removeResult(this._finderPathCountByC_R_P, args);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R_P, args);
            this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
            this.finderCache.removeResult(this._finderPathWithoutPaginationFindAll, FINDER_ARGS_EMPTY);
        } else {
            Object[] args;
            if ((dlContentModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_R.getColumnBitmask()) != 0L) {
                args = new Object[]{dlContentModelImpl.getOriginalCompanyId(), dlContentModelImpl.getOriginalRepositoryId()};
                this.finderCache.removeResult(this._finderPathCountByC_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
                args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId()};
                this.finderCache.removeResult(this._finderPathCountByC_R, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R, args);
            }
            if ((dlContentModelImpl.getColumnBitmask() & this._finderPathWithoutPaginationFindByC_R_P.getColumnBitmask()) != 0L) {
                args = new Object[]{dlContentModelImpl.getOriginalCompanyId(), dlContentModelImpl.getOriginalRepositoryId(), dlContentModelImpl.getOriginalPath()};
                this.finderCache.removeResult(this._finderPathCountByC_R_P, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R_P, args);
                args = new Object[]{dlContentModelImpl.getCompanyId(), dlContentModelImpl.getRepositoryId(), dlContentModelImpl.getPath()};
                this.finderCache.removeResult(this._finderPathCountByC_R_P, args);
                this.finderCache.removeResult(this._finderPathWithoutPaginationFindByC_R_P, args);
            }
        }
        this.entityCache.putResult(this.entityCacheEnabled, DLContentImpl.class, (Serializable)Long.valueOf(dlContent.getPrimaryKey()), (Serializable)dlContent, false);
        this.clearUniqueFindersCache(dlContentModelImpl, false);
        this.cacheUniqueFindersCache(dlContentModelImpl);
        dlContent.resetOriginalValues();
        return dlContent;
    }

    public DLContent findByPrimaryKey(Serializable primaryKey) throws NoSuchContentException {
        DLContent dlContent = (DLContent)this.fetchByPrimaryKey(primaryKey);
        if (dlContent == null) {
            if (_log.isDebugEnabled()) {
                _log.debug((Object)(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey));
            }
            throw new NoSuchContentException(_NO_SUCH_ENTITY_WITH_PRIMARY_KEY + primaryKey);
        }
        return dlContent;
    }

    public DLContent findByPrimaryKey(long contentId) throws NoSuchContentException {
        return this.findByPrimaryKey(Long.valueOf(contentId));
    }

    public DLContent fetchByPrimaryKey(long contentId) {
        return (DLContent)this.fetchByPrimaryKey(Long.valueOf(contentId));
    }

    public List<DLContent> findAll() {
        return this.findAll(-1, -1, null);
    }

    public List<DLContent> findAll(int start, int end) {
        return this.findAll(start, end, null);
    }

    public List<DLContent> findAll(int start, int end, OrderByComparator<DLContent> orderByComparator) {
        return this.findAll(start, end, orderByComparator, true);
    }

    public List<DLContent> findAll(int start, int end, OrderByComparator<DLContent> orderByComparator, boolean useFinderCache) {
        FinderPath finderPath = null;
        Object[] finderArgs = null;
        if (start == -1 && end == -1 && orderByComparator == null) {
            if (useFinderCache) {
                finderPath = this._finderPathWithoutPaginationFindAll;
                finderArgs = FINDER_ARGS_EMPTY;
            }
        } else if (useFinderCache) {
            finderPath = this._finderPathWithPaginationFindAll;
            finderArgs = new Object[]{start, end, orderByComparator};
        }
        List list = null;
        if (useFinderCache) {
            list = (List)this.finderCache.getResult(finderPath, finderArgs, (BasePersistenceImpl)this);
        }
        if (list == null) {
            StringBundler sb = null;
            String sql = null;
            if (orderByComparator != null) {
                sb = new StringBundler(2 + orderByComparator.getOrderByFields().length * 2);
                sb.append(_SQL_SELECT_DLCONTENT);
                this.appendOrderByComparator(sb, _ORDER_BY_ENTITY_ALIAS, orderByComparator);
                sql = sb.toString();
            } else {
                sql = _SQL_SELECT_DLCONTENT;
                sql = sql.concat(" ORDER BY dlContent.version DESC");
            }
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(sql);
                list = QueryUtil.list((Query)query, (Dialect)this.getDialect(), (int)start, (int)end);
                this.cacheResult(list);
                if (useFinderCache) {
                    this.finderCache.putResult(finderPath, finderArgs, (Object)list);
                }
            }
            catch (Exception exception) {
                if (useFinderCache) {
                    this.finderCache.removeResult(finderPath, finderArgs);
                }
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return list;
    }

    public void removeAll() {
        for (DLContent dlContent : this.findAll()) {
            this.remove((BaseModel)dlContent);
        }
    }

    public int countAll() {
        Long count = (Long)this.finderCache.getResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (BasePersistenceImpl)this);
        if (count == null) {
            Session session = null;
            try {
                session = this.openSession();
                Query query = session.createQuery(_SQL_COUNT_DLCONTENT);
                count = (Long)query.uniqueResult();
                this.finderCache.putResult(this._finderPathCountAll, FINDER_ARGS_EMPTY, (Object)count);
            }
            catch (Exception exception) {
                this.finderCache.removeResult(this._finderPathCountAll, FINDER_ARGS_EMPTY);
                throw this.processException(exception);
            }
            finally {
                this.closeSession(session);
            }
        }
        return count.intValue();
    }

    public Set<String> getBadColumnNames() {
        return _badColumnNames;
    }

    protected EntityCache getEntityCache() {
        return this.entityCache;
    }

    protected String getPKDBName() {
        return "contentId";
    }

    protected String getSelectSQL() {
        return _SQL_SELECT_DLCONTENT;
    }

    protected Map<String, Integer> getTableColumnsMap() {
        return DLContentModelImpl.TABLE_COLUMNS_MAP;
    }

    @Activate
    public void activate() {
        DLContentModelImpl.setEntityCacheEnabled(this.entityCacheEnabled);
        DLContentModelImpl.setFinderCacheEnabled(this.finderCacheEnabled);
        this._valueObjectFinderCacheListThreshold = GetterUtil.getInteger((String)PropsUtil.get((String)"value.object.finder.cache.list.threshold"));
        this._finderPathWithPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findAll", new String[0]);
        this._finderPathWithoutPaginationFindAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findAll", new String[0]);
        this._finderPathCountAll = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countAll", new String[0]);
        this._finderPathWithPaginationFindByC_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Long.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_R", new String[]{Long.class.getName(), Long.class.getName()}, 13L);
        this._finderPathCountByC_R = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R", new String[]{Long.class.getName(), Long.class.getName()});
        this._finderPathWithPaginationFindByC_R_P = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithoutPaginationFindByC_R_P = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "findByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()}, 15L);
        this._finderPathCountByC_R_P = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R_P", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
        this._finderPathWithPaginationFindByC_R_LikeP = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "findByC_R_LikeP", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), Integer.class.getName(), Integer.class.getName(), OrderByComparator.class.getName()});
        this._finderPathWithPaginationCountByC_R_LikeP = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITH_PAGINATION, "countByC_R_LikeP", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName()});
        this._finderPathFetchByC_R_P_V = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, DLContentImpl.class, FINDER_CLASS_NAME_ENTITY, "fetchByC_R_P_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()}, 15L);
        this._finderPathCountByC_R_P_V = new FinderPath(this.entityCacheEnabled, this.finderCacheEnabled, Long.class, FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION, "countByC_R_P_V", new String[]{Long.class.getName(), Long.class.getName(), String.class.getName(), String.class.getName()});
        this._setDLContentUtilPersistence(this);
    }

    @Deactivate
    public void deactivate() {
        this._setDLContentUtilPersistence(null);
        this.entityCache.removeCache(DLContentImpl.class.getName());
        this.finderCache.removeCache(FINDER_CLASS_NAME_ENTITY);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITH_PAGINATION);
        this.finderCache.removeCache(FINDER_CLASS_NAME_LIST_WITHOUT_PAGINATION);
    }

    private void _setDLContentUtilPersistence(DLContentPersistence dlContentPersistence) {
        try {
            Field field = DLContentUtil.class.getDeclaredField("_persistence");
            field.setAccessible(true);
            field.set(null, dlContentPersistence);
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            throw new RuntimeException(reflectiveOperationException);
        }
    }

    @Reference(target="(&(origin.bundle.symbolic.name=com.liferay.document.library.content.service)(name=service))", unbind="-")
    public void setConfiguration(Configuration configuration) {
        super.setConfiguration(configuration);
        this._columnBitmaskEnabled = GetterUtil.getBoolean((String)configuration.get("value.object.column.bitmask.enabled.com.liferay.document.library.content.model.DLContent"), (boolean)true);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.content.service)", unbind="-")
    public void setDataSource(DataSource dataSource) {
        super.setDataSource(dataSource);
    }

    @Reference(target="(origin.bundle.symbolic.name=com.liferay.document.library.content.service)", unbind="-")
    public void setSessionFactory(SessionFactory sessionFactory) {
        super.setSessionFactory(sessionFactory);
    }
}

