/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.document.library.model;

import org.osgi.annotation.versioning.ProviderType;

import com.liferay.portal.kernel.model.BaseModel;

/**
 * The base model interface for the FileVersionPreview service. Represents a row in the &quot;FileVersionPreview&quot; database table, with each column mapped to a property of this class.
 *
 * <p>
 * This interface and its corresponding implementation {@link com.liferay.document.library.model.impl.FileVersionPreviewModelImpl} exist only as a container for the default property accessors generated by ServiceBuilder. Helper methods and all application logic should be put in {@link com.liferay.document.library.model.impl.FileVersionPreviewImpl}.
 * </p>
 *
 * @author Brian Wing Shun Chan
 * @see FileVersionPreview
 * @see com.liferay.document.library.model.impl.FileVersionPreviewImpl
 * @see com.liferay.document.library.model.impl.FileVersionPreviewModelImpl
 * @generated
 */
@ProviderType
public interface FileVersionPreviewModel extends BaseModel<FileVersionPreview> {
	/*
	 * NOTE FOR DEVELOPERS:
	 *
	 * Never modify or reference this interface directly. All methods that expect a file version preview model instance should use the {@link FileVersionPreview} interface instead.
	 */

	/**
	 * Returns the primary key of this file version preview.
	 *
	 * @return the primary key of this file version preview
	 */
	public long getPrimaryKey();

	/**
	 * Sets the primary key of this file version preview.
	 *
	 * @param primaryKey the primary key of this file version preview
	 */
	public void setPrimaryKey(long primaryKey);

	/**
	 * Returns the file version preview ID of this file version preview.
	 *
	 * @return the file version preview ID of this file version preview
	 */
	public long getFileVersionPreviewId();

	/**
	 * Sets the file version preview ID of this file version preview.
	 *
	 * @param fileVersionPreviewId the file version preview ID of this file version preview
	 */
	public void setFileVersionPreviewId(long fileVersionPreviewId);

	/**
	 * Returns the group ID of this file version preview.
	 *
	 * @return the group ID of this file version preview
	 */
	public long getGroupId();

	/**
	 * Sets the group ID of this file version preview.
	 *
	 * @param groupId the group ID of this file version preview
	 */
	public void setGroupId(long groupId);

	/**
	 * Returns the file entry ID of this file version preview.
	 *
	 * @return the file entry ID of this file version preview
	 */
	public long getFileEntryId();

	/**
	 * Sets the file entry ID of this file version preview.
	 *
	 * @param fileEntryId the file entry ID of this file version preview
	 */
	public void setFileEntryId(long fileEntryId);

	/**
	 * Returns the file version ID of this file version preview.
	 *
	 * @return the file version ID of this file version preview
	 */
	public long getFileVersionId();

	/**
	 * Sets the file version ID of this file version preview.
	 *
	 * @param fileVersionId the file version ID of this file version preview
	 */
	public void setFileVersionId(long fileVersionId);

	/**
	 * Returns the preview status of this file version preview.
	 *
	 * @return the preview status of this file version preview
	 */
	public int getPreviewStatus();

	/**
	 * Sets the preview status of this file version preview.
	 *
	 * @param previewStatus the preview status of this file version preview
	 */
	public void setPreviewStatus(int previewStatus);
}