/*
 * Decompiled with CFR 0.152.
 */
package com.liferay.dispatch.talend.archive;

import com.liferay.dispatch.talend.archive.TalendArchive;
import com.liferay.dispatch.talend.archive.exception.TalendArchiveException;
import com.liferay.petra.string.StringBundler;
import com.liferay.portal.kernel.exception.PortalException;
import com.liferay.portal.kernel.util.FileUtil;
import com.liferay.portal.kernel.util.StringUtil;
import com.liferay.portal.kernel.util.UnicodeProperties;
import com.liferay.portal.kernel.util.Validator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class TalendArchiveParserUtil {
    public static String getJVMOptions(String newJVMOptions, String oldJVMOptions) {
        String[] jvmOptions = newJVMOptions.split("\\s");
        StringBundler sb = new StringBundler(jvmOptions.length * 2 + 1);
        for (String newJVMOption : jvmOptions) {
            if (oldJVMOptions.contains(newJVMOption)) continue;
            sb.append(newJVMOption);
            sb.append(" ");
        }
        sb.append(oldJVMOptions);
        return sb.toString();
    }

    public static TalendArchive parse(InputStream jobArchiveInputStream) throws PortalException {
        try {
            return TalendArchiveParserUtil._parse(jobArchiveInputStream);
        }
        catch (Exception exception) {
            throw new TalendArchiveException("Unable to parse Talend archive", exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateUnicodeProperties(InputStream jobArchiveInputStream, UnicodeProperties unicodeProperties) throws PortalException {
        TalendArchive talendArchive = TalendArchiveParserUtil.parse(jobArchiveInputStream);
        try {
            if (talendArchive.hasJVMOptions()) {
                String newJVMOptions = talendArchive.getJVMOptions();
                if (unicodeProperties.containsKey((Object)"JAVA_OPTS")) {
                    newJVMOptions = TalendArchiveParserUtil.getJVMOptions(newJVMOptions, (String)unicodeProperties.get((Object)"JAVA_OPTS"));
                }
                unicodeProperties.put("JAVA_OPTS", newJVMOptions);
            } else {
                unicodeProperties.put("JAVA_OPTS", "-Xms256M -Xmx1024M");
            }
            Properties contextProperties = talendArchive.getContextProperties();
            for (String propertyName : contextProperties.stringPropertyNames()) {
                if (unicodeProperties.containsKey((Object)propertyName)) continue;
                unicodeProperties.put(propertyName, contextProperties.getProperty(propertyName) + " (Automatic Copy)");
            }
        }
        finally {
            FileUtil.deltree((String)talendArchive.getJobDirectory());
        }
    }

    private static void _addJVMOptionsList(List<String> jvmOptionsList, String commandLine) {
        String[] tokens;
        if (Validator.isNull((String)commandLine) || !commandLine.startsWith("java")) {
            return;
        }
        for (String token : tokens = commandLine.split("\\s")) {
            if (token.startsWith("\"") || token.startsWith("'")) {
                token = token.substring(1);
            }
            if (token.endsWith("\"") || token.endsWith("'")) {
                token = token.substring(0, token.length() - 1);
            }
            if (!token.startsWith("-X")) continue;
            jvmOptionsList.add(token);
        }
    }

    private static Properties _getContextProperties(String contextName, String jobExecutableJarPath) throws IOException {
        Properties properties = new Properties();
        String contextPropertiesSuffix = contextName + ".properties";
        try (ZipFile zipFile = new ZipFile(new File(jobExecutableJarPath));){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(contextPropertiesSuffix)) continue;
                properties.load(zipFile.getInputStream(zipEntry));
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File _getJobDirectory(InputStream jobArchiveInputStream) throws IOException {
        File tempFile = FileUtil.createTempFile((InputStream)jobArchiveInputStream);
        try {
            File tempFolder = FileUtil.createTempFolder();
            FileUtil.unzip((File)tempFile, (File)tempFolder);
            File file = tempFolder;
            return file;
        }
        finally {
            if (tempFile != null) {
                FileUtil.delete((File)tempFile);
            }
        }
    }

    private static Path _getJobJarPath(String jobName, Path jobDirectoryPath, String jobVersion) {
        String jarName = StringBundler.concat((String[])new String[]{jobName, "/", jobName, "_", StringUtil.replace((String)jobVersion, (char)'.', (char)'_'), ".jar"});
        Path jobJarPath = jobDirectoryPath.resolve(StringUtil.toLowerCase((String)jarName));
        if (jobJarPath != null) {
            return jobJarPath;
        }
        throw new IllegalArgumentException("Unable to determine job JAR directory for " + jobName);
    }

    private static List<String> _getJobLibEntries(Path jobDirectoryPath) throws IOException {
        final ArrayList<String> pathStrings = new ArrayList<String>();
        Files.walkFileTree(jobDirectoryPath.resolve("lib"), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                String pathString = filePath.toString();
                if (pathString.endsWith(".jar")) {
                    pathStrings.add(pathString);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        pathStrings.sort(null);
        return pathStrings;
    }

    private static String _getJobMainClassFQN(String jobName, String jobExecutableJarPath) throws IOException {
        String mainClassSuffix = jobName + ".class";
        try (ZipFile zipFile = new ZipFile(new File(jobExecutableJarPath));){
            Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zipEntry = enumeration.nextElement();
                String name = zipEntry.getName();
                if (!name.endsWith(mainClassSuffix)) continue;
                name = name.substring(0, name.length() - 6);
                String string = StringUtil.replace((String)name, (char)'/', (char)'.');
                return string;
            }
        }
        throw new IllegalArgumentException("Unable to determine job main class");
    }

    private static Properties _getJobProperties(File jobDirectory) throws IOException {
        Properties properties = new Properties();
        try (FileInputStream inputStream = new FileInputStream(new File(jobDirectory, "jobInfo.properties"));){
            properties.load(inputStream);
        }
        return properties;
    }

    private static List<String> _getJobScriptPathStrings(Path jobDirectoryPath) throws IOException {
        final ArrayList<String> pathStrings = new ArrayList<String>();
        Files.walkFileTree(jobDirectoryPath, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) {
                String pathString = filePath.toString();
                if (pathString.endsWith(".bat") || pathString.endsWith(".ps1") || pathString.endsWith(".sh")) {
                    pathStrings.add(pathString);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        pathStrings.sort(null);
        return pathStrings;
    }

    private static List<String> _getJVMOptionsList(File jobDirectory, String jobName) throws IOException {
        Path path = jobDirectory.toPath();
        List<String> jobScriptPathStrings = TalendArchiveParserUtil._getJobScriptPathStrings(path.resolve(jobName));
        ArrayList<String> jvmOptionsList = new ArrayList<String>();
        for (String jobScriptPathString : jobScriptPathStrings) {
            BufferedReader bufferedReader = new BufferedReader(new FileReader(jobScriptPathString));
            Throwable throwable = null;
            try {
                String line = bufferedReader.readLine();
                while (line != null) {
                    TalendArchiveParserUtil._addJVMOptionsList(jvmOptionsList, line);
                    line = bufferedReader.readLine();
                }
                if (jvmOptionsList.isEmpty()) continue;
                break;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (bufferedReader == null) continue;
                if (throwable != null) {
                    try {
                        bufferedReader.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                bufferedReader.close();
            }
        }
        return jvmOptionsList;
    }

    private static List<String> _getSubjobEntries(Path jobDirectoryPath, String jobName) throws IOException {
        final ArrayList<String> pathStrings = new ArrayList<String>();
        Files.walkFileTree(jobDirectoryPath.resolve(jobName), (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path filePath, BasicFileAttributes basicFileAttributes) throws IOException {
                String pathString = filePath.toString();
                if (pathString.endsWith(".jar")) {
                    pathStrings.add(pathString);
                }
                return FileVisitResult.CONTINUE;
            }
        });
        return pathStrings;
    }

    private static TalendArchive _parse(InputStream jobZIPInputStream) throws IOException {
        TalendArchive.Builder talendArchiveBuilder = new TalendArchive.Builder();
        File jobDirectory = TalendArchiveParserUtil._getJobDirectory(jobZIPInputStream);
        Path jobDirectoryPath = jobDirectory.toPath();
        List<String> classPathEntries = TalendArchiveParserUtil._getJobLibEntries(jobDirectoryPath);
        Properties jobProperties = TalendArchiveParserUtil._getJobProperties(jobDirectory);
        String jobName = (String)jobProperties.get("job");
        classPathEntries.addAll(TalendArchiveParserUtil._getSubjobEntries(jobDirectoryPath, jobName));
        talendArchiveBuilder.classPathEntries(classPathEntries);
        String contextName = (String)jobProperties.get("contextName");
        talendArchiveBuilder.contextName(contextName);
        Path jobJarPath = TalendArchiveParserUtil._getJobJarPath(jobName, jobDirectoryPath, (String)jobProperties.get("jobVersion"));
        talendArchiveBuilder.contextProperties(TalendArchiveParserUtil._getContextProperties(contextName, jobJarPath.toString()));
        talendArchiveBuilder.jobDirectory(jobDirectory.getAbsolutePath());
        Path jobJarParentDirectoryPath = jobJarPath.getParent();
        talendArchiveBuilder.jobJarParentDirectory(jobJarParentDirectoryPath.toString());
        talendArchiveBuilder.jobJarPath(jobJarPath.toString());
        talendArchiveBuilder.jobMainClassFQN(TalendArchiveParserUtil._getJobMainClassFQN(jobName, jobJarPath.toString()));
        talendArchiveBuilder.jvmOptionsList(TalendArchiveParserUtil._getJVMOptionsList(jobDirectory, jobName));
        return talendArchiveBuilder.build();
    }
}

