/**
 * Copyright (c) 2000-present Liferay, Inc. All rights reserved.
 *
 * This library is free software; you can redistribute it and/or modify it under
 * the terms of the GNU Lesser General Public License as published by the Free
 * Software Foundation; either version 2.1 of the License, or (at your option)
 * any later version.
 *
 * This library is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
 * FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License for more
 * details.
 */

package com.liferay.data.engine.internal.upgrade.registry;

import com.liferay.data.engine.internal.upgrade.v1_0_0.SchemaUpgradeProcess;
import com.liferay.data.engine.internal.upgrade.v2_0_0.UpgradeCompanyId;
import com.liferay.portal.kernel.upgrade.CTModelUpgradeProcess;
import com.liferay.portal.kernel.upgrade.DummyUpgradeStep;
import com.liferay.portal.kernel.upgrade.MVCCVersionUpgradeProcess;
import com.liferay.portal.kernel.upgrade.UpgradeProcessFactory;
import com.liferay.portal.upgrade.registry.UpgradeStepRegistrator;

import org.osgi.service.component.annotations.Component;

/**
 * @author Jeyvison Nascimento
 */
@Component(
	service = {
		DEServiceUpgradeStepRegistrator.class, UpgradeStepRegistrator.class
	}
)
public class DEServiceUpgradeStepRegistrator implements UpgradeStepRegistrator {

	@Override
	public void register(Registry registry) {
		registry.register("1.0.0", "1.1.0", new SchemaUpgradeProcess());

		registry.register("1.1.0", "1.1.1", new DummyUpgradeStep());

		registry.register("1.1.1", "2.0.0", new UpgradeCompanyId());

		registry.register(
			"2.0.0", "2.1.0",
			UpgradeProcessFactory.addColumns(
				"DEDataDefinitionFieldLink", "createDate DATE null",
				"modifiedDate DATE null", "lastPublishDate DATE null"));

		registry.register(
			"2.1.0", "2.1.1",
			UpgradeProcessFactory.alterColumnType(
				"DEDataDefinitionFieldLink", "fieldName", "VARCHAR(75) null"));

		registry.register(
			"2.1.1", "2.2.0",
			new MVCCVersionUpgradeProcess() {

				@Override
				protected String[] getTableNames() {
					return new String[] {
						"DEDataDefinitionFieldLink", "DEDataListView"
					};
				}

			},
			new CTModelUpgradeProcess(
				"DEDataDefinitionFieldLink", "DEDataListView"));

		registry.register(
			"2.2.0", "2.2.1",
			UpgradeProcessFactory.alterColumnType(
				"DEDataDefinitionFieldLink", "fieldName", "VARCHAR(255) null"));
	}

}